/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.execution;

import java.io.IOException;
import org.netbeans.modules.cnd.execution.ExecutionSupport;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public final class CompileExecSupport
extends ExecutionSupport {
    private static final String PROP_RUN_DIRECTORY = "rundirectory";
    private static final String PROP_COMPILE_FLAGS = "compileflags";
    private static final String PROP_LINK_FLAGS = "linkflags";

    public CompileExecSupport(MultiDataObject.Entry entry) {
        super(entry);
    }

    @Override
    public void addProperties(Sheet.Set set) {
        set.put(this.createCompileFlagsProperty());
    }

    private PropertySupport<String> createRunDirectoryProperty() {
        return new PropertySupport.ReadWrite<String>(PROP_RUN_DIRECTORY, String.class, this.getString("PROP_RUN_DIRECTORY"), this.getString("HINT_RUN_DIRECTORY")){

            public String getValue() {
                return CompileExecSupport.this.getRunDirectory();
            }

            public void setValue(String val) {
                CompileExecSupport.this.setRunDirectory(val);
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() {
                this.setValue(null);
            }

            public boolean canWrite() {
                return CompileExecSupport.this.getEntry().getFile().getParent().canWrite();
            }
        };
    }

    public String getRunDirectory() {
        String dir = (String)this.getEntry().getFile().getAttribute(PROP_RUN_DIRECTORY);
        if (dir == null) {
            dir = ".";
            this.setRunDirectory(dir);
        }
        return dir;
    }

    public void setRunDirectory(String dir) {
        block2: {
            try {
                this.getEntry().getFile().setAttribute(PROP_RUN_DIRECTORY, (Object)dir);
            }
            catch (IOException ex) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block2;
                ex.printStackTrace(System.err);
            }
        }
    }

    private PropertySupport<String> createCompileFlagsProperty() {
        return new PropertySupport.ReadWrite<String>(PROP_COMPILE_FLAGS, String.class, this.getString("PROP_COMPILE_FLAGS"), this.getString("HINT_COMPILE_FLAGS")){

            public String getValue() {
                return CompileExecSupport.this.getCompileFlags();
            }

            public void setValue(String val) {
                CompileExecSupport.this.setCompileFlags(val);
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() {
                this.setValue(null);
            }

            public boolean canWrite() {
                return CompileExecSupport.this.getEntry().getFile().getParent().canWrite();
            }
        };
    }

    public String getCompileFlags() {
        String flags = (String)this.getEntry().getFile().getAttribute(PROP_COMPILE_FLAGS);
        if (flags == null) {
            flags = "-g";
            this.setCompileFlags(flags);
        }
        return flags;
    }

    public void setCompileFlags(String flags) {
        block2: {
            try {
                this.getEntry().getFile().setAttribute(PROP_COMPILE_FLAGS, (Object)flags);
            }
            catch (IOException ex) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block2;
                ex.printStackTrace(System.err);
            }
        }
    }

    private PropertySupport<String> createLinkFlagsProperty() {
        return new PropertySupport.ReadWrite<String>(PROP_LINK_FLAGS, String.class, this.getString("PROP_LINK_FLAGS"), this.getString("HINT_LINK_FLAGS")){

            public String getValue() {
                return CompileExecSupport.this.getLinkFlags();
            }

            public void setValue(String val) {
                CompileExecSupport.this.setLinkFlags(val);
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() {
                this.setValue(null);
            }

            public boolean canWrite() {
                return CompileExecSupport.this.getEntry().getFile().getParent().canWrite();
            }
        };
    }

    public String getLinkFlags() {
        String flags = (String)this.getEntry().getFile().getAttribute(PROP_LINK_FLAGS);
        if (flags == null) {
            flags = "";
            this.setLinkFlags(flags);
        }
        return flags;
    }

    public void setLinkFlags(String flags) {
        block2: {
            try {
                this.getEntry().getFile().setAttribute(PROP_LINK_FLAGS, (Object)flags);
            }
            catch (IOException ex) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block2;
                ex.printStackTrace(System.err);
            }
        }
    }

    private String getString(String s) {
        return NbBundle.getMessage(CompileExecSupport.class, (String)s);
    }
}

