/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.filecreation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.cnd.editor.filecreation.NewCndFileChooserPanel;
import org.netbeans.modules.cnd.editor.filecreation.SrcFileWizardListener;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;

public class CCFSrcFileIterator
implements WizardDescriptor.ProgressInstantiatingIterator<WizardDescriptor> {
    private static final List<SrcFileWizardListener> listenerList = new ArrayList<SrcFileWizardListener>(0);
    protected WizardDescriptor.Panel<WizardDescriptor> targetChooserDescriptorPanel;
    protected TemplateWizard templateWizard;
    private static final String C_HEADER_MIME_TYPE = "text/x-c/text/x-h";
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.targetChooserDescriptorPanel;
    }

    public boolean hasNext() {
        return false;
    }

    public boolean hasPrevious() {
        return false;
    }

    public synchronized void nextPanel() {
    }

    public synchronized void previousPanel() {
    }

    public void initialize(WizardDescriptor wiz) {
        this.templateWizard = (TemplateWizard)wiz;
        this.targetChooserDescriptorPanel = this.createPanel(this.templateWizard);
    }

    public void uninitialize(WizardDescriptor wiz) {
    }

    protected WizardDescriptor.Panel<WizardDescriptor> createPanel(TemplateWizard wiz) {
        DataObject dobj = wiz.getTemplate();
        FileObject fobj = dobj.getPrimaryFile();
        String mimeType = fobj.getMIMEType();
        MIMEExtensions extensions = MIMEExtensions.get((String)mimeType);
        if (extensions != null) {
            Project project = Templates.getProject((WizardDescriptor)wiz);
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] groups = sources.getSourceGroups("generic");
            if ("text/x-h".equals(extensions.getMIMEType()) && dobj.getPrimaryFile().getAttribute(C_HEADER_MIME_TYPE) != null) {
                MIMEExtensions cHeaderExtensions = MIMEExtensions.get((String)C_HEADER_MIME_TYPE);
                if (cHeaderExtensions == null || !C_HEADER_MIME_TYPE.equals(cHeaderExtensions.getMIMEType())) {
                    System.err.println("not found extensions for C Headers");
                } else {
                    extensions = cHeaderExtensions;
                }
            }
            String defaultExt = null;
            if (mimeType.equals("text/sh")) {
                defaultExt = fobj.getExt();
            } else if (mimeType.equals("text/x-h") && fobj.getExt().length() == 0) {
                defaultExt = fobj.getExt();
            }
            NewCndFileChooserPanel panel = new NewCndFileChooserPanel(project, groups, null, extensions, defaultExt);
            return panel;
        }
        return wiz.targetChooser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DataObject> instantiate(ProgressHandle handle) throws IOException {
        try {
            handle.start();
            Set<DataObject> set = this.instantiate();
            return set;
        }
        finally {
            handle.finish();
        }
    }

    public Set<DataObject> instantiate() throws IOException {
        String filename;
        TemplateWizard wiz = this.templateWizard;
        DataFolder targetFolder = wiz.getTargetFolder();
        DataObject template = wiz.getTemplate();
        DataObject result = template.createFromTemplate(targetFolder, filename = wiz.getTargetName());
        if (result != null) {
            CCFSrcFileIterator.fireWizardEvent(new EventObject(result));
            OpenCookie open = (OpenCookie)result.getLookup().lookup(OpenCookie.class);
            if (open != null) {
                open.open();
            }
        }
        return Collections.singleton(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    public String name() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void fireWizardEvent(EventObject e) {
        ArrayList<SrcFileWizardListener> listeners;
        List<SrcFileWizardListener> list = listenerList;
        synchronized (list) {
            listeners = new ArrayList<SrcFileWizardListener>(listenerList);
        }
        for (int i = listeners.size() - 1; i >= 0; --i) {
            ((SrcFileWizardListener)listeners.get(i)).srcFileCreated(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSrcFileWizardListener(SrcFileWizardListener l) {
        List<SrcFileWizardListener> list = listenerList;
        synchronized (list) {
            listenerList.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSrcFileWizardListener(SrcFileWizardListener l) {
        List<SrcFileWizardListener> list = listenerList;
        synchronized (list) {
            listenerList.remove(l);
        }
    }
}

