/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.cnd.api.xml.VersionException;
import org.netbeans.modules.cnd.api.xml.XMLDecoder;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public abstract class XMLDocReader
extends XMLDecoder {
    private static final boolean debug = false;
    private String sourceName;
    private String currentText = null;
    private String comment = null;

    protected String getMasterComment() {
        return this.comment;
    }

    public boolean read(InputStream inputStream, String sourceName) {
        XMLReader xmlReader;
        this.sourceName = sourceName;
        if (sourceName == null) {
            this.sourceName = XMLDocReader.getString("UNKNOWN_sourceName");
        }
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setValidating(false);
        try {
            SAXParser saxParser = spf.newSAXParser();
            xmlReader = saxParser.getXMLReader();
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return false;
        }
        Parser parser = new Parser();
        xmlReader.setContentHandler(parser);
        xmlReader.setEntityResolver(parser);
        xmlReader.setErrorHandler(new ErrHandler());
        try {
            xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", new CommentsParser());
        }
        catch (SAXNotRecognizedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SAXNotSupportedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        String fmt = XMLDocReader.getString("MSG_Whilereading");
        String whileMsg = MessageFormat.format(fmt, sourceName);
        try {
            InputSource inputSource = new InputSource(inputStream);
            xmlReader.parse(inputSource);
        }
        catch (SAXException ex) {
            VersionException versionException = null;
            if (ex.getException() instanceof VersionException) {
                versionException = (VersionException)ex.getException();
            }
            if (versionException != null) {
                if (versionException.showDetails()) {
                    String what = versionException.element();
                    int expectedVersion = versionException.expectedVersion();
                    int actualVersion = versionException.actualVersion();
                    fmt = XMLDocReader.getString("MSG_versionerror");
                    String errmsg = whileMsg + MessageFormat.format(fmt, what, "" + actualVersion, "" + expectedVersion);
                    if (CndUtils.isStandalone()) {
                        System.err.println(errmsg);
                    } else {
                        NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)errmsg, 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                    }
                }
            } else {
                ErrorManager.getDefault().annotate((Throwable)ex, whileMsg);
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            return false;
        }
        catch (IOException ex) {
            ErrorManager.getDefault().annotate((Throwable)ex, whileMsg);
            ErrorManager.getDefault().notify((Throwable)ex);
            return false;
        }
        catch (Exception ex) {
            ErrorManager.getDefault().annotate((Throwable)ex, whileMsg);
            ErrorManager.getDefault().notify(4096, (Throwable)ex);
            return false;
        }
        return true;
    }

    private static String getString(String key) {
        return NbBundle.getMessage(XMLDocReader.class, (String)key);
    }

    private static final class ErrHandler
    implements ErrorHandler {
        private void annotate(SAXParseException ex) {
            String fmt = XMLDocReader.getString("MSG_sax_error_location");
            String msg = MessageFormat.format(fmt, ex.getSystemId(), "" + ex.getLineNumber());
            ErrorManager.getDefault().annotate((Throwable)ex, 0, msg, null, null, null);
        }

        @Override
        public void fatalError(SAXParseException ex) throws SAXException {
            this.annotate(ex);
            throw ex;
        }

        @Override
        public void error(SAXParseException ex) throws SAXException {
            this.annotate(ex);
            throw ex;
        }

        @Override
        public void warning(SAXParseException ex) throws SAXException {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    private class Parser
    implements ContentHandler,
    EntityResolver {
        private Parser() {
        }

        @Override
        public InputSource resolveEntity(String pubid, String sysid) {
            byte[] empty = new byte[]{};
            return new InputSource(new ByteArrayInputStream(empty));
        }

        @Override
        public void startDocument() throws SAXException {
            try {
                XMLDocReader.this.start(null);
            }
            catch (VersionException x) {
                throw new SAXException(x);
            }
        }

        @Override
        public void endDocument() {
            XMLDocReader.this.end();
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            String s = new String(ch, start, length);
            XMLDocReader.this.currentText = XMLDocReader.this.currentText + s;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            XMLDocReader.this.currentText = "";
            try {
                XMLDocReader.this._startElement(qName, atts);
            }
            catch (VersionException x) {
                throw new SAXException(x);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            XMLDocReader.this._endElement(qName, XMLDocReader.this.currentText);
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) {
        }

        @Override
        public void endPrefixMapping(String prefix) {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) {
        }

        @Override
        public void processingInstruction(String target, String data) {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void skippedEntity(String name) {
        }
    }

    private class CommentsParser
    implements LexicalHandler {
        private CommentsParser() {
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }

        @Override
        public void startCDATA() throws SAXException {
        }

        @Override
        public void endCDATA() throws SAXException {
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            if (XMLDocReader.this.comment == null) {
                XMLDocReader.this.comment = new String(ch, start, length);
            }
        }
    }
}

