/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.netbeans.modules.cnd.actions.AbstractExecutorRunAction;
import org.netbeans.modules.cnd.actions.MakeBaseAction;
import org.netbeans.modules.cnd.builds.MakeExecSupport;
import org.netbeans.modules.cnd.builds.MakefileTargetProvider;
import org.netbeans.modules.cnd.builds.TargetEditor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.windows.WindowManager;

public class MakeTargetAction
extends MakeBaseAction
implements Presenter.Popup {
    private static String mnemonics = "1234567890";

    public String getName() {
        return MakeTargetAction.getString("BTN_Target");
    }

    @Override
    public HelpCtx getHelpCtx() {
        return new HelpCtx(MakeTargetAction.class);
    }

    public JMenuItem getPopupPresenter() {
        Node[] activeNodes = WindowManager.getDefault().getRegistry().getActivatedNodes();
        return new TargetPopupMenu((SystemAction)this, this.enable(activeNodes), activeNodes);
    }

    private String nameWithMnemonic(String name, int mne) {
        if (mne >= 0 && mne < mnemonics.length()) {
            return "" + mnemonics.charAt(mne) + "  " + name;
        }
        return name;
    }

    protected static class PopupItemAddTarget
    extends JMenuItem
    implements ActionListener {
        private Node node = null;

        public PopupItemAddTarget(Node activeNode) {
            super(AbstractExecutorRunAction.getString("ADD_NEW_TARGET"));
            this.node = activeNode;
            this.addActionListener(this);
            this.setMnemonic(AbstractExecutorRunAction.getString("ADD_NEW_TARGET_MNEMONIC").charAt(0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TargetEditor targetEditor;
            int ret;
            MakeExecSupport mes = (MakeExecSupport)this.node.getLookup().lookup(MakeExecSupport.class);
            if (mes != null && (ret = (targetEditor = new TargetEditor(mes.getMakeTargetsArray(), null, null)).showOpenDialog((JFrame)WindowManager.getDefault().getMainWindow())) == 0) {
                mes.setMakeTargets(targetEditor.getTargets());
            }
        }
    }

    protected class PopupItemTarget
    extends JMenuItem
    implements ActionListener {
        Node node;
        String target;

        public PopupItemTarget(Node activeNode, String name, int mne) {
            super(MakeTargetAction.this.nameWithMnemonic(name, mne));
            this.node = null;
            this.target = null;
            this.node = activeNode;
            this.target = name;
            this.addActionListener(this);
            if (mne >= 0 && mne < mnemonics.length()) {
                this.setMnemonic(mnemonics.charAt(mne));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MakeTargetAction.this.performAction(this.node, this.target);
        }
    }

    private class TargetPopupMenu
    extends JMenu {
        private boolean initialized = false;
        private SystemAction action = null;
        private Node[] activeNodes;

        public TargetPopupMenu(SystemAction action, boolean en, Node[] activeNodes) {
            this.action = action;
            this.activeNodes = activeNodes;
            this.setEnabled(en);
            this.setText(action.getName());
        }

        @Override
        public JPopupMenu getPopupMenu() {
            JPopupMenu popup = super.getPopupMenu();
            if (!this.initialized) {
                MakeExecSupport mes;
                if (this.activeNodes == null || this.activeNodes.length != 1) {
                    return null;
                }
                Node activeNode = this.activeNodes[0];
                MakefileTargetProvider targetProvider = (MakefileTargetProvider)activeNode.getLookup().lookup(MakefileTargetProvider.class);
                if (targetProvider != null) {
                    try {
                        FileObject fo;
                        DataObject dao = (DataObject)activeNode.getLookup().lookup(DataObject.class);
                        if (dao != null && (fo = dao.getPrimaryFile()) != null && fo.isValid()) {
                            ArrayList<String> targets = new ArrayList<String>(targetProvider.getPreferredTargets());
                            Collections.sort(targets);
                            for (String target : targets) {
                                popup.add(new PopupItemTarget(activeNode, target, -1));
                            }
                            if (!targets.isEmpty()) {
                                popup.add(new JSeparator());
                            }
                        }
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                if ((mes = (MakeExecSupport)activeNode.getLookup().lookup(MakeExecSupport.class)) != null) {
                    String[] targets = mes.getMakeTargetsArray();
                    for (int i = 0; i < targets.length; ++i) {
                        popup.add(new PopupItemTarget(activeNode, targets[i], -1));
                    }
                    if (targets.length > 0) {
                        popup.add(new JSeparator());
                    }
                    popup.add(new PopupItemAddTarget(activeNode));
                }
                this.initialized = true;
            }
            return popup;
        }
    }
}

