/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.text.html.HTML;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.DefaultHttpParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.httpclient.util.IdleConnectionTimeoutThread;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.mylyn.commons.core.CoreUtil;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.HtmlStreamTokenizer;
import org.eclipse.mylyn.commons.net.HtmlTag;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.commons.net.WebRequest;
import org.eclipse.mylyn.internal.commons.net.AuthenticatedProxy;
import org.eclipse.mylyn.internal.commons.net.CloneableHostConfiguration;
import org.eclipse.mylyn.internal.commons.net.CommonsNetPlugin;
import org.eclipse.mylyn.internal.commons.net.MonitoredRequest;
import org.eclipse.mylyn.internal.commons.net.PollingInputStream;
import org.eclipse.mylyn.internal.commons.net.PollingProtocolSocketFactory;
import org.eclipse.mylyn.internal.commons.net.PollingSslProtocolSocketFactory;
import org.eclipse.mylyn.internal.commons.net.TimeoutInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebUtil {
    private static final String USER_AGENT;
    private static final int CONNNECT_TIMEOUT = 60000;
    private static final int SOCKET_TIMEOUT = 180000;
    private static final int HTTP_PORT = 80;
    private static final int HTTPS_PORT = 443;
    private static final int POLL_INTERVAL = 500;
    private static final int POLL_ATTEMPTS = 360;
    private static final String USER_AGENT_PREFIX;
    private static final String USER_AGENT_POSTFIX;
    private static final int BUFFER_SIZE = 4096;
    private static final long CLOSE_TIMEOUT = -1L;
    private static final long CONNECTION_TIMEOUT_INTERVAL = 30000L;
    private static IdleConnectionTimeoutThread idleConnectionTimeoutThread;
    private static MultiThreadedHttpConnectionManager connectionManager;
    private static ProtocolSocketFactory sslSocketFactory;
    private static PollingProtocolSocketFactory socketFactory;

    static {
        String userAgent;
        Object parameter;
        CoreUtil.initializeLoggingSettings();
        StringBuilder sb = new StringBuilder();
        sb.append("Mylyn");
        sb.append(WebUtil.getBundleVersion(CommonsNetPlugin.getDefault()));
        USER_AGENT_PREFIX = sb.toString();
        sb.setLength(0);
        if (System.getProperty("org.osgi.framework.vendor") != null) {
            sb.append(" ");
            sb.append(System.getProperty("org.osgi.framework.vendor"));
            sb.append(WebUtil.stripQualifier(System.getProperty("osgi.framework.version")));
            if (System.getProperty("eclipse.product") != null) {
                sb.append(" (");
                sb.append(System.getProperty("eclipse.product"));
                sb.append(")");
            }
        }
        if ((parameter = DefaultHttpParams.getDefaultParams().getParameter("http.useragent")) != null && (userAgent = parameter.toString()) != null) {
            if (userAgent.startsWith("Jakarta Commons-")) {
                sb.append(" ");
                sb.append(userAgent.substring(16));
            } else {
                sb.append(" ");
                sb.append(parameter.toString());
            }
        }
        sb.append(" Java/");
        sb.append(System.getProperty("java.version"));
        sb.append(" (");
        sb.append(System.getProperty("java.vendor").split(" ")[0]);
        sb.append(") ");
        sb.append(System.getProperty("os.name"));
        sb.append("/");
        sb.append(System.getProperty("os.version"));
        sb.append(" (");
        sb.append(System.getProperty("os.arch"));
        if (System.getProperty("osgi.nl") != null) {
            sb.append("; ");
            sb.append(System.getProperty("osgi.nl"));
        }
        sb.append(")");
        USER_AGENT_POSTFIX = sb.toString();
        USER_AGENT = String.valueOf(USER_AGENT_PREFIX) + USER_AGENT_POSTFIX;
        sslSocketFactory = new PollingSslProtocolSocketFactory();
        socketFactory = new PollingProtocolSocketFactory();
    }

    public static void configureHttpClient(HttpClient client, String userAgent) {
        client.getParams().setBooleanParameter("http.protocol.allow-circular-redirects", true);
        client.getParams().setParameter("http.useragent", (Object)WebUtil.getUserAgent(userAgent));
        client.getParams().setConnectionManagerTimeout(30000L);
        WebUtil.configureHttpClientConnectionManager(client);
    }

    private static void configureHttpClientConnectionManager(HttpClient client) {
        client.getHttpConnectionManager().getParams().setSoTimeout(180000);
        client.getHttpConnectionManager().getParams().setConnectionTimeout(60000);
        if (CoreUtil.TEST_MODE) {
            client.getHttpConnectionManager().getParams().setMaxConnectionsPerHost(HostConfiguration.ANY_HOST_CONFIGURATION, 2);
        } else {
            client.getHttpConnectionManager().getParams().setMaxConnectionsPerHost(HostConfiguration.ANY_HOST_CONFIGURATION, 100);
            client.getHttpConnectionManager().getParams().setMaxTotalConnections(1000);
        }
    }

    private static void configureHttpClientProxy(HttpClient client, HostConfiguration hostConfiguration, AbstractWebLocation location) {
        String host = WebUtil.getHost(location.getUrl());
        Proxy proxy = WebUtil.isRepositoryHttps(location.getUrl()) ? location.getProxyForHost(host, "HTTPS") : location.getProxyForHost(host, "HTTP");
        if (proxy != null && !Proxy.NO_PROXY.equals(proxy)) {
            InetSocketAddress address = (InetSocketAddress)proxy.address();
            hostConfiguration.setProxy(address.getHostName(), address.getPort());
            if (proxy instanceof AuthenticatedProxy) {
                AuthenticatedProxy authProxy = (AuthenticatedProxy)proxy;
                Credentials credentials = WebUtil.getCredentials(authProxy.getUserName(), authProxy.getPassword(), address.getAddress());
                AuthScope proxyAuthScope = new AuthScope(address.getHostName(), address.getPort(), AuthScope.ANY_REALM);
                client.getState().setProxyCredentials(proxyAuthScope, credentials);
            }
        } else {
            hostConfiguration.setProxyHost(null);
        }
    }

    public static void connect(final Socket socket, final InetSocketAddress address, final int timeout, IProgressMonitor monitor) throws IOException {
        Assert.isNotNull((Object)socket);
        WebRequest<Object> executor = new WebRequest<Object>(){

            @Override
            public void abort() {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }

            @Override
            public Object call() throws Exception {
                socket.connect(address, timeout);
                return null;
            }
        };
        WebUtil.executeInternal(monitor, executor);
    }

    public static HostConfiguration createHostConfiguration(HttpClient client, AbstractWebLocation location, IProgressMonitor monitor) {
        Assert.isNotNull((Object)client);
        Assert.isNotNull((Object)location);
        String url = location.getUrl();
        String host = WebUtil.getHost(url);
        int port = WebUtil.getPort(url);
        WebUtil.configureHttpClientConnectionManager(client);
        CloneableHostConfiguration hostConfiguration = new CloneableHostConfiguration();
        WebUtil.configureHttpClientProxy(client, hostConfiguration, location);
        AuthenticationCredentials credentials = location.getCredentials(AuthenticationType.HTTP);
        if (credentials != null) {
            AuthScope authScope = new AuthScope(host, port, AuthScope.ANY_REALM);
            client.getState().setCredentials(authScope, WebUtil.getHttpClientCredentials(credentials, host));
        }
        if (WebUtil.isRepositoryHttps(url)) {
            AuthenticationCredentials certCredentials = location.getCredentials(AuthenticationType.CERTIFICATE);
            if (certCredentials == null) {
                Protocol protocol = new Protocol("https", sslSocketFactory, 443);
                hostConfiguration.setHost(host, port, protocol);
            } else {
                Protocol protocol = new Protocol("https", (ProtocolSocketFactory)new PollingSslProtocolSocketFactory(certCredentials.getUserName(), certCredentials.getPassword(), null), 443);
                hostConfiguration.setHost(host, port, protocol);
            }
        } else {
            Protocol protocol = new Protocol("http", (ProtocolSocketFactory)socketFactory, 80);
            hostConfiguration.setHost(host, port, protocol);
        }
        return hostConfiguration;
    }

    public static int execute(HttpClient client, HostConfiguration hostConfiguration, HttpMethod method, IProgressMonitor monitor) throws IOException {
        return WebUtil.execute(client, hostConfiguration, method, null, monitor);
    }

    public static int execute(final HttpClient client, final HostConfiguration hostConfiguration, final HttpMethod method, final HttpState state, IProgressMonitor monitor) throws IOException {
        Assert.isNotNull((Object)client);
        Assert.isNotNull((Object)method);
        monitor = Policy.monitorFor(monitor);
        MonitoredRequest<Integer> executor = new MonitoredRequest<Integer>(monitor){

            @Override
            public void abort() {
                super.abort();
                method.abort();
            }

            @Override
            public Integer execute() throws Exception {
                return client.executeMethod(hostConfiguration, method, state);
            }
        };
        return (Integer)WebUtil.executeInternal(monitor, executor);
    }

    public static <T> T execute(IProgressMonitor monitor, WebRequest<T> request) throws Throwable {
        SubMonitor subMonitor = monitor instanceof SubMonitor ? (SubMonitor)monitor : SubMonitor.convert(null);
        Future<T> future = CommonsNetPlugin.getExecutorService().submit(request);
        while (true) {
            if (monitor.isCanceled()) {
                request.abort();
                future.cancel(false);
                try {
                    if (!future.isCancelled()) {
                        future.get();
                    }
                }
                catch (CancellationException cancellationException) {
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ExecutionException executionException) {}
                throw new OperationCanceledException();
            }
            try {
                return future.get(500L, TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
            catch (TimeoutException timeoutException) {
                subMonitor.setWorkRemaining(20);
                subMonitor.worked(1);
                continue;
            }
            break;
        }
    }

    private static <T> T executeInternal(IProgressMonitor monitor, WebRequest<?> request) throws IOException {
        try {
            return (T)WebUtil.execute(monitor, request);
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static String getBundleVersion(Plugin plugin) {
        if (plugin == null) {
            return "";
        }
        Object bundleVersion = plugin.getBundle().getHeaders().get("Bundle-Version");
        if (bundleVersion == null) {
            return "";
        }
        return WebUtil.stripQualifier((String)bundleVersion);
    }

    public static int getConnectionTimeout() {
        return 60000;
    }

    static Credentials getCredentials(String username, String password, InetAddress address) {
        int i = username.indexOf("\\");
        if (i > 0 && i < username.length() - 1 && address != null) {
            return new NTCredentials(username.substring(i + 1), password, address.getHostName(), username.substring(0, i));
        }
        return new UsernamePasswordCredentials(username, password);
    }

    public static String getHost(String repositoryUrl) {
        String result = repositoryUrl;
        int colonSlashSlash = repositoryUrl.indexOf("://");
        if (colonSlashSlash >= 0) {
            result = repositoryUrl.substring(colonSlashSlash + 3);
        }
        int colonPort = result.indexOf(58);
        int requestPath = result.indexOf(47);
        int substringEnd = colonPort > 0 && requestPath > 0 ? Math.min(colonPort, requestPath) : (colonPort > 0 ? colonPort : (requestPath > 0 ? requestPath : result.length()));
        return result.substring(0, substringEnd);
    }

    public static Credentials getHttpClientCredentials(AuthenticationCredentials credentials, String host) {
        String username = credentials.getUserName();
        String password = credentials.getPassword();
        int i = username.indexOf("\\");
        if (i > 0 && i < username.length() - 1 && host != null) {
            return new NTCredentials(username.substring(i + 1), password, host, username.substring(0, i));
        }
        return new UsernamePasswordCredentials(username, password);
    }

    public static int getPort(String repositoryUrl) {
        int colonSlashSlash = repositoryUrl.indexOf("://");
        int firstSlash = repositoryUrl.indexOf("/", colonSlashSlash + 3);
        int colonPort = repositoryUrl.indexOf(58, colonSlashSlash + 1);
        if (firstSlash == -1) {
            firstSlash = repositoryUrl.length();
        }
        if (colonPort < 0 || colonPort > firstSlash) {
            return WebUtil.isRepositoryHttps(repositoryUrl) ? 443 : 80;
        }
        int requestPath = repositoryUrl.indexOf(47, colonPort + 1);
        int end = requestPath < 0 ? repositoryUrl.length() : requestPath;
        String port = repositoryUrl.substring(colonPort + 1, end);
        if (port.length() == 0) {
            return WebUtil.isRepositoryHttps(repositoryUrl) ? 443 : 80;
        }
        return Integer.parseInt(port);
    }

    public static String getRequestPath(String repositoryUrl) {
        int colonSlashSlash = repositoryUrl.indexOf("://");
        int requestPath = repositoryUrl.indexOf(47, colonSlashSlash + 3);
        if (requestPath < 0) {
            return "";
        }
        return repositoryUrl.substring(requestPath);
    }

    public static InputStream getResponseBodyAsStream(HttpMethodBase method, IProgressMonitor monitor) throws IOException {
        monitor = Policy.monitorFor(monitor);
        return new PollingInputStream(new TimeoutInputStream(method.getResponseBodyAsStream(), 4096, 500L, -1L), 360, monitor);
    }

    public static int getSocketTimeout() {
        return 180000;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getTitleFromUrl(AbstractWebLocation location, IProgressMonitor monitor) throws IOException {
        monitor = Policy.monitorFor(monitor);
        try {
            monitor.beginTask("Retrieving " + location.getUrl(), -1);
            HttpClient client = new HttpClient();
            WebUtil.configureHttpClient(client, "");
            GetMethod method = new GetMethod(location.getUrl());
            try {
                HostConfiguration hostConfiguration = WebUtil.createHostConfiguration(client, location, monitor);
                int result = WebUtil.execute(client, hostConfiguration, (HttpMethod)method, monitor);
                if (result != 200) return null;
                InputStream in = WebUtil.getResponseBodyAsStream((HttpMethodBase)method, monitor);
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in, method.getResponseCharSet()));
                    HtmlStreamTokenizer tokenizer = new HtmlStreamTokenizer(reader, null);
                    try {
                        HtmlStreamTokenizer.Token token = tokenizer.nextToken();
                        while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
                            HtmlTag tag;
                            if (token.getType() == HtmlStreamTokenizer.Token.TAG && (tag = (HtmlTag)token.getValue()).getTagType() == HTML.Tag.TITLE) {
                                String text = WebUtil.getText(tokenizer);
                                text = text.replaceAll("\n", "");
                                text = text.replaceAll("\\s+", " ");
                                String string = text.trim();
                                return string;
                            }
                            token = tokenizer.nextToken();
                        }
                        return null;
                    }
                    catch (ParseException parseException) {
                        throw new IOException("Error reading url");
                    }
                }
                finally {
                    in.close();
                }
            }
            finally {
                WebUtil.releaseConnection((HttpMethodBase)method, monitor);
            }
        }
        finally {
            monitor.done();
        }
    }

    private static String getText(HtmlStreamTokenizer tokenizer) throws IOException, ParseException {
        StringBuilder sb = new StringBuilder();
        HtmlStreamTokenizer.Token token = tokenizer.nextToken();
        while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
            if (token.getType() == HtmlStreamTokenizer.Token.TEXT) {
                sb.append(token.toString());
            } else if (token.getType() != HtmlStreamTokenizer.Token.COMMENT) break;
            token = tokenizer.nextToken();
        }
        return StringEscapeUtils.unescapeHtml((String)sb.toString());
    }

    public static String getUserAgent(String product) {
        if (product != null && product.length() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(USER_AGENT_PREFIX);
            sb.append(" ");
            sb.append(product);
            sb.append(USER_AGENT_POSTFIX);
            return sb.toString();
        }
        return USER_AGENT;
    }

    public static void init() {
    }

    private static boolean isRepositoryHttps(String repositoryUrl) {
        return repositoryUrl.matches("https.*");
    }

    private static String stripQualifier(String longVersion) {
        if (longVersion == null) {
            return "";
        }
        String[] parts = longVersion.split("\\.");
        StringBuilder version = new StringBuilder();
        if (parts.length > 0) {
            version.append("/");
            version.append(parts[0]);
            if (parts.length > 1) {
                version.append(".");
                version.append(parts[1]);
                if (parts.length > 2) {
                    version.append(".");
                    version.append(parts[2]);
                }
            }
        }
        return version.toString();
    }

    public static void setProxyService(IProxyService proxyService) {
        CommonsNetPlugin.setProxyService(proxyService);
    }

    public static IProxyService getProxyService() {
        return CommonsNetPlugin.getProxyService();
    }

    public static synchronized void addConnectionManager(HttpConnectionManager connectionManager) {
        if (idleConnectionTimeoutThread == null) {
            idleConnectionTimeoutThread = new IdleConnectionTimeoutThread();
            idleConnectionTimeoutThread.setTimeoutInterval(30000L);
            idleConnectionTimeoutThread.setConnectionTimeout(60000L);
            idleConnectionTimeoutThread.start();
        }
        idleConnectionTimeoutThread.addConnectionManager(connectionManager);
    }

    public static synchronized HttpConnectionManager getConnectionManager() {
        if (connectionManager == null) {
            connectionManager = new MultiThreadedHttpConnectionManager();
            WebUtil.addConnectionManager((HttpConnectionManager)connectionManager);
        }
        return connectionManager;
    }

    public static synchronized void removeConnectionManager(HttpConnectionManager connectionManager) {
        if (idleConnectionTimeoutThread == null) {
            return;
        }
        idleConnectionTimeoutThread.removeConnectionManager(connectionManager);
    }

    public static Proxy getProxy(String host, String proxyType) {
        Assert.isNotNull((Object)host);
        Assert.isNotNull((Object)proxyType);
        IProxyService service = CommonsNetPlugin.getProxyService();
        if (service != null && service.isProxiesEnabled()) {
            IProxyData data = service.getProxyDataForHost(host, proxyType);
            if (data != null && data.getHost() != null) {
                String proxyHost = data.getHost();
                int proxyPort = data.getPort();
                if (proxyPort == -1) {
                    proxyPort = 0;
                }
                AuthenticationCredentials credentials = null;
                if (data.isRequiresAuthentication()) {
                    credentials = new AuthenticationCredentials(data.getUserId(), data.getPassword());
                }
                return WebUtil.createProxy(proxyHost, proxyPort, credentials);
            }
        } else {
            try {
                Proxy proxy;
                URI uri = new URI(proxyType, "//" + host, null);
                List<Proxy> proxies = ProxySelector.getDefault().select(uri);
                if (proxies != null && proxies.size() > 0 && (proxy = proxies.iterator().next()) != Proxy.NO_PROXY) {
                    return proxy;
                }
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return null;
    }

    public static Proxy getProxyForUrl(String url) {
        String host = WebUtil.getHost(url);
        Proxy proxy = WebUtil.isRepositoryHttps(url) ? WebUtil.getProxy(host, "HTTPS") : WebUtil.getProxy(host, "HTTP");
        return proxy;
    }

    public static Proxy getProxy(String host, Proxy.Type proxyType) {
        Assert.isNotNull((Object)host);
        Assert.isNotNull((Object)((Object)proxyType));
        return WebUtil.getProxy(host, WebUtil.getPlatformProxyType(proxyType));
    }

    private static String getPlatformProxyType(Proxy.Type type) {
        return type == Proxy.Type.SOCKS ? "SOCKS" : "HTTP";
    }

    public static Proxy createProxy(String proxyHost, int proxyPort, AuthenticationCredentials credentials) {
        String proxyUsername = "";
        String proxyPassword = "";
        if (credentials != null) {
            proxyUsername = credentials.getUserName();
            proxyPassword = credentials.getPassword();
        }
        if (proxyHost != null && proxyHost.length() > 0) {
            boolean authenticated;
            InetSocketAddress sockAddr = new InetSocketAddress(proxyHost, proxyPort);
            boolean bl = authenticated = proxyUsername != null && proxyPassword != null && proxyUsername.length() > 0 && proxyPassword.length() > 0;
            if (authenticated) {
                return new AuthenticatedProxy(Proxy.Type.HTTP, sockAddr, proxyUsername, proxyPassword);
            }
            return new Proxy(Proxy.Type.HTTP, sockAddr);
        }
        return Proxy.NO_PROXY;
    }

    public static void releaseConnection(HttpMethodBase method, IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            method.abort();
        } else {
            try {
                method.releaseConnection();
            }
            catch (NullPointerException nullPointerException) {}
        }
    }
}

