/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.dialog;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.net.URL;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.integration.IntegrationUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.attach.AttachWizard;
import org.netbeans.modules.profiler.attach.dialog.Bundle;
import org.netbeans.modules.profiler.attach.spi.AttachStepsProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class AttachDialog
extends AttachWizard {
    private AttachStepsProvider currentProvider;
    private Panel panel;
    private static final String ATTACH_WIZARD_HELPCTX = "AttachDialog.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("AttachDialog.HelpCtx");

    @Override
    public AttachSettings configure(AttachSettings settings) {
        AttachSettings result;
        if (settings == null) {
            settings = new AttachSettings();
        }
        if (settings.getTargetType().isEmpty()) {
            settings.setDirect(false);
            settings.setDynamic16(true);
            settings.setRemote(false);
        }
        settings.setTargetType(Bundle.AttachDialog_JavaApplication());
        settings.setServerType(Bundle.AttachDialog_JavaApplication());
        if (settings.isRemote()) {
            settings.setHostOS(null);
        }
        this.panel = new Panel();
        this.panel.setup(settings);
        DialogDescriptor dd = new DialogDescriptor((Object)this.panel, Bundle.AttachDialog_Caption());
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        d.setVisible(true);
        AttachSettings attachSettings = result = dd.getValue() == DialogDescriptor.OK_OPTION ? this.panel.getSettings() : null;
        if (this.currentProvider != null) {
            this.currentProvider.removeChangeListener(this.panel);
        }
        this.currentProvider = null;
        this.panel = null;
        return result;
    }

    private String steps(AttachSettings settings) {
        Collection providers = Lookup.getDefault().lookupAll(AttachStepsProvider.class);
        if (this.currentProvider != null) {
            this.currentProvider.removeChangeListener(this.panel);
        }
        for (AttachStepsProvider provider : providers) {
            String steps = provider.getSteps(settings);
            if (steps == null) continue;
            this.currentProvider = provider;
            this.currentProvider.addChangeListener(this.panel);
            return steps;
        }
        this.currentProvider = null;
        return Bundle.AttachDialog_NoSteps();
    }

    private class Panel
    extends JPanel
    implements HelpCtx.Provider,
    ChangeListener {
        private JRadioButton local;
        private JRadioButton remote;
        private JRadioButton dynamic;
        private JRadioButton direct;
        private JTextField hostname;
        private JComboBox os;
        private HTMLTextArea steps;
        private AttachSettings as;
        private boolean updatingUI = false;

        Panel() {
            this.initComponents();
        }

        void setup(AttachSettings as) {
            this.as = as;
            this.updatingUI = true;
            this.local.setSelected(!as.isRemote());
            this.remote.setSelected(as.isRemote());
            this.dynamic.setSelected(!as.isDirect());
            this.direct.setSelected(as.isDirect());
            if (as.isRemote()) {
                this.hostname.setText(as.getHost());
                this.os.setSelectedItem(as.getHostOS());
            } else {
                this.hostname.setText("");
                this.os.setSelectedIndex(0);
            }
            this.updatingUI = false;
            this.updateSteps();
        }

        AttachSettings getSettings() {
            this.as.setRemote(this.remote.isSelected());
            if (this.as.isRemote()) {
                this.as.setDirect(true);
                this.as.setDynamic16(false);
                this.as.setHost(this.hostname.getText().trim());
                this.as.setHostOS(this.os.getSelectedItem().toString());
            } else {
                this.as.setDirect(this.direct.isSelected());
                this.as.setDynamic16(this.dynamic.isSelected());
                this.as.setHostOS(IntegrationUtils.getLocalPlatform((int)-1));
            }
            return this.as;
        }

        private void initComponents() {
            this.setLayout(new GridBagLayout());
            final JPanel connection = new JPanel(new CardLayout());
            JPanel localConn = new JPanel(new GridBagLayout());
            JPanel remoteConn = new JPanel(new GridBagLayout());
            ButtonGroup bg1 = new ButtonGroup();
            ButtonGroup bg2 = new ButtonGroup();
            JPanel target = new JPanel(new GridBagLayout());
            target.setBorder(new TitledBorder(Bundle.AttachDialog_Target()));
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 17;
            c.insets = new Insets(6, 10, 0, 0);
            this.local = new JRadioButton(){

                @Override
                protected void fireItemStateChanged(ItemEvent event) {
                    super.fireItemStateChanged(event);
                    if (event.getStateChange() != 1) {
                        return;
                    }
                    CardLayout layout = (CardLayout)connection.getLayout();
                    layout.show(connection, "LOCAL");
                    Panel.this.updateSteps();
                }
            };
            Mnemonics.setLocalizedText((AbstractButton)this.local, (String)Bundle.AttachDialog_Local());
            bg1.add(this.local);
            target.add((Component)this.local, c);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 0;
            c.weightx = 1.0;
            c.fill = 2;
            c.anchor = 17;
            c.insets = new Insets(6, 30, 0, 10);
            JLabel localHint = new JLabel(Bundle.AttachDialog_LocalHint());
            localHint.setEnabled(false);
            target.add((Component)localHint, c);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 1;
            c.anchor = 17;
            c.insets = new Insets(6, 10, 10, 0);
            this.remote = new JRadioButton(){

                @Override
                protected void fireItemStateChanged(ItemEvent event) {
                    super.fireItemStateChanged(event);
                    if (event.getStateChange() != 1) {
                        return;
                    }
                    CardLayout layout = (CardLayout)connection.getLayout();
                    layout.show(connection, "REMOTE");
                    Panel.this.updateSteps();
                }
            };
            Mnemonics.setLocalizedText((AbstractButton)this.remote, (String)Bundle.AttachDialog_Remote());
            bg1.add(this.remote);
            target.add((Component)this.remote, c);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 1;
            c.weightx = 1.0;
            c.fill = 2;
            c.anchor = 17;
            c.insets = new Insets(6, 30, 10, 10);
            JLabel remoteHint = new JLabel(Bundle.AttachDialog_RemoteHint());
            remoteHint.setEnabled(false);
            target.add((Component)remoteHint, c);
            c = new GridBagConstraints();
            c.gridy = 0;
            c.weightx = 1.0;
            c.fill = 2;
            c.insets = new Insets(10, 10, 0, 10);
            this.add((Component)target, c);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 17;
            c.insets = new Insets(6, 10, 0, 0);
            this.dynamic = new JRadioButton(){

                @Override
                protected void fireItemStateChanged(ItemEvent event) {
                    super.fireItemStateChanged(event);
                    if (event.getStateChange() != 1) {
                        return;
                    }
                    Panel.this.updateSteps();
                }
            };
            Mnemonics.setLocalizedText((AbstractButton)this.dynamic, (String)Bundle.AttachDialog_Dynamic());
            bg2.add(this.dynamic);
            localConn.add((Component)this.dynamic, c);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 0;
            c.weightx = 1.0;
            c.fill = 2;
            c.anchor = 17;
            c.insets = new Insets(6, 30, 0, 10);
            JLabel dynamicHint = new JLabel(Bundle.AttachDialog_DynamicHint());
            dynamicHint.setEnabled(false);
            localConn.add((Component)dynamicHint, c);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 1;
            c.anchor = 17;
            c.insets = new Insets(6, 10, 10, 0);
            this.direct = new JRadioButton(){

                @Override
                protected void fireItemStateChanged(ItemEvent event) {
                    super.fireItemStateChanged(event);
                    if (event.getStateChange() != 1) {
                        return;
                    }
                    Panel.this.updateSteps();
                }
            };
            Mnemonics.setLocalizedText((AbstractButton)this.direct, (String)Bundle.AttachDialog_Direct());
            bg2.add(this.direct);
            localConn.add((Component)this.direct, c);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 1;
            c.weightx = 1.0;
            c.fill = 2;
            c.anchor = 17;
            c.insets = new Insets(6, 30, 10, 10);
            JLabel directHint = new JLabel(Bundle.AttachDialog_DirectHint());
            directHint.setEnabled(false);
            localConn.add((Component)directHint, c);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 17;
            c.insets = new Insets(6, 10, 0, 0);
            JLabel hostnameLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)hostnameLabel, (String)Bundle.AttachDialog_Hostname());
            remoteConn.add((Component)hostnameLabel, c);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 0;
            c.weightx = 1.0;
            c.fill = 2;
            c.anchor = 17;
            c.insets = new Insets(6, 10, 0, 10);
            this.hostname = new JTextField();
            hostnameLabel.setLabelFor(this.hostname);
            remoteConn.add((Component)this.hostname, c);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 1;
            c.anchor = 17;
            c.insets = new Insets(6, 10, 10, 0);
            JLabel osLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)osLabel, (String)Bundle.AttachDialog_OsJvm());
            remoteConn.add((Component)osLabel, c);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 1;
            c.weightx = 1.0;
            c.fill = 2;
            c.anchor = 17;
            c.insets = new Insets(6, 10, 10, 10);
            this.os = new JComboBox(new Object[]{IntegrationUtils.PLATFORM_WINDOWS_OS, IntegrationUtils.PLATFORM_WINDOWS_AMD64_OS, IntegrationUtils.PLATFORM_WINDOWS_CVM, IntegrationUtils.PLATFORM_LINUX_OS, IntegrationUtils.PLATFORM_LINUX_AMD64_OS, IntegrationUtils.PLATFORM_LINUX_ARM_OS, IntegrationUtils.PLATFORM_LINUX_CVM, IntegrationUtils.PLATFORM_SOLARIS_SPARC_OS, IntegrationUtils.PLATFORM_SOLARIS_SPARC64_OS, IntegrationUtils.PLATFORM_SOLARIS_INTEL_OS, IntegrationUtils.PLATFORM_SOLARIS_AMD64_OS, IntegrationUtils.PLATFORM_MAC_OS}){

                @Override
                protected void fireItemStateChanged(ItemEvent event) {
                    super.fireItemStateChanged(event);
                    if (event.getStateChange() != 1) {
                        return;
                    }
                    Panel.this.updateSteps();
                }
            };
            osLabel.setLabelFor(this.os);
            remoteConn.add((Component)this.os, c);
            connection.setBorder(new TitledBorder(Bundle.AttachDialog_Connection()));
            connection.add((Component)localConn, "LOCAL");
            connection.add((Component)remoteConn, "REMOTE");
            c = new GridBagConstraints();
            c.gridy = 1;
            c.weightx = 1.0;
            c.fill = 2;
            c.insets = new Insets(10, 10, 0, 10);
            this.add((Component)connection, c);
            c = new GridBagConstraints();
            c.gridy = 2;
            c.weightx = 1.0;
            c.fill = 2;
            c.insets = new Insets(10, 12, 0, 12);
            JLabel hint = new JLabel();
            Mnemonics.setLocalizedText((JLabel)hint, (String)Bundle.AttachDialog_Steps());
            hint.setIcon(Icons.getIcon((String)"GeneralIcons.Info"));
            this.add((Component)hint, c);
            c = new GridBagConstraints();
            c.gridy = 3;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.fill = 1;
            c.insets = new Insets(2, 12, 0, 12);
            this.steps = new HTMLTextArea(){

                protected void showURL(URL url) {
                    if (AttachDialog.this.currentProvider != null) {
                        final String action = url.toString();
                        final AttachSettings settings = new AttachSettings();
                        Panel.this.getSettings().copyInto(settings);
                        RequestProcessor.getDefault().post(new Runnable(){

                            @Override
                            public void run() {
                                AttachDialog.this.currentProvider.handleAction(action, settings);
                            }
                        });
                    }
                }
            };
            hint.setLabelFor((Component)this.steps);
            this.steps.setEditable(false);
            this.steps.setPreferredSize(new Dimension(505, 130));
            JScrollPane stepsScroll = new JScrollPane((Component)this.steps);
            this.add((Component)stepsScroll, c);
        }

        private void updateSteps() {
            if (this.updatingUI) {
                return;
            }
            this.steps.setText(AttachDialog.this.steps(this.getSettings()));
            this.steps.setCaretPosition(0);
        }

        public HelpCtx getHelpCtx() {
            return HELP_CTX;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Panel.this.updateSteps();
                }
            });
        }
    }
}

