/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.net.URL;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class Util {
    public static String getString(String key) {
        return NbBundle.getMessage(Util.class, (String)key);
    }

    public static char getChar(String key) {
        return Util.getString(key).charAt(0);
    }

    public static void debug(Throwable t) {
        ErrorManager err = ErrorManager.getDefault();
        err.notify(1, t);
    }

    public static void debug(String annotation, Throwable t) {
        ErrorManager err = ErrorManager.getDefault();
        err.annotate(t, 1, annotation, null, null, null);
        err.notify(1, t);
    }

    public static Project getProjectFor(DataObject dobj) {
        Object prj = null;
        FileObject fo = dobj.getPrimaryFile();
        return FileOwnerQuery.getOwner((FileObject)fo);
    }

    public static Project getProjectFor(Node[] activatedNodes) {
        DataObject dataObject;
        Project project = null;
        if (activatedNodes.length > 0 && (dataObject = (DataObject)activatedNodes[0].getCookie(DataObject.class)) != null && dataObject.getPrimaryFile() != null) {
            project = FileOwnerQuery.getOwner((FileObject)dataObject.getPrimaryFile());
        }
        return project;
    }

    public static ClassPath getExecClassPath(FileObject srcFile, FileObject resFile) {
        ClassPath ecp = ClassPath.getClassPath((FileObject)srcFile, (String)"classpath/execute");
        if (ecp != null && ecp.getResourceName(resFile, '.', false) != null) {
            return ecp;
        }
        ClassPath scp = ClassPath.getClassPath((FileObject)srcFile, (String)"classpath/source");
        if (scp != null && scp.getResourceName(resFile, '.', false) != null) {
            return scp;
        }
        ClassPath rcp = ClassPath.getClassPath((FileObject)resFile, (String)"classpath/source");
        if (rcp != null && rcp.getResourceName(resFile, '.', false) != null) {
            return rcp;
        }
        return null;
    }

    public static FileObject getResource(FileObject srcFile, String bundleName) {
        FileObject ret;
        ClassPath scp = ClassPath.getClassPath((FileObject)srcFile, (String)"classpath/source");
        if (scp != null && (ret = scp.findResource(bundleName)) != null) {
            return ret;
        }
        ClassPath ecp = ClassPath.getClassPath((FileObject)srcFile, (String)"classpath/execute");
        if (ecp != null) {
            for (ClassPath.Entry e : ecp.entries()) {
                SourceForBinaryQuery.Result r = SourceForBinaryQuery.findSourceRoots((URL)e.getURL());
                for (FileObject srcRoot : r.getRoots()) {
                    FileObject ret2;
                    ClassPath cp = ClassPath.getClassPath((FileObject)srcRoot, (String)"classpath/source");
                    if (cp == null || (ret2 = cp.findResource(bundleName)) == null) continue;
                    return ret2;
                }
            }
        }
        return null;
    }

    public static String getResourceName(FileObject srcFile, FileObject resFile, char separator, boolean bpar) {
        String ret;
        String ret2;
        String ret3;
        ClassPath ecp = ClassPath.getClassPath((FileObject)srcFile, (String)"classpath/execute");
        if (ecp != null && (ret3 = ecp.getResourceName(resFile, separator, bpar)) != null) {
            return ret3;
        }
        ClassPath scp = ClassPath.getClassPath((FileObject)srcFile, (String)"classpath/source");
        if (scp != null && (ret2 = scp.getResourceName(resFile, separator, bpar)) != null) {
            return ret2;
        }
        ClassPath rcp = ClassPath.getClassPath((FileObject)resFile, (String)"classpath/source");
        if (rcp != null && (ret = rcp.getResourceName(resFile, separator, bpar)) != null) {
            return ret;
        }
        return null;
    }
}

