/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.browser.webview;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.browser.api.WebBrowser;
import org.netbeans.core.browser.webview.NoWebBrowserImpl;
import org.netbeans.core.browser.webview.RuntimePathPanel;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Lookup;

public class WebBrowserImplProvider {
    private static URLClassLoader browserCL;
    private static final Logger log;

    static WebBrowser createBrowser() {
        return WebBrowserImplProvider.createBrowser(null);
    }

    static WebBrowser createBrowser(File runtimePath) {
        ClassLoader cl = WebBrowserImplProvider.getBrowserClassLoader(runtimePath);
        try {
            if (cl != null) {
                cl.loadClass("com.sun.javafx.scene.web.Debugger");
                Class<?> platform = cl.loadClass("javafx.application.Platform");
                Method m = platform.getMethod("setImplicitExit", Boolean.TYPE);
            }
        }
        catch (Throwable ex) {
            log.log(Level.INFO, "JavaFX runtime is too old - minimum version required is 2.2.0b20", ex);
            return new NoWebBrowserImpl("JavaFX runtime is too old - minimum version required is 2.2.0b20");
        }
        try {
            if (cl != null) {
                Class<?> impl = cl.loadClass("org.netbeans.core.browser.webview.ext.WebBrowserImpl");
                Constructor<?> c = impl.getConstructor(new Class[0]);
                return (WebBrowser)c.newInstance(new Object[0]);
            }
        }
        catch (Throwable ex) {
            log.log(Level.INFO, ex.getMessage(), ex);
            return new NoWebBrowserImpl(ex.getMessage());
        }
        return new NoWebBrowserImpl(new RuntimePathPanel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reset() {
        Class<WebBrowserImplProvider> clazz = WebBrowserImplProvider.class;
        synchronized (WebBrowserImplProvider.class) {
            browserCL = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static String[] getFXClassPath() {
        Collection pathProviders = Lookup.getDefault().lookupAll(JFXRuntimePathProvider.class);
        for (JFXRuntimePathProvider rtPathProvider : pathProviders) {
            String rtPath = rtPathProvider.getJFXRuntimePath();
            if (rtPath == null) continue;
            return new String[]{rtPath + File.separatorChar + "lib" + File.separatorChar + "jfxrt.jar"};
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassLoader getBrowserClassLoader(File runtimePath) {
        Class<WebBrowserImplProvider> clazz = WebBrowserImplProvider.class;
        synchronized (WebBrowserImplProvider.class) {
            if (null != runtimePath) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return WebBrowserImplProvider.createBrowserClassLoader(runtimePath);
            }
            if (browserCL != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return browserCL;
            }
            browserCL = WebBrowserImplProvider.createBrowserClassLoader(null);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return browserCL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URLClassLoader createBrowserClassLoader(File runtimePath) {
        Class<WebBrowserImplProvider> clazz = WebBrowserImplProvider.class;
        synchronized (WebBrowserImplProvider.class) {
            File extjar = InstalledFileLocator.getDefault().locate("modules/ext/core.browser.webview-ext.jar", "org.netbeans.core.browser.webview", false);
            if (extjar == null) {
                log.log(Level.INFO, "core.browser.webview-ext.jar not found");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            String[] fxpath = null;
            fxpath = null == runtimePath ? WebBrowserImplProvider.getFXClassPath() : new String[]{new File(new File(runtimePath, "lib"), "jfxrt.jar").getAbsolutePath()};
            if (fxpath == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            ArrayList<URL> urls = new ArrayList<URL>();
            try {
                urls.add(extjar.toURI().toURL());
                for (String fx : fxpath) {
                    urls.add(new File(fx).toURI().toURL());
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return new URLClassLoader(urls.toArray(new URL[0]), WebBrowserImplProvider.class.getClassLoader());
            }
            catch (MalformedURLException m) {
                log.log(Level.INFO, m.getMessage(), m);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
        }
    }

    static {
        log = Logger.getLogger(WebBrowserImplProvider.class.getName());
    }

    public static interface JFXRuntimePathProvider {
        public String getJFXRuntimePath();
    }
}

