/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.browser.webview;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.core.HtmlBrowserComponent;
import org.netbeans.core.browser.api.WebBrowser;
import org.netbeans.core.browser.webview.DefaultJFXRuntimeProvider;
import org.netbeans.core.browser.webview.NoWebBrowserImpl;
import org.netbeans.core.browser.webview.WebBrowserImplProvider;
import org.netbeans.modules.web.browser.api.WebBrowserPane;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

class RuntimePathPanel
extends JPanel {
    private JButton btnBrowse;
    private JLabel lblRuntime;

    public RuntimePathPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.lblRuntime = new JLabel();
        this.btnBrowse = new JButton();
        this.setLayout(new GridBagLayout());
        this.lblRuntime.setText(NbBundle.getMessage(RuntimePathPanel.class, (String)"RuntimePathPanel.lblRuntime.text"));
        this.add((Component)this.lblRuntime, new GridBagConstraints());
        this.btnBrowse.setText(NbBundle.getMessage(RuntimePathPanel.class, (String)"RuntimePathPanel.btnBrowse.text"));
        this.btnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RuntimePathPanel.this.btnBrowseActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.add((Component)this.btnBrowse, gridBagConstraints);
    }

    private void btnBrowseActionPerformed(ActionEvent evt) {
        File runtimePath = RuntimePathPanel.browseRuntimeFolder();
        if (null != runtimePath) {
            DefaultJFXRuntimeProvider.setJFXRuntimePath(runtimePath);
            TopComponent parent = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this);
            if (parent instanceof HtmlBrowserComponent) {
                RuntimePathPanel.reopenBrowser((HtmlBrowserComponent)parent);
            }
        }
    }

    static File browseRuntimeFolder() {
        FileChooserBuilder fcb = new FileChooserBuilder(RuntimePathPanel.class);
        fcb.setDirectoriesOnly(true);
        fcb.setTitle(NbBundle.getMessage(RuntimePathPanel.class, (String)"Title_BrowserRuntime"));
        final boolean[] appendRT = new boolean[1];
        final boolean[] appendJRE = new boolean[1];
        fcb.setSelectionApprover(new FileChooserBuilder.SelectionApprover(){

            public boolean approve(File[] selection) {
                if (selection == null || selection.length != 1) {
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(RuntimePathPanel.class, (String)"Err_NoFolderSelected")));
                    return false;
                }
                appendRT[0] = false;
                appendJRE[0] = false;
                WebBrowser browser = WebBrowserImplProvider.createBrowser(selection[0]);
                if (null == browser || browser instanceof NoWebBrowserImpl) {
                    browser = WebBrowserImplProvider.createBrowser(new File(selection[0], "rt"));
                    appendRT[0] = true;
                }
                if (null == browser || browser instanceof NoWebBrowserImpl) {
                    appendRT[0] = false;
                    browser = WebBrowserImplProvider.createBrowser(new File(selection[0], "jre"));
                    appendJRE[0] = true;
                }
                if (null == browser || browser instanceof NoWebBrowserImpl) {
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(RuntimePathPanel.class, (String)"Err_NoRuntimeFolder")));
                    return false;
                }
                return true;
            }
        });
        fcb.setApproveText(NbBundle.getMessage(RuntimePathPanel.class, (String)"Btn_SELECT"));
        JFileChooser chooser = fcb.createFileChooser();
        int res = chooser.showOpenDialog(WindowManager.getDefault().getMainWindow());
        if (res != 0) {
            return null;
        }
        File runtimePath = chooser.getSelectedFile();
        if (appendRT[0]) {
            runtimePath = new File(runtimePath, "rt");
        } else if (appendJRE[0]) {
            runtimePath = new File(runtimePath, "jre");
        }
        return runtimePath;
    }

    private static void reopenBrowser(final HtmlBrowserComponent browser) {
        HtmlBrowser.Impl impl = browser.getBrowserImpl();
        final WebBrowserPane browserPane = (WebBrowserPane)browser.getClientProperty((Object)"web.browser.pane");
        final URL url = impl.getURL();
        browser.setURL((URL)null);
        if (null != browserPane) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    browser.close();
                    browserPane.showURL(url);
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    browser.recreateBrowser();
                    browser.getBrowserImpl().setURL(url);
                    browser.requestActive();
                }
            });
        }
    }
}

