/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.browser.webview;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Session;
import org.netbeans.core.browser.api.WebBrowser;
import org.netbeans.core.browser.webview.MessageDispatcherImpl;
import org.netbeans.core.browser.webview.NoWebBrowserImpl;
import org.netbeans.core.browser.webview.WebBrowserImplProvider;
import org.netbeans.modules.web.browser.api.PageInspector;
import org.netbeans.modules.web.browser.spi.EnhancedBrowser;
import org.netbeans.modules.web.webkit.debugging.api.WebKitDebugging;
import org.netbeans.modules.web.webkit.debugging.spi.TransportImplementation;
import org.netbeans.modules.web.webkit.debugging.spi.netbeansdebugger.NetBeansJavaScriptDebuggerFactory;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.ProxyLookup;

public class HtmlBrowserImpl
extends HtmlBrowser.Impl
implements EnhancedBrowser {
    private static RequestProcessor RP = new RequestProcessor(HtmlBrowserImpl.class);
    private WebBrowser browser;
    private final Object LOCK = new Object();
    private Session session;
    private boolean disablePageInspector = false;
    private Lookup projectContext;
    private boolean initialized = false;

    public HtmlBrowserImpl() {
    }

    public HtmlBrowserImpl(WebBrowser browser) {
        this.browser = browser;
    }

    public Component getComponent() {
        return this.getBrowser().getComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebBrowser getBrowser() {
        Object object = this.LOCK;
        synchronized (object) {
            if (null == this.browser) {
                this.browser = WebBrowserImplProvider.createBrowser();
                try {
                    this.browser.getComponent();
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable ex) {
                    Logger.getLogger(HtmlBrowserImpl.class.getName()).log(Level.INFO, ex.getMessage(), ex);
                    this.browser = new NoWebBrowserImpl(ex.getMessage());
                }
            }
            return this.browser;
        }
    }

    private EnhancedBrowser getEnhancedBrowser() {
        WebBrowser wb = this.getBrowser();
        if (wb instanceof EnhancedBrowser) {
            return (EnhancedBrowser)wb;
        }
        return null;
    }

    public void reloadDocument() {
        this.init();
        this.getBrowser().reloadDocument();
    }

    public void stopLoading() {
        this.getBrowser().stopLoading();
    }

    public Lookup getLookup() {
        return this.getBrowser().getLookup();
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.getBrowser();
        final TransportImplementation transport = (TransportImplementation)this.getLookup().lookup(TransportImplementation.class);
        final WebKitDebugging webkitDebugger = (WebKitDebugging)this.getLookup().lookup(WebKitDebugging.class);
        final NetBeansJavaScriptDebuggerFactory debuggerFactory = (NetBeansJavaScriptDebuggerFactory)Lookup.getDefault().lookup(NetBeansJavaScriptDebuggerFactory.class);
        if (webkitDebugger == null || debuggerFactory == null || this.projectContext == null) {
            return;
        }
        RP.post(new Runnable(){

            @Override
            public void run() {
                transport.attach();
                webkitDebugger.getDebugger().enable();
                HtmlBrowserImpl.this.session = debuggerFactory.createDebuggingSession(webkitDebugger, HtmlBrowserImpl.this.projectContext);
                PageInspector inspector = PageInspector.getDefault();
                if (inspector != null && !HtmlBrowserImpl.this.disablePageInspector) {
                    inspector.inspectPage((Lookup)new ProxyLookup(new Lookup[]{HtmlBrowserImpl.this.getLookup(), HtmlBrowserImpl.this.projectContext}));
                }
            }
        });
    }

    private void destroy() {
        if (!this.initialized) {
            return;
        }
        this.initialized = false;
        final TransportImplementation transport = (TransportImplementation)this.getLookup().lookup(TransportImplementation.class);
        final WebKitDebugging webkitDebugger = (WebKitDebugging)this.getLookup().lookup(WebKitDebugging.class);
        final NetBeansJavaScriptDebuggerFactory debuggerFactory = (NetBeansJavaScriptDebuggerFactory)Lookup.getDefault().lookup(NetBeansJavaScriptDebuggerFactory.class);
        final MessageDispatcherImpl dispatcher = (MessageDispatcherImpl)((Object)this.getLookup().lookup(MessageDispatcherImpl.class));
        if (webkitDebugger == null || debuggerFactory == null) {
            return;
        }
        RP.post(new Runnable(){

            @Override
            public void run() {
                if (HtmlBrowserImpl.this.session != null) {
                    debuggerFactory.stopDebuggingSession(HtmlBrowserImpl.this.session);
                }
                HtmlBrowserImpl.this.session = null;
                if (dispatcher != null) {
                    dispatcher.dispatchMessage("inspect", null);
                }
                if (webkitDebugger.getDebugger().isEnabled()) {
                    webkitDebugger.getDebugger().disable();
                }
                webkitDebugger.reset();
                transport.detach();
            }
        });
    }

    public void setURL(URL url) {
        this.init();
        this.getBrowser().setURL(url.toString());
    }

    public URL getURL() {
        String strUrl = this.getBrowser().getURL();
        if (null == strUrl) {
            return null;
        }
        try {
            return new URL(strUrl);
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(HtmlBrowserImpl.class.getName()).log(Level.FINE, null, ex);
            return null;
        }
    }

    public String getLocation() {
        return this.getBrowser().getURL();
    }

    public void setLocation(String str) {
        this.getBrowser().setURL(str);
    }

    public String getStatusMessage() {
        return this.getBrowser().getStatusMessage();
    }

    public String getTitle() {
        return this.getBrowser().getTitle();
    }

    public boolean isForward() {
        return this.getBrowser().isForward();
    }

    public void forward() {
        this.getBrowser().forward();
    }

    public boolean isBackward() {
        return this.getBrowser().isBackward();
    }

    public void backward() {
        this.getBrowser().backward();
    }

    public boolean isHistory() {
        return this.getBrowser().isHistory();
    }

    public void showHistory() {
        this.getBrowser().showHistory();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getBrowser().addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.getBrowser().removePropertyChangeListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.destroy();
        Object object = this.LOCK;
        synchronized (object) {
            if (null != this.browser) {
                this.browser.dispose();
            }
            this.browser = null;
        }
    }

    public boolean hasEnhancedMode() {
        if (this.getEnhancedBrowser() != null) {
            return this.getEnhancedBrowser().hasEnhancedMode();
        }
        return false;
    }

    public void setEnhancedMode(boolean mode) {
        if (this.getEnhancedBrowser() != null) {
            this.getEnhancedBrowser().setEnhancedMode(mode);
        }
    }

    public void disablePageInspector() {
        this.disablePageInspector = true;
        if (this.getEnhancedBrowser() != null) {
            this.getEnhancedBrowser().disablePageInspector();
        }
    }

    public void enableLiveHTML() {
        if (this.getEnhancedBrowser() != null) {
            this.getEnhancedBrowser().enableLiveHTML();
        }
    }

    public void close(boolean closeTab) {
        if (this.getEnhancedBrowser() != null) {
            this.getEnhancedBrowser().close(closeTab);
        }
        this.destroy();
        if (closeTab) {
            // empty if block
        }
    }

    public void setProjectContext(Lookup projectContext) {
        this.projectContext = projectContext;
        if (this.getEnhancedBrowser() != null) {
            this.getEnhancedBrowser().setProjectContext(projectContext);
        }
    }
}

