/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.browser.webview;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyEditor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.core.browser.webview.DefaultJFXRuntimeProvider;
import org.netbeans.core.browser.webview.RuntimePathPanel;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class EmbeddedBrowserEditor
extends JPanel
implements ItemListener {
    private static final String BROWSERS_FOLDER = "Services/Browsers";
    private final List<? extends DataObject> browsers;
    private final PropertyEditor property;
    private JButton btnBrowser;
    private JCheckBox checkAnotherBrowser;
    private JComboBox comboBrowsers;
    private JLabel lblRuntimeLocation;
    private JTextField txtRuntimeLocation;

    public EmbeddedBrowserEditor(PropertyEditor prop) {
        this.property = prop;
        this.initComponents();
        this.browsers = this.loadBrowserList();
        this.checkAnotherBrowser.setSelected(true);
        String[] names = new String[this.browsers.size()];
        for (int i = 0; i < this.browsers.size(); ++i) {
            names[i] = this.browsers.get(i).getNodeDelegate().getDisplayName();
        }
        this.checkAnotherBrowser.setSelected(prop.getValue() != null);
        this.comboBrowsers.setModel(new DefaultComboBoxModel<String>(names));
        if (this.browsers.isEmpty()) {
            this.checkAnotherBrowser.setEnabled(false);
            this.checkAnotherBrowser.setSelected(false);
            this.comboBrowsers.setSelectedIndex(-1);
        } else if (null != prop.getValue()) {
            this.selectBrowser((HtmlBrowser.Factory)prop.getValue());
        }
        this.checkAnotherBrowser.addItemListener(this);
        this.comboBrowsers.addItemListener(this);
        this.txtRuntimeLocation.setText(new DefaultJFXRuntimeProvider().getJFXRuntimePath());
    }

    private void initComponents() {
        this.checkAnotherBrowser = new JCheckBox();
        this.comboBrowsers = new JComboBox();
        this.lblRuntimeLocation = new JLabel();
        this.txtRuntimeLocation = new JTextField();
        this.btnBrowser = new JButton();
        this.checkAnotherBrowser.setText(NbBundle.getMessage(EmbeddedBrowserEditor.class, (String)"EmbeddedBrowserEditor.checkAnotherBrowser.text"));
        this.lblRuntimeLocation.setText(NbBundle.getMessage(EmbeddedBrowserEditor.class, (String)"EmbeddedBrowserEditor.lblRuntimeLocation.text"));
        this.txtRuntimeLocation.setEditable(false);
        this.btnBrowser.setText(NbBundle.getMessage(EmbeddedBrowserEditor.class, (String)"EmbeddedBrowserEditor.btnBrowser.text"));
        this.btnBrowser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EmbeddedBrowserEditor.this.btnBrowserActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.comboBrowsers, 0, 398, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.txtRuntimeLocation).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnBrowser)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.checkAnotherBrowser).addComponent(this.lblRuntimeLocation)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.checkAnotherBrowser).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBrowsers, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblRuntimeLocation).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtRuntimeLocation, -2, -1, -2).addComponent(this.btnBrowser)).addContainerGap(26, Short.MAX_VALUE)));
    }

    private void btnBrowserActionPerformed(ActionEvent evt) {
        File f = RuntimePathPanel.browseRuntimeFolder();
        if (null != f) {
            this.txtRuntimeLocation.setText(f.getAbsolutePath());
            DefaultJFXRuntimeProvider.setJFXRuntimePath(f);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.comboBrowsers.setEnabled(this.checkAnotherBrowser.isSelected());
        this.storeSettings();
    }

    private void storeSettings() {
        if (this.checkAnotherBrowser.isSelected()) {
            DataObject dob = this.browsers.get(this.comboBrowsers.getSelectedIndex());
            HtmlBrowser.Factory newBrowser = null;
            try {
                newBrowser = (HtmlBrowser.Factory)((InstanceCookie)dob.getLookup().lookup(InstanceCookie.class)).instanceCreate();
                Lookup.Result res = Lookup.getDefault().lookupResult(HtmlBrowser.Factory.class);
                for (HtmlBrowser.Factory brow : res.allInstances()) {
                    if (!brow.equals(newBrowser)) continue;
                    newBrowser = brow;
                    break;
                }
                this.property.setValue(newBrowser);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ClassNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            this.property.setValue(null);
        }
    }

    private List<? extends DataObject> loadBrowserList() {
        ArrayList<DataObject> res = new ArrayList<DataObject>(20);
        FileObject servicesBrowsers = FileUtil.getConfigFile((String)BROWSERS_FOLDER);
        if (servicesBrowsers != null) {
            DataObject[] browserSettings;
            DataFolder folder = DataFolder.findFolder((FileObject)servicesBrowsers);
            for (DataObject browserSetting : browserSettings = folder.getChildren()) {
                InstanceCookie cookie = (InstanceCookie)browserSetting.getLookup().lookup(InstanceCookie.class);
                FileObject primaryFile = browserSetting.getPrimaryFile();
                if ("EmbeddedBrowser.settings".equals(primaryFile.getNameExt()) || cookie == null || Boolean.TRUE.equals(primaryFile.getAttribute("hidden"))) continue;
                res.add(browserSetting);
            }
        }
        return res;
    }

    private void selectBrowser(HtmlBrowser.Factory browser) {
        int selIndex = -1;
        for (int i = 0; i < this.browsers.size(); ++i) {
            DataObject dob = this.browsers.get(i);
            InstanceCookie cookie = (InstanceCookie)dob.getLookup().lookup(InstanceCookie.class);
            try {
                if (!browser.equals(cookie.instanceCreate())) continue;
                selIndex = i;
                break;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                continue;
            }
            catch (ClassNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.comboBrowsers.setSelectedIndex(selIndex);
    }
}

