/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.browser.webview;

import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.core.IDESettings;
import org.netbeans.core.browser.webview.HtmlBrowserImpl;
import org.netbeans.modules.web.browser.api.BrowserFamilyId;
import org.netbeans.modules.web.browser.spi.EnhancedBrowserFactory;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public class BrowserFactory
implements HtmlBrowser.Factory,
EnhancedBrowserFactory {
    static String PROP_EXTRA_BROWSER = "ExtraBrowser";

    public HtmlBrowser.Impl createHtmlBrowserImpl() {
        HtmlBrowser.Factory extraFactory = BrowserFactory._getExtraBrowser();
        if (null != extraFactory) {
            return extraFactory.createHtmlBrowserImpl();
        }
        return this.createImpl();
    }

    protected HtmlBrowser.Impl createImpl() {
        return new HtmlBrowserImpl();
    }

    public static Boolean isHidden() {
        return false;
    }

    public HtmlBrowser.Factory getExtraBrowser() {
        return BrowserFactory._getExtraBrowser();
    }

    public void setExtraBrowser(HtmlBrowser.Factory browser) {
        BrowserFactory._setExtraBrowser(browser);
    }

    static HtmlBrowser.Factory _getExtraBrowser() {
        String id = NbPreferences.forModule(BrowserFactory.class).get("extraBrowser", null);
        if (null == id || "".equals(id)) {
            return null;
        }
        Lookup.Item item = Lookup.getDefault().lookupItem(new Lookup.Template(HtmlBrowser.Factory.class, id, null));
        return item == null ? null : (HtmlBrowser.Factory)item.getInstance();
    }

    static void _setExtraBrowser(HtmlBrowser.Factory browser) {
        String browserId = null;
        if (null != browser) {
            Lookup.Item item = Lookup.getDefault().lookupItem(new Lookup.Template(HtmlBrowser.Factory.class, null, (Object)browser));
            if (item != null) {
                browserId = item.getId();
            } else {
                Logger.getLogger(IDESettings.class.getName()).warning("Cannot find browser in lookup " + browser);
            }
        }
        if (null == browserId) {
            browserId = "";
        }
        NbPreferences.forModule(BrowserFactory.class).put("extraBrowser", browserId);
        Preferences idePrefs = NbPreferences.forModule(IDESettings.class);
        String wwwBrowser = idePrefs.get("WWWBrowser", null);
        idePrefs.put("WWWBrowser", "");
        idePrefs.put("WWWBrowser", wwwBrowser);
    }

    public BrowserFamilyId getBrowserFamilyId() {
        return BrowserFamilyId.JAVAFX_WEBVIEW;
    }
}

