/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions.remote;

import java.rmi.server.ObjID;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.queries.CursoredStream;
import org.eclipse.persistence.sessions.remote.RemoteSession;

public class RemoteCursoredStream
extends CursoredStream {
    protected ObjID id = new ObjID();
    protected boolean isClosed;
    protected int pageSize;

    public RemoteCursoredStream(CursoredStream serverCursoredStream) {
        this.position = serverCursoredStream.getPosition();
        this.pageSize = serverCursoredStream.getPageSize();
        this.isClosed = serverCursoredStream.getResultSet() == null;
    }

    public void close() throws DatabaseException {
        if (this.isClosed()) {
            return;
        }
        ((RemoteSession)this.getSession()).getRemoteConnection().cursoredStreamClose(this.getID());
    }

    protected int getCursorSize() {
        return ((RemoteSession)this.getSession()).getRemoteConnection().cursoredStreamSize(this.getID());
    }

    public ObjID getID() {
        return this.id;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    protected Object retrieveNextPage() throws DatabaseException {
        if (this.isClosed()) {
            return null;
        }
        Vector nextPageObjects = ((RemoteSession)this.getSession()).getRemoteConnection().cursoredStreamNextPage(this, this.getPolicy().getQuery(), (RemoteSession)this.getSession(), this.getPageSize());
        if (nextPageObjects == null || nextPageObjects.isEmpty()) {
            return null;
        }
        this.getObjectCollection().addAll(nextPageObjects);
        return this.getObjectCollection().get(this.getObjectCollection().size() - 1);
    }
}

