/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.ui;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.lang.model.element.TypeElement;
import javax.swing.Icon;
import org.apache.lucene.document.Document;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.ui.TypeElementFinder;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.java.BinaryElementOpen;
import org.netbeans.modules.java.source.ui.JavaTypeDescription;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexImplEvent;
import org.netbeans.modules.java.source.usages.ClassIndexImplListener;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.java.source.usages.DocumentUtil;
import org.netbeans.modules.parsing.lucene.support.Convertor;
import org.netbeans.modules.parsing.lucene.support.Index;
import org.netbeans.modules.parsing.lucene.support.IndexManager;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.jumpto.support.NameMatcherFactory;
import org.netbeans.spi.jumpto.type.SearchType;
import org.netbeans.spi.jumpto.type.TypeProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class JavaTypeProvider
implements TypeProvider {
    private static final Logger LOGGER = Logger.getLogger(JavaTypeProvider.class.getName());
    private static final Level LEVEL = Level.FINE;
    private static final Collection<? extends JavaTypeDescription> ACTIVE = Collections.unmodifiableSet(new HashSet());
    private Map<URI, CacheItem> rootCache;
    private final Map<CacheItem, Collection<? extends JavaTypeDescription>> dataCache = Collections.synchronizedMap(new HashMap());
    private String lastText;
    private SearchType lastType;
    private volatile boolean isCanceled = false;
    private ClasspathInfo cpInfo;
    private final TypeElementFinder.Customizer customizer;
    private final CacheItem.DataCacheCallback callBack = new CacheItem.DataCacheCallback(){

        @Override
        public void handleDataCacheChange(CacheItem ci) {
            assert (ci != null);
            JavaTypeProvider.this.dataCache.put(ci, null);
        }
    };
    private static Pattern camelCasePattern = Pattern.compile("(?:\\p{javaUpperCase}(?:\\p{javaLowerCase}|\\p{Digit}|\\.|\\$)*){2,}");

    public String name() {
        return "java";
    }

    public String getDisplayName() {
        return "Java Classes";
    }

    public void cleanup() {
        this.isCanceled = false;
        this.lastText = null;
        this.lastType = null;
        this.dataCache.clear();
        this.setRootCache(null);
    }

    public void cancel() {
        this.isCanceled = true;
    }

    public JavaTypeProvider() {
        this(null, null);
    }

    public JavaTypeProvider(ClasspathInfo cpInfo, TypeElementFinder.Customizer customizer) {
        this.cpInfo = cpInfo;
        this.customizer = customizer;
    }

    public void computeTypeNames(TypeProvider.Context context, TypeProvider.Result res) {
        Map<URI, CacheItem> c;
        ClassIndex.NameKind nameKind;
        this.isCanceled = false;
        String originalText = context.getText();
        SearchType searchType = context.getSearchType();
        if (!originalText.equals(this.lastText) || !searchType.equals((Object)this.lastType)) {
            this.dataCache.clear();
            this.lastText = originalText;
            this.lastType = searchType;
        }
        boolean hasBinaryOpen = Lookup.getDefault().lookup(BinaryElementOpen.class) != null;
        switch (searchType) {
            case EXACT_NAME: {
                nameKind = ClassIndex.NameKind.SIMPLE_NAME;
                break;
            }
            case CASE_INSENSITIVE_EXACT_NAME: {
                nameKind = ClassIndex.NameKind.CASE_INSENSITIVE_REGEXP;
                break;
            }
            case PREFIX: {
                nameKind = ClassIndex.NameKind.PREFIX;
                break;
            }
            case CASE_INSENSITIVE_PREFIX: {
                nameKind = ClassIndex.NameKind.CASE_INSENSITIVE_PREFIX;
                break;
            }
            case REGEXP: {
                nameKind = ClassIndex.NameKind.REGEXP;
                break;
            }
            case CASE_INSENSITIVE_REGEXP: {
                nameKind = ClassIndex.NameKind.CASE_INSENSITIVE_REGEXP;
                break;
            }
            case CAMEL_CASE: {
                nameKind = ClassIndex.NameKind.CAMEL_CASE;
                break;
            }
            default: {
                throw new RuntimeException("Unexpected search type: " + searchType);
            }
        }
        Future openProjectsTask = OpenProjects.getDefault().openProjects();
        try {
            openProjectsTask.get();
        }
        catch (InterruptedException ex) {
            LOGGER.fine(ex.getMessage());
        }
        catch (ExecutionException ex) {
            LOGGER.fine(ex.getMessage());
        }
        if (this.getRootCache() == null) {
            HashMap<URI, CacheItem> sources = null;
            if (this.cpInfo == null) {
                sources = new HashMap<URI, CacheItem>();
                Collection srcRoots = QuerySupport.findRoots((Project)null, Collections.singleton("classpath/source"), Collections.emptySet(), Collections.emptySet());
                for (FileObject root : srcRoots) {
                    if (this.isCanceled) {
                        return;
                    }
                    URL rootUrl = root.toURL();
                    if (this.isCanceled) {
                        return;
                    }
                    try {
                        sources.put(rootUrl.toURI(), new CacheItem(rootUrl, "classpath/source", this.callBack));
                    }
                    catch (URISyntaxException ex) {
                        LOGGER.log(Level.INFO, "Cannot convert root {0} into URI, ignoring.", rootUrl);
                    }
                }
                Collection binRoots = QuerySupport.findRoots((Project)null, Collections.emptySet(), Collections.emptySet(), Arrays.asList("classpath/compile", "classpath/boot"));
                for (FileObject root : binRoots) {
                    SourceForBinaryQuery.Result result;
                    if (this.isCanceled) {
                        return;
                    }
                    URL rootUrl = root.toURL();
                    if (!hasBinaryOpen && (result = SourceForBinaryQuery.findSourceRoots((URL)rootUrl)).getRoots().length == 0) continue;
                    if (this.isCanceled) {
                        return;
                    }
                    try {
                        URI rootURI = rootUrl.toURI();
                        if (sources.containsKey(rootURI)) continue;
                        sources.put(rootURI, new CacheItem(rootUrl, "classpath/boot", this.callBack));
                    }
                    catch (URISyntaxException ex) {
                        LOGGER.log(Level.INFO, "Cannot convert root {0} into URI, ignoring.", rootUrl);
                    }
                }
            } else {
                List bootRoots = this.cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT).entries();
                List compileRoots = this.cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE).entries();
                List sourceRoots = this.cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE).entries();
                sources = new HashMap(bootRoots.size() + compileRoots.size() + sourceRoots.size());
                for (ClassPath.Entry entry : bootRoots) {
                    if (this.isCanceled) {
                        return;
                    }
                    try {
                        sources.put(entry.getURL().toURI(), new CacheItem(entry.getURL(), "classpath/boot", this.callBack));
                    }
                    catch (URISyntaxException ex) {
                        LOGGER.log(Level.INFO, "Cannot convert root {0} into URI, ignoring.", entry.getURL());
                    }
                }
                for (ClassPath.Entry entry : compileRoots) {
                    if (this.isCanceled) {
                        return;
                    }
                    try {
                        sources.put(entry.getURL().toURI(), new CacheItem(entry.getURL(), "classpath/compile", this.callBack));
                    }
                    catch (URISyntaxException ex) {
                        LOGGER.log(Level.INFO, "Cannot convert root {0} into URI, ignoring.", entry.getURL());
                    }
                }
                for (ClassPath.Entry entry : sourceRoots) {
                    if (this.isCanceled) {
                        return;
                    }
                    try {
                        sources.put(entry.getURL().toURI(), new CacheItem(entry.getURL(), "classpath/source", this.callBack));
                    }
                    catch (URISyntaxException ex) {
                        LOGGER.log(Level.INFO, "Cannot convert root {0} into URI, ignoring.", entry.getURL());
                    }
                }
            }
            if (!this.isCanceled) {
                if (LOGGER.isLoggable(LEVEL)) {
                    LOGGER.log(LEVEL, "Querying following roots:");
                    for (CacheItem ci : sources.values()) {
                        LOGGER.log(LEVEL, "  {0}; binary={1}", new Object[]{ci.getRoot().toURI(), ci.isBinary()});
                    }
                    LOGGER.log(LEVEL, "-------------------------");
                }
                this.setRootCache(sources);
            } else {
                return;
            }
        }
        if ((c = this.getRootCache()) == null) {
            return;
        }
        final ArrayList<? extends JavaTypeDescription> types = new ArrayList<JavaTypeDescription>(c.size() * 20);
        boolean scanInProgress = SourceUtils.isScanInProgress();
        if (scanInProgress) {
            String message = NbBundle.getMessage(JavaTypeProvider.class, (String)"LBL_ScanInProgress_warning");
            res.setMessage(message);
        } else {
            res.setMessage(null);
        }
        int lastIndexOfDot = originalText.lastIndexOf(".");
        boolean isFullyQualifiedName = -1 != lastIndexOfDot;
        final Pattern packageName = isFullyQualifiedName ? JavaTypeProvider.createPackageRegExp(originalText.substring(0, lastIndexOfDot)) : null;
        String typeName = isFullyQualifiedName ? originalText.substring(lastIndexOfDot + 1) : originalText;
        final String textForQuery = JavaTypeProvider.getTextForQuery(typeName, nameKind, context.getSearchType());
        LOGGER.log(Level.FINE, "Text For Query ''{0}''.", originalText);
        if (this.customizer != null) {
            for (CacheItem ci : c.values()) {
                HashSet<ElementHandle<TypeElement>> names = new HashSet<ElementHandle<TypeElement>>(this.customizer.query(ci.getClasspathInfo(), textForQuery, nameKind, EnumSet.of(ci.isBinary ? ClassIndex.SearchScope.DEPENDENCIES : ClassIndex.SearchScope.SOURCE)));
                if (nameKind == ClassIndex.NameKind.CAMEL_CASE) {
                    names.addAll(this.customizer.query(ci.getClasspathInfo(), textForQuery, ClassIndex.NameKind.CASE_INSENSITIVE_PREFIX, EnumSet.of(ci.isBinary ? ClassIndex.SearchScope.DEPENDENCIES : ClassIndex.SearchScope.SOURCE)));
                }
                for (ElementHandle elementHandle : names) {
                    JavaTypeDescription td = new JavaTypeDescription(ci, (ElementHandle<TypeElement>)elementHandle);
                    types.add(td);
                    if (!this.isCanceled) continue;
                    return;
                }
            }
        } else {
            final ArrayDeque<CacheItem> nonCached = new ArrayDeque<CacheItem>(c.size());
            for (CacheItem ci : c.values()) {
                Collection<? extends JavaTypeDescription> cacheLine = this.dataCache.get(ci);
                if (cacheLine != null) {
                    types.addAll(cacheLine);
                    continue;
                }
                nonCached.add(ci);
            }
            if (!nonCached.isEmpty()) {
                try {
                    IndexManager.priorityAccess((IndexManager.Action)new IndexManager.Action<Void>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Void run() throws IOException, InterruptedException {
                            for (CacheItem ci : nonCached) {
                                if (JavaTypeProvider.this.isCanceled) {
                                    return null;
                                }
                                try {
                                    block19: {
                                        HashSet ct = new HashSet();
                                        boolean exists = false;
                                        JavaTypeProvider.this.dataCache.put(ci, ACTIVE);
                                        try {
                                            exists = ci.collectDeclaredTypes(packageName, textForQuery, nameKind, ct);
                                            if (nameKind == ClassIndex.NameKind.CAMEL_CASE) {
                                                exists &= ci.collectDeclaredTypes(packageName, textForQuery, ClassIndex.NameKind.CASE_INSENSITIVE_PREFIX, ct);
                                            }
                                            if (exists) {
                                                types.addAll(ct);
                                            }
                                            if (!exists) break block19;
                                        }
                                        catch (Throwable throwable) {
                                            if (exists) {
                                                Map map = JavaTypeProvider.this.dataCache;
                                                synchronized (map) {
                                                    if (JavaTypeProvider.this.dataCache.get(ci) == ACTIVE) {
                                                        JavaTypeProvider.this.dataCache.put(ci, ct.isEmpty() ? Collections.emptySet() : ct);
                                                    }
                                                }
                                            } else {
                                                JavaTypeProvider.this.dataCache.put(ci, null);
                                            }
                                            throw throwable;
                                        }
                                        Map map = JavaTypeProvider.this.dataCache;
                                        synchronized (map) {
                                            if (JavaTypeProvider.this.dataCache.get(ci) == ACTIVE) {
                                                JavaTypeProvider.this.dataCache.put(ci, ct.isEmpty() ? Collections.emptySet() : ct);
                                            }
                                            continue;
                                        }
                                    }
                                    JavaTypeProvider.this.dataCache.put(ci, null);
                                }
                                catch (IOException ioe) {
                                    Exceptions.printStackTrace((Throwable)ioe);
                                }
                                catch (InterruptedException ie) {
                                    throw new AssertionError((Object)ie);
                                }
                            }
                            return null;
                        }
                    });
                }
                catch (IOException ex) {
                    throw new AssertionError((Object)ex);
                }
                catch (InterruptedException ex) {
                    throw new AssertionError((Object)ex);
                }
            }
            if (this.isCanceled) {
                return;
            }
            if (scanInProgress) {
                res.pendingResult();
            }
        }
        if (!this.isCanceled) {
            res.addResult(types);
        }
    }

    static String removeNonJavaChars(String text) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!Character.isJavaIdentifierPart(c) && c != '*' && c != '?') continue;
            sb.append(c);
        }
        return sb.toString();
    }

    @CheckForNull
    private Map<URI, CacheItem> getRootCache() {
        if (LOGGER.isLoggable(LEVEL) && this.rootCache == null) {
            LOGGER.log(LEVEL, "Returning null cache entries.", new Exception());
        }
        return this.rootCache == null ? null : Collections.unmodifiableMap(this.rootCache);
    }

    private void setRootCache(@NullAllowed Map<URI, CacheItem> cache) {
        if (LOGGER.isLoggable(LEVEL)) {
            LOGGER.log(LEVEL, "Setting cache entries from " + this.rootCache + " to " + cache + ".", new Exception());
        }
        if (this.rootCache != null) {
            for (CacheItem ci : this.rootCache.values()) {
                ci.dispose();
            }
        }
        this.rootCache = cache;
    }

    private static String getTextForQuery(String text, ClassIndex.NameKind nameKind, SearchType searchType) {
        String textForQuery;
        switch (nameKind) {
            case REGEXP: 
            case CASE_INSENSITIVE_REGEXP: {
                textForQuery = NameMatcherFactory.wildcardsToRegexp((String)JavaTypeProvider.removeNonJavaChars(text), (searchType != SearchType.CASE_INSENSITIVE_EXACT_NAME ? 1 : 0) != 0);
                break;
            }
            default: {
                textForQuery = text;
            }
        }
        return textForQuery;
    }

    @NonNull
    private static Pattern createPackageRegExp(@NonNull String pkgName) {
        StringBuilder sb = new StringBuilder();
        sb.append("(.*\\.)?");
        for (int i = 0; i < pkgName.length(); ++i) {
            char c = pkgName.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                sb.append(c);
                continue;
            }
            if (c != '.') continue;
            sb.append(".*\\.");
        }
        sb.append(".*(\\..*)?");
        LOGGER.log(Level.FINE, "Package pattern: {0}", sb);
        return Pattern.compile(sb.toString());
    }

    @NonNull
    private static ClassIndex.NameKind translateSearchType(@NonNull String simpleName, @NonNull ClassIndex.NameKind originalSearchType) {
        if (originalSearchType == ClassIndex.NameKind.SIMPLE_NAME || originalSearchType == ClassIndex.NameKind.CASE_INSENSITIVE_REGEXP) {
            return originalSearchType;
        }
        if (JavaTypeProvider.isAllUpper(simpleName) && simpleName.length() > 1 || JavaTypeProvider.isCamelCase(simpleName)) {
            return ClassIndex.NameKind.CAMEL_CASE;
        }
        if (JavaTypeProvider.containsWildCard(simpleName) != -1) {
            return JavaTypeProvider.isCaseSensitive(originalSearchType) ? ClassIndex.NameKind.REGEXP : ClassIndex.NameKind.CASE_INSENSITIVE_REGEXP;
        }
        return JavaTypeProvider.isCaseSensitive(originalSearchType) ? ClassIndex.NameKind.PREFIX : ClassIndex.NameKind.CASE_INSENSITIVE_PREFIX;
    }

    private static boolean isCaseSensitive(@NonNull ClassIndex.NameKind originalNameKind) {
        switch (originalNameKind) {
            case CASE_INSENSITIVE_REGEXP: 
            case CAMEL_CASE_INSENSITIVE: 
            case CASE_INSENSITIVE_PREFIX: {
                return false;
            }
        }
        return true;
    }

    private static int containsWildCard(@NonNull String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '?' && text.charAt(i) != '*') continue;
            return i;
        }
        return -1;
    }

    private static boolean isAllUpper(@NonNull String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isUpperCase(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isCamelCase(String text) {
        return camelCasePattern.matcher(text).matches();
    }

    static final class CacheItem
    implements ClassIndexImplListener {
        private final URL root;
        private final URI rootURI;
        private final boolean isBinary;
        private final DataCacheCallback callBack;
        private String projectName;
        private Icon projectIcon;
        private ClasspathInfo cpInfo;
        private ClassIndexImpl index;
        private final String cpType;
        private FileObject cachedRoot;

        public CacheItem(@NullAllowed URL root, @NullAllowed String cpType, @NullAllowed DataCacheCallback callBack) throws URISyntaxException {
            this.cpType = cpType;
            this.isBinary = "classpath/boot".equals(cpType) || "classpath/compile".equals(cpType);
            this.root = root;
            this.rootURI = root == null ? null : root.toURI();
            this.callBack = callBack;
        }

        public int hashCode() {
            return this.rootURI == null ? 0 : this.rootURI.hashCode();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof CacheItem) {
                CacheItem otherItem = (CacheItem)other;
                return this.rootURI == null ? otherItem.rootURI == null : this.rootURI.equals(otherItem.rootURI);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FileObject getRoot() {
            CacheItem cacheItem = this;
            synchronized (cacheItem) {
                if (this.cachedRoot != null) {
                    return this.cachedRoot;
                }
            }
            FileObject _tmp = URLMapper.findFileObject((URL)this.root);
            CacheItem cacheItem2 = this;
            synchronized (cacheItem2) {
                if (this.cachedRoot == null) {
                    this.cachedRoot = _tmp;
                }
            }
            return _tmp;
        }

        public boolean isBinary() {
            return this.isBinary;
        }

        public synchronized String getProjectName() {
            if (!this.isBinary && this.projectName == null) {
                this.initProjectInfo();
            }
            return this.projectName;
        }

        public synchronized Icon getProjectIcon() {
            if (!this.isBinary && this.projectIcon == null) {
                this.initProjectInfo();
            }
            return this.projectIcon;
        }

        public ClasspathInfo getClasspathInfo() {
            if (this.cpInfo == null) {
                ClassPath cp = ClassPathSupport.createClassPath((URL[])new URL[]{this.root});
                this.cpInfo = this.isBinary ? ("classpath/boot".equals(this.cpType) ? ClasspathInfo.create((ClassPath)cp, (ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY) : ClasspathInfo.create((ClassPath)ClassPath.EMPTY, (ClassPath)cp, (ClassPath)ClassPath.EMPTY)) : ClasspathInfo.create((ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY, (ClassPath)cp);
            }
            return this.cpInfo;
        }

        public boolean collectDeclaredTypes(@NullAllowed Pattern packageName, @NonNull String typeName, @NonNull ClassIndex.NameKind kind, @NonNull Collection<? super JavaTypeDescription> collector) throws IOException, InterruptedException {
            ClassIndex.SearchScope searchScope;
            ClassIndex.SearchScope baseSearchScope;
            if (this.index == null) {
                this.index = ClassIndexManager.getDefault().getUsagesQuery(this.root, true);
                if (this.index == null) {
                    return false;
                }
                this.index.addClassIndexImplListener((ClassIndexImplListener)this);
            }
            ClassIndex.SearchScope searchScope2 = baseSearchScope = this.isBinary ? ClassIndex.SearchScope.DEPENDENCIES : ClassIndex.SearchScope.SOURCE;
            if (packageName != null) {
                HashSet allPackages = new HashSet();
                this.index.getPackageNames("", false, allPackages);
                Set<? extends String> packages = this.filterPackages(packageName, allPackages);
                searchScope = ClassIndex.createPackageSearchScope((ClassIndex.SearchScopeType)baseSearchScope, (String[])packages.toArray(new String[packages.size()]));
                kind = JavaTypeProvider.translateSearchType(typeName, kind);
            } else {
                searchScope = baseSearchScope;
            }
            try {
                this.index.getDeclaredTypes(typeName, kind, Collections.unmodifiableSet(Collections.singleton(searchScope)), (Convertor)new JavaTypeDescriptionConvertor(this), collector);
            }
            catch (Index.IndexClosedException ice) {
                // empty catch block
            }
            return true;
        }

        public void typesAdded(@NonNull ClassIndexImplEvent event) {
            if (this.callBack != null) {
                this.callBack.handleDataCacheChange(this);
            }
        }

        public void typesRemoved(@NonNull ClassIndexImplEvent event) {
            if (this.callBack != null) {
                this.callBack.handleDataCacheChange(this);
            }
        }

        public void typesChanged(@NonNull ClassIndexImplEvent event) {
            if (this.callBack != null) {
                this.callBack.handleDataCacheChange(this);
            }
        }

        private void initProjectInfo() {
            Project p = FileOwnerQuery.getOwner((URI)this.rootURI);
            if (p != null) {
                ProjectInformation pi = ProjectUtils.getInformation((Project)p);
                this.projectName = pi.getDisplayName();
                this.projectIcon = pi.getIcon();
            }
        }

        @NonNull
        private Set<? extends String> filterPackages(@NonNull Pattern packageName, @NonNull Set<? extends String> basePackages) {
            HashSet<String> result = new HashSet<String>();
            for (String string : basePackages) {
                if (!packageName.matcher(string).matches()) continue;
                result.add(string);
            }
            return result;
        }

        private void dispose() {
            if (this.index != null) {
                this.index.removeClassIndexImplListener((ClassIndexImplListener)this);
            }
        }

        private static class JavaTypeDescriptionConvertor
        implements Convertor<Document, JavaTypeDescription> {
            private static final Pattern ANONYMOUS = Pattern.compile(".*\\$\\d+(C|I|E|A|\\$.+)");
            private final CacheItem ci;
            private final Convertor<Document, ElementHandle<TypeElement>> delegate;

            JavaTypeDescriptionConvertor(@NonNull CacheItem ci) {
                this.ci = ci;
                this.delegate = DocumentUtil.elementHandleConvertor();
            }

            public JavaTypeDescription convert(Document p) {
                String binName = DocumentUtil.getSimpleBinaryName((Document)p);
                if (binName == null || ANONYMOUS.matcher(binName).matches()) {
                    return null;
                }
                ElementHandle eh = (ElementHandle)this.delegate.convert((Object)p);
                return eh == null ? null : new JavaTypeDescription(this.ci, (ElementHandle<TypeElement>)eh);
            }
        }

        static interface DataCacheCallback {
            public void handleDataCacheChange(@NonNull CacheItem var1);
        }
    }
}

