/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api.executable;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.modules.php.api.executable.Bundle;
import org.netbeans.modules.php.api.executable.InvalidPhpExecutableException;
import org.netbeans.modules.php.api.executable.PhpExecutableValidator;
import org.netbeans.modules.php.api.executable.PhpInterpreter;
import org.netbeans.modules.php.api.util.Pair;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.openide.util.Parameters;
import org.openide.util.Utilities;
import org.openide.windows.InputOutput;

public final class PhpExecutable {
    private static final Logger LOGGER = Logger.getLogger(PhpExecutable.class.getName());
    public static final ExecutionDescriptor.InputProcessorFactory ANSI_STRIPPING_FACTORY = new ExecutionDescriptor.InputProcessorFactory(){

        public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
            return InputProcessors.ansiStripping((InputProcessor)defaultProcessor);
        }
    };
    public static final ExecutionDescriptor DEFAULT_EXECUTION_DESCRIPTOR = new ExecutionDescriptor().controllable(true).frontWindow(true).frontWindowOnError(true).inputVisible(true).showProgress(true);
    private final String executable;
    private final List<String> parameters;
    private final String command;
    final List<String> fullCommand = new CopyOnWriteArrayList<String>();
    private String executableName = null;
    private String displayName = null;
    private String optionsSubcategory = null;
    private boolean viaPhpInterpreter = false;
    private boolean viaAutodetection = true;
    private boolean redirectErrorStream = true;
    private File workDir = null;
    private boolean warnUser = true;
    private List<String> additionalParameters = Collections.emptyList();
    private Map<String, String> environmentVariables = Collections.emptyMap();
    private PhpExecutableValidator.ValidationHandler validationHandler = null;
    private File fileOutput = null;
    private boolean fileOutputOnly = false;
    private boolean noInfo = false;

    public PhpExecutable(String command) {
        Pair<String, List<String>> parsedCommand = PhpExecutable.parseCommand(command);
        this.executable = (String)parsedCommand.first;
        this.parameters = (List)parsedCommand.second;
        this.command = command.trim();
    }

    static Pair<String, List<String>> parseCommand(String command) {
        String[] tokens;
        if (command == null) {
            command = "";
        }
        if ((tokens = command.split(" * (?=\\-|/)", 2)).length == 1) {
            LOGGER.log(Level.FINE, "Only program given (no parameters): {0}", command);
            return Pair.of((Object)tokens[0].trim(), Collections.emptyList());
        }
        Pair parsedCommand = Pair.of((Object)tokens[0].trim(), Arrays.asList(Utilities.parseParameters((String)tokens[1].trim())));
        LOGGER.log(Level.FINE, "Parameters parsed: {0} {1}", new Object[]{parsedCommand.first, parsedCommand.second});
        return parsedCommand;
    }

    public String getExecutable() {
        return this.executable;
    }

    public List<String> getParameters() {
        return new ArrayList<String>(this.parameters);
    }

    public String getCommand() {
        return this.command;
    }

    public PhpExecutable executableName(@NonNull String executableName) {
        Parameters.notEmpty((CharSequence)"executableName", (CharSequence)executableName);
        this.executableName = executableName;
        return this;
    }

    public PhpExecutable displayName(String displayName) {
        Parameters.notEmpty((CharSequence)"displayName", (CharSequence)displayName);
        this.displayName = displayName;
        return this;
    }

    public PhpExecutable optionsSubcategory(String optionsSubcategory) {
        Parameters.notEmpty((CharSequence)"optionsSubcategory", (CharSequence)optionsSubcategory);
        this.optionsSubcategory = optionsSubcategory;
        return this;
    }

    public PhpExecutable viaPhpInterpreter(boolean viaPhpInterpreter) {
        this.viaPhpInterpreter = viaPhpInterpreter;
        return this;
    }

    public PhpExecutable viaAutodetection(boolean viaAutodetection) {
        this.viaAutodetection = viaAutodetection;
        return this;
    }

    public PhpExecutable redirectErrorStream(boolean redirectErrorStream) {
        this.redirectErrorStream = redirectErrorStream;
        return this;
    }

    public PhpExecutable workDir(@NonNull File workDir) {
        Parameters.notNull((CharSequence)"workDir", (Object)workDir);
        this.workDir = workDir;
        return this;
    }

    public PhpExecutable warnUser(boolean warnUser) {
        this.warnUser = warnUser;
        return this;
    }

    public PhpExecutable additionalParameters(@NonNull List<String> additionalParameters) {
        Parameters.notNull((CharSequence)"additionalParameters", additionalParameters);
        this.additionalParameters = additionalParameters;
        return this;
    }

    public PhpExecutable environmentVariables(Map<String, String> environmentVariables) {
        Parameters.notNull((CharSequence)"environmentVariables", environmentVariables);
        this.environmentVariables = environmentVariables;
        return this;
    }

    public PhpExecutable validationHandler(@NonNull PhpExecutableValidator.ValidationHandler validationHandler) {
        Parameters.notNull((CharSequence)"validationHandler", (Object)validationHandler);
        this.validationHandler = validationHandler;
        return this;
    }

    public PhpExecutable fileOutput(@NonNull File fileOutput, boolean fileOutputOnly) {
        Parameters.notNull((CharSequence)"fileOutput", (Object)fileOutput);
        this.fileOutput = fileOutput;
        this.fileOutputOnly = fileOutputOnly;
        return this;
    }

    public PhpExecutable noInfo(boolean noInfo) {
        this.noInfo = noInfo;
        return this;
    }

    @CheckForNull
    public Future<Integer> run() {
        return this.run(DEFAULT_EXECUTION_DESCRIPTOR);
    }

    @CheckForNull
    public Future<Integer> run(@NonNull ExecutionDescriptor executionDescriptor) {
        return this.run(executionDescriptor, null);
    }

    @CheckForNull
    public Future<Integer> run(@NonNull ExecutionDescriptor executionDescriptor, @NullAllowed ExecutionDescriptor.InputProcessorFactory outProcessorFactory) {
        Parameters.notNull((CharSequence)"executionDescriptor", (Object)executionDescriptor);
        String error = this.validationHandler == null ? PhpExecutableValidator.validateCommand(this.executable, this.executableName) : PhpExecutableValidator.validateCommand(this.executable, this.validationHandler);
        if (error != null) {
            if (this.warnUser) {
                UiUtils.invalidScriptProvided((String)error, (String)this.optionsSubcategory);
            }
            return null;
        }
        ExternalProcessBuilder processBuilder = this.getProcessBuilder();
        if (processBuilder == null) {
            return null;
        }
        executionDescriptor = this.getExecutionDescriptor(executionDescriptor, outProcessorFactory);
        return ExecutionService.newService((Callable)processBuilder, (ExecutionDescriptor)executionDescriptor, (String)this.getDisplayName()).run();
    }

    @CheckForNull
    public Integer runAndWait(@NonNull String progressMessage) throws ExecutionException {
        return this.runAndWait(DEFAULT_EXECUTION_DESCRIPTOR, progressMessage);
    }

    @CheckForNull
    public Integer runAndWait(@NonNull ExecutionDescriptor executionDescriptor, @NonNull String progressMessage) throws ExecutionException {
        return this.runAndWait(executionDescriptor, null, progressMessage);
    }

    @CheckForNull
    public Integer runAndWait(@NonNull ExecutionDescriptor executionDescriptor, @NullAllowed ExecutionDescriptor.InputProcessorFactory outProcessorFactory, @NonNull String progressMessage) throws ExecutionException {
        Parameters.notNull((CharSequence)"progressMessage", (Object)progressMessage);
        final Future<Integer> result = this.run(executionDescriptor);
        if (result == null) {
            return null;
        }
        final AtomicReference executionException = new AtomicReference();
        if (SwingUtilities.isEventDispatchThread() && !result.isDone()) {
            try {
                PhpExecutable.getResult(result, 90L);
            }
            catch (TimeoutException ex) {
                ProgressUtils.showProgressDialogAndRun((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PhpExecutable.getResult(result);
                        }
                        catch (ExecutionException extEx) {
                            executionException.set(extEx);
                        }
                    }
                }, (String)progressMessage);
            }
        }
        if (executionException.get() != null) {
            throw (ExecutionException)executionException.get();
        }
        return PhpExecutable.getResult(result);
    }

    @CheckForNull
    private ExternalProcessBuilder getProcessBuilder() {
        ExternalProcessBuilder processBuilder = this.createProcessBuilder();
        if (processBuilder == null) {
            return null;
        }
        for (String string : this.parameters) {
            this.fullCommand.add(string);
            processBuilder = processBuilder.addArgument(string);
        }
        for (String string : this.additionalParameters) {
            this.fullCommand.add(string);
            processBuilder = processBuilder.addArgument(string);
        }
        if (this.workDir != null) {
            processBuilder = processBuilder.workingDirectory(this.workDir);
        }
        for (Map.Entry entry : this.environmentVariables.entrySet()) {
            processBuilder = processBuilder.addEnvironmentVariable((String)entry.getKey(), (String)entry.getValue());
        }
        processBuilder = processBuilder.redirectErrorStream(this.redirectErrorStream);
        return processBuilder;
    }

    private ExternalProcessBuilder createProcessBuilder() {
        PhpInterpreter phpInterpreter;
        this.fullCommand.clear();
        boolean useInterpreter = this.viaPhpInterpreter;
        if (this.viaAutodetection) {
            boolean bl = useInterpreter = !this.executable.toLowerCase().endsWith(".bat");
        }
        if (!useInterpreter) {
            this.fullCommand.add(this.executable);
            return new ExternalProcessBuilder(this.executable);
        }
        try {
            phpInterpreter = PhpInterpreter.getDefault();
        }
        catch (InvalidPhpExecutableException ex) {
            if (this.warnUser) {
                UiUtils.invalidScriptProvided((String)ex.getLocalizedMessage());
            }
            return null;
        }
        this.fullCommand.add(phpInterpreter.getInterpreter());
        ExternalProcessBuilder processBuilder = new ExternalProcessBuilder(phpInterpreter.getInterpreter());
        for (String param : phpInterpreter.getParameters()) {
            this.fullCommand.add(param);
            processBuilder = processBuilder.addArgument(param);
        }
        this.fullCommand.add(this.executable);
        processBuilder = processBuilder.addArgument(this.executable);
        return processBuilder;
    }

    private String getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        return this.getDefaultDisplayName();
    }

    private String getDefaultDisplayName() {
        StringBuilder buffer = new StringBuilder(200);
        buffer.append(this.executable);
        for (String param : this.parameters) {
            buffer.append(" ");
            buffer.append(param);
        }
        return buffer.toString();
    }

    static Integer getResult(Future<Integer> result) throws ExecutionException {
        try {
            return PhpExecutable.getResult(result, null);
        }
        catch (TimeoutException ex) {
            LOGGER.log(Level.WARNING, null, ex);
            return null;
        }
    }

    private static Integer getResult(Future<Integer> result, Long timeout) throws TimeoutException, ExecutionException {
        try {
            if (timeout != null) {
                return result.get(timeout, TimeUnit.MILLISECONDS);
            }
            return result.get();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    private ExecutionDescriptor getExecutionDescriptor(ExecutionDescriptor executionDescriptor, ExecutionDescriptor.InputProcessorFactory outProcessorFactory) {
        ExecutionDescriptor.InputProcessorFactory fileOutProcessorFactory;
        final CopyOnWriteArrayList<ExecutionDescriptor.InputProcessorFactory> inputProcessors = new CopyOnWriteArrayList<ExecutionDescriptor.InputProcessorFactory>();
        ExecutionDescriptor.InputProcessorFactory infoOutProcessorFactory = this.getInfoOutputProcessorFactory();
        if (infoOutProcessorFactory != null) {
            inputProcessors.add(infoOutProcessorFactory);
        }
        if ((fileOutProcessorFactory = this.getFileOutputProcessorFactory()) != null) {
            inputProcessors.add(fileOutProcessorFactory);
            if (this.fileOutputOnly) {
                executionDescriptor = executionDescriptor.inputOutput(InputOutput.NULL).frontWindow(false).frontWindowOnError(false);
            }
        }
        if (outProcessorFactory != null) {
            inputProcessors.add(outProcessorFactory);
        }
        if (!inputProcessors.isEmpty()) {
            executionDescriptor = executionDescriptor.outProcessorFactory(new ExecutionDescriptor.InputProcessorFactory(){

                public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                    InputProcessor[] processors = new InputProcessor[inputProcessors.size()];
                    for (int i = 0; i < inputProcessors.size(); ++i) {
                        processors[i] = ((ExecutionDescriptor.InputProcessorFactory)inputProcessors.get(i)).newInputProcessor(defaultProcessor);
                    }
                    return InputProcessors.proxy((InputProcessor[])processors);
                }
            });
        }
        return executionDescriptor;
    }

    private ExecutionDescriptor.InputProcessorFactory getInfoOutputProcessorFactory() {
        if (this.noInfo) {
            return null;
        }
        return new ExecutionDescriptor.InputProcessorFactory(){

            public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                return InputProcessors.proxy((InputProcessor[])new InputProcessor[]{new InfoInputProcessor(defaultProcessor, PhpExecutable.this.fullCommand), defaultProcessor});
            }
        };
    }

    private ExecutionDescriptor.InputProcessorFactory getFileOutputProcessorFactory() {
        if (this.fileOutput == null) {
            return null;
        }
        return new ExecutionDescriptor.InputProcessorFactory(){

            public InputProcessor newInputProcessor(InputProcessor defaultProcessor) {
                return new RedirectOutputProcessor(PhpExecutable.this.fileOutput);
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append(this.getClass().getName());
        sb.append(" [executable: ");
        sb.append(this.executable);
        sb.append(", parameters: ");
        sb.append(this.parameters);
        sb.append("]");
        return sb.toString();
    }

    static final class RedirectOutputProcessor
    implements InputProcessor {
        private final File fileOuput;
        private OutputStream outputStream;

        public RedirectOutputProcessor(File fileOuput) {
            this.fileOuput = fileOuput;
        }

        public void processInput(char[] chars) throws IOException {
            if (this.outputStream == null) {
                this.outputStream = new BufferedOutputStream(new FileOutputStream(this.fileOuput));
            }
            for (char c : chars) {
                this.outputStream.write((byte)c);
            }
        }

        public void reset() {
        }

        public void close() throws IOException {
            this.outputStream.close();
        }
    }

    private static final class InfoInputProcessor
    implements InputProcessor {
        private final InputProcessor defaultProcessor;
        private char lastChar;

        public InfoInputProcessor(InputProcessor defaultProcessor, List<String> fullCommand) {
            this.defaultProcessor = defaultProcessor;
            try {
                defaultProcessor.processInput(this.getFullCommand(fullCommand).toCharArray());
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
        }

        public void processInput(char[] chars) throws IOException {
            if (chars.length > 0) {
                this.lastChar = chars[chars.length - 1];
            }
        }

        public void reset() throws IOException {
        }

        public void close() throws IOException {
            StringBuilder msg = new StringBuilder(Bundle.InfoInputProcessor_done().length() + 2);
            if (!this.isNewLine(this.lastChar)) {
                msg.append("\n");
            }
            msg.append(this.colorize(Bundle.InfoInputProcessor_done()));
            msg.append("\n");
            this.defaultProcessor.processInput(msg.toString().toCharArray());
        }

        private String getFullCommand(List<String> fullCommand) {
            return this.colorize(StringUtils.implode(fullCommand, (String)" ")) + "\n";
        }

        private String colorize(String msg) {
            return "\u001b[1;30m" + msg + "\u001b[0m";
        }

        private boolean isNewLine(char ch) {
            return ch == '\n' || ch == '\r' || ch == '\u0000';
        }
    }
}

