/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.browser.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URL;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.modules.web.browser.api.WebBrowsers;
import org.netbeans.modules.web.browser.ui.DeveloperToolbar;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.UndoRedo;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class HtmlPreviewElement
implements MultiViewElement {
    private final JPanel panel = new JPanel(new BorderLayout());
    private final DeveloperToolbar toolbar = DeveloperToolbar.create();
    private HtmlBrowser.Impl browser = null;
    private URL url;

    public HtmlPreviewElement(Lookup lkp) {
        FileObject fileObject = (FileObject)lkp.lookup(FileObject.class);
        if (fileObject != null) {
            this.url = fileObject.toURL();
        }
    }

    public JComponent getVisualRepresentation() {
        return this.panel;
    }

    public JComponent getToolbarRepresentation() {
        return (JComponent)this.toolbar.getComponent();
    }

    public void setMultiViewCallback(MultiViewElementCallback callback) {
    }

    public CloseOperationState canCloseElement() {
        return CloseOperationState.STATE_OK;
    }

    public Action[] getActions() {
        return null;
    }

    public Lookup getLookup() {
        return Lookup.EMPTY;
    }

    public void componentOpened() {
        if (null != this.browser) {
            return;
        }
        WebBrowser web = WebBrowsers.getInstance().getPreferred();
        if (null != web && !web.isEmbedded()) {
            for (WebBrowser wb : WebBrowsers.getInstance().getAll(true)) {
                if (!wb.isEmbedded()) continue;
                web = wb;
                break;
            }
        }
        this.panel.removeAll();
        if (null == web || !web.isEmbedded()) {
            this.panel.add((Component)new JLabel("No embedded browser available"), "Center");
        } else {
            this.browser = web.getHtmlBrowserFactory().createHtmlBrowserImpl();
            this.toolbar.intialize(this.browser.getLookup());
            if (null != this.url) {
                this.browser.setURL(this.url);
            }
            this.panel.add(this.browser.getComponent(), "Center");
        }
    }

    public void componentClosed() {
        this.panel.removeAll();
        this.browser = null;
    }

    public void componentShowing() {
    }

    public void componentHidden() {
    }

    public void componentActivated() {
        if (null != this.browser) {
            this.browser.reloadDocument();
        }
    }

    public void componentDeactivated() {
    }

    public UndoRedo getUndoRedo() {
        return UndoRedo.NONE;
    }
}

