/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.browser.api;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import org.netbeans.core.IDESettings;
import org.netbeans.modules.web.browser.api.BrowserFamilyId;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.modules.web.browser.api.WebBrowserFactoryDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public final class WebBrowsers {
    public static final String PROP_BROWSERS = "browsers";
    public static final String PROP_DEFAULT_BROWSER = "browser";
    private static final WebBrowsers INST = new WebBrowsers();
    private static final String BROWSERS_FOLDER = "Services/Browsers";
    private PropertyChangeSupport sup = new PropertyChangeSupport(this);
    private PropertyChangeListener l;
    private FileChangeListener lis;
    private PreferenceChangeListener lis2;

    private WebBrowsers() {
        FileObject servicesBrowsers = this.getConfigFolder();
        if (servicesBrowsers != null) {
            this.lis = new FileChangeListener(){

                public void fileFolderCreated(FileEvent fe) {
                }

                public void fileDataCreated(FileEvent fe) {
                    WebBrowsers.this.fireBrowsersChange();
                }

                public void fileChanged(FileEvent fe) {
                    WebBrowsers.this.fireBrowsersChange();
                }

                public void fileDeleted(FileEvent fe) {
                    WebBrowsers.this.fireBrowsersChange();
                }

                public void fileRenamed(FileRenameEvent fe) {
                    WebBrowsers.this.fireBrowsersChange();
                }

                public void fileAttributeChanged(FileAttributeEvent fe) {
                    WebBrowsers.this.fireBrowsersChange();
                }
            };
            servicesBrowsers.addRecursiveListener(this.lis);
        }
        this.lis2 = new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                if ("WWWBrowser".equals(evt.getKey())) {
                    WebBrowsers.this.fireDefaultBrowserChange();
                }
            }
        };
        NbPreferences.forModule(IDESettings.class).addPreferenceChangeListener(this.lis2);
    }

    public static WebBrowsers getInstance() {
        return INST;
    }

    public WebBrowser getPreferred() {
        for (WebBrowserFactoryDescriptor desc : this.getFactories(true)) {
            if (!desc.isDefault()) continue;
            return new WebBrowser(desc);
        }
        assert (false) : "no default browser instance found: " + this.getFactories(true);
        return null;
    }

    public WebBrowser getEmbedded() {
        for (WebBrowserFactoryDescriptor desc : this.getFactories(true)) {
            if (desc.getBrowserFamily() != BrowserFamilyId.JAVAFX_WEBVIEW) continue;
            return new WebBrowser(desc);
        }
        return null;
    }

    public List<WebBrowser> getAll(boolean includeSystemDefaultBrowser) {
        ArrayList<WebBrowser> browsers = new ArrayList<WebBrowser>();
        for (WebBrowserFactoryDescriptor desc : this.getFactories(includeSystemDefaultBrowser)) {
            browsers.add(new WebBrowser(desc));
        }
        return browsers;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.sup.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.sup.removePropertyChangeListener(l);
    }

    private void fireBrowsersChange() {
        this.sup.firePropertyChange(PROP_BROWSERS, null, null);
    }

    private void fireDefaultBrowserChange() {
        this.sup.firePropertyChange(PROP_DEFAULT_BROWSER, null, null);
    }

    private FileObject getConfigFolder() {
        return FileUtil.getConfigFile((String)BROWSERS_FOLDER);
    }

    private List<WebBrowserFactoryDescriptor> getFactories(boolean includeSystemDefaultBrowser) {
        ArrayList<WebBrowserFactoryDescriptor> browsers = new ArrayList<WebBrowserFactoryDescriptor>();
        FileObject servicesBrowsers = this.getConfigFolder();
        if (servicesBrowsers == null) {
            return browsers;
        }
        DataFolder folder = DataFolder.findFolder((FileObject)servicesBrowsers);
        Lookup.getDefault().lookupAll(HtmlBrowser.Factory.class).toArray();
        for (DataObject browserSetting : folder.getChildren()) {
            HtmlBrowser.Factory fact;
            if (Boolean.TRUE.equals(browserSetting.getPrimaryFile().getAttribute("hidden")) || !includeSystemDefaultBrowser && browserSetting.getPrimaryFile().getName().startsWith("SystemDefaultBrowser")) continue;
            InstanceCookie cookie = (InstanceCookie)browserSetting.getCookie(InstanceCookie.class);
            try {
                fact = (HtmlBrowser.Factory)cookie.instanceCreate();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                continue;
            }
            catch (ClassNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                continue;
            }
            Lookup.Item item = Lookup.getDefault().lookupItem(new Lookup.Template(HtmlBrowser.Factory.class, null, (Object)fact));
            if (item == null) continue;
            boolean isDefault = IDESettings.getWWWBrowser() == null ? false : IDESettings.getWWWBrowser().equals(fact);
            browsers.add(new WebBrowserFactoryDescriptor(item.getId(), browserSetting, isDefault, fact));
        }
        return browsers;
    }
}

