/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.browser.api;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.SwingUtilities;
import org.netbeans.core.HtmlBrowserComponent;
import org.netbeans.modules.web.browser.api.BrowserFamilyId;
import org.netbeans.modules.web.browser.api.WebBrowserFactoryDescriptor;
import org.netbeans.modules.web.browser.spi.EnhancedBrowser;
import org.netbeans.modules.web.browser.ui.DeveloperHtmlBrowserComponent;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Lookup;

public final class WebBrowserPane {
    private HtmlBrowser.Impl impl;
    private WebBrowserFactoryDescriptor descriptor;
    private final List<WebBrowserPaneListener> listeners = new CopyOnWriteArrayList<WebBrowserPaneListener>();
    private PropertyChangeListener listener;
    private HtmlBrowserComponent topComponent;
    private boolean wrapEmbeddedBrowserInTopComponent;
    private boolean createTopComponent = false;
    private Lookup lastProjectContext = null;

    WebBrowserPane(WebBrowserFactoryDescriptor desc, boolean wrapEmbeddedBrowserInTopComponent, boolean disableNetBeansIntegration) {
        this(desc, wrapEmbeddedBrowserInTopComponent, null, disableNetBeansIntegration);
    }

    private WebBrowserPane(WebBrowserFactoryDescriptor descriptor, boolean wrapEmbeddedBrowserInTopComponent, HtmlBrowserComponent comp, boolean disableNetBeansIntegration) {
        this.descriptor = descriptor;
        this.wrapEmbeddedBrowserInTopComponent = wrapEmbeddedBrowserInTopComponent;
        this.listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("browser.was.closed".equals(evt.getPropertyName())) {
                    WebBrowserPane.this.firePaneClosed();
                }
                if ("url".equals(evt.getPropertyName())) {
                    WebBrowserPane.this.fireUrlChange();
                }
            }
        };
        if (comp != null) {
            this.topComponent = comp;
        } else if (this.isEmbedded() && wrapEmbeddedBrowserInTopComponent) {
            this.createTopComponent = true;
        } else {
            this.impl = descriptor.getFactory().createHtmlBrowserImpl();
            if (this.impl instanceof EnhancedBrowser && !disableNetBeansIntegration && descriptor.getBrowserFamily().hasNetBeansAdvancedIntegration()) {
                ((EnhancedBrowser)this.impl).setEnhancedMode(true);
            }
            this.impl.addPropertyChangeListener(this.listener);
        }
    }

    public void disablePageInspector() {
        assert (this.impl instanceof EnhancedBrowser);
        if (this.impl instanceof EnhancedBrowser) {
            ((EnhancedBrowser)this.impl).disablePageInspector();
        }
    }

    public void enableLiveHTML() {
        assert (this.impl instanceof EnhancedBrowser);
        if (this.impl instanceof EnhancedBrowser) {
            ((EnhancedBrowser)this.impl).enableLiveHTML();
        }
    }

    public void close(boolean closeTab) {
        if (this.impl != null) {
            assert (this.impl instanceof EnhancedBrowser);
            if (this.impl instanceof EnhancedBrowser) {
                ((EnhancedBrowser)this.impl).close(closeTab);
            }
        }
    }

    private synchronized HtmlBrowserComponent getTopComponent() {
        if (this.topComponent == null && this.createTopComponent) {
            this.topComponent = new DeveloperHtmlBrowserComponent(this.descriptor.getFactory());
            this.topComponent.putClientProperty((Object)"web.browser.pane", (Object)this);
        }
        return this.topComponent;
    }

    public boolean isEmbedded() {
        return this.descriptor.getBrowserFamily() == BrowserFamilyId.JAVAFX_WEBVIEW;
    }

    public Component getBrowserComponent() {
        if (this.isEmbedded() && !this.wrapEmbeddedBrowserInTopComponent) {
            return this.impl.getComponent();
        }
        return null;
    }

    public void showURL(final URL u) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                HtmlBrowserComponent comp = WebBrowserPane.this.getTopComponent();
                if (comp != null) {
                    comp.setURLAndOpen(u);
                    WebBrowserPane.this.impl = WebBrowserPane.this.topComponent.getBrowserImpl();
                    if (WebBrowserPane.this.impl instanceof EnhancedBrowser) {
                        ((EnhancedBrowser)WebBrowserPane.this.impl).setProjectContext(WebBrowserPane.this.lastProjectContext);
                    }
                    if (WebBrowserPane.this.impl != null) {
                        WebBrowserPane.this.impl.addPropertyChangeListener(WebBrowserPane.this.listener);
                    }
                } else {
                    WebBrowserPane.this.impl.setURL(u);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public void setProjectContext(Lookup projectContext) {
        this.lastProjectContext = projectContext;
        if (this.impl != null && this.impl instanceof EnhancedBrowser) {
            ((EnhancedBrowser)this.impl).setProjectContext(projectContext);
        }
    }

    public void reload() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (WebBrowserPane.this.impl != null) {
                    WebBrowserPane.this.impl.reloadDocument();
                } else {
                    HtmlBrowserComponent comp = WebBrowserPane.this.getTopComponent();
                    if (comp != null) {
                        WebBrowserPane.this.impl = comp.getBrowserImpl();
                        if (WebBrowserPane.this.impl == null) {
                            comp.setURLAndOpen(comp.getDocumentURL());
                        } else {
                            WebBrowserPane.this.impl.reloadDocument();
                        }
                    }
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public Lookup getLookup() {
        if (this.impl == null) {
            return Lookup.EMPTY;
        }
        return this.impl.getLookup();
    }

    public void addListener(WebBrowserPaneListener l) {
        this.listeners.add(l);
    }

    public void removeListener(WebBrowserPaneListener l) {
        this.listeners.remove(l);
    }

    private void firePaneClosed() {
        for (WebBrowserPaneListener listener : this.listeners) {
            listener.browserEvent(new WebBrowserPaneWasClosedEvent(this));
        }
    }

    private void fireUrlChange() {
        for (WebBrowserPaneListener listener : this.listeners) {
            listener.browserEvent(new WebBrowserPaneURLChangedEvent(this));
        }
    }

    public static final class WebBrowserPaneURLChangedEvent
    extends WebBrowserPaneEvent {
        private WebBrowserPaneURLChangedEvent(WebBrowserPane pane) {
            super(pane);
        }
    }

    public static final class WebBrowserPaneWasClosedEvent
    extends WebBrowserPaneEvent {
        private WebBrowserPaneWasClosedEvent(WebBrowserPane pane) {
            super(pane);
        }
    }

    public static abstract class WebBrowserPaneEvent {
        private WebBrowserPane pane;

        private WebBrowserPaneEvent(WebBrowserPane pane) {
            this.pane = pane;
        }

        public WebBrowserPane getWebBrowserPane() {
            return this.pane;
        }
    }

    public static interface WebBrowserPaneListener {
        public void browserEvent(WebBrowserPaneEvent var1);
    }
}

