/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.webkit.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.inspect.CSSUtils;
import org.netbeans.modules.web.inspect.actions.OpenResourceAction;
import org.netbeans.modules.web.inspect.actions.Resource;
import org.netbeans.modules.web.inspect.webkit.Utilities;
import org.netbeans.modules.web.inspect.webkit.ui.Filter;
import org.netbeans.modules.web.inspect.webkit.ui.RuleNode;
import org.netbeans.modules.web.webkit.debugging.api.css.CSS;
import org.netbeans.modules.web.webkit.debugging.api.css.Rule;
import org.netbeans.modules.web.webkit.debugging.api.css.StyleSheetBody;
import org.netbeans.modules.web.webkit.debugging.api.css.StyleSheetHeader;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class StyleSheetNode
extends AbstractNode {
    static final String ICON_BASE = "org/netbeans/modules/web/inspect/resources/matchedRules.png";
    private StyleSheetHeader header;
    private Project project;

    StyleSheetNode(Project project, CSS css, StyleSheetHeader header, Filter filter) {
        super(Children.create((ChildFactory)new StyleSheetChildFactory(project, css, header, filter), (boolean)true), Lookups.fixed((Object[])new Object[]{new Resource(project, header.getSourceURL())}));
        this.project = project;
        this.header = header;
        this.updateDisplayName();
        this.setIconBaseWithExtension(ICON_BASE);
    }

    private void updateDisplayName() {
        String sourceURL = this.header.getSourceURL();
        String displayName = Utilities.relativeResourceName(sourceURL, this.project);
        String title = this.header.getTitle();
        if (title != null && !title.trim().isEmpty()) {
            displayName = title + " (" + displayName + ")";
        }
        this.setDisplayName(displayName);
    }

    public Action getPreferredAction() {
        return SystemAction.get(OpenResourceAction.class);
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(OpenResourceAction.class)};
    }

    static class StyleSheetChildFactory
    extends ChildFactory<Rule> {
        private Project project;
        private CSS css;
        private StyleSheetHeader header;
        private StyleSheetBody body;
        private Filter filter;

        StyleSheetChildFactory(Project project, CSS css, StyleSheetHeader header, Filter filter) {
            this.project = project;
            this.css = css;
            this.header = header;
            this.filter = filter;
            filter.addPropertyChangeListener(this.createListener());
        }

        private PropertyChangeListener createListener() {
            return new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String propertyName = evt.getPropertyName();
                    if ("pattern".equals(propertyName)) {
                        StyleSheetChildFactory.this.refresh(false);
                    }
                }
            };
        }

        protected boolean createKeys(List<Rule> toPopulate) {
            String styleSheetId = this.header.getStyleSheetId();
            if (this.body == null) {
                this.body = this.css.getStyleSheet(styleSheetId);
            }
            if (this.body == null) {
                Logger.getLogger(StyleSheetNode.class.getName()).log(Level.INFO, "Null body obtained for style sheet {0}!", styleSheetId);
            } else {
                for (Rule rule : this.body.getRules()) {
                    if (!this.includeKey(rule)) continue;
                    toPopulate.add(rule);
                }
            }
            return true;
        }

        private boolean includeKey(Rule rule) {
            boolean include = true;
            String pattern = this.filter.getPattern();
            if (pattern != null) {
                pattern = CSSUtils.normalizeSelector(pattern);
                String selector = CSSUtils.normalizeSelector(rule.getSelector());
                include = selector.indexOf(pattern) != -1;
            }
            return include;
        }

        protected Node createNodeForKey(Rule key) {
            return new RuleNode(key, new Resource(this.project, this.header.getSourceURL()));
        }
    }
}

