/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.webkit.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.inspect.CSSUtils;
import org.netbeans.modules.web.inspect.actions.Resource;
import org.netbeans.modules.web.inspect.webkit.Utilities;
import org.netbeans.modules.web.inspect.webkit.ui.MatchedRuleNode;
import org.netbeans.modules.web.inspect.webkit.ui.RuleInfo;
import org.netbeans.modules.web.webkit.debugging.api.css.InheritedStyleEntry;
import org.netbeans.modules.web.webkit.debugging.api.css.MatchedStyles;
import org.netbeans.modules.web.webkit.debugging.api.css.Property;
import org.netbeans.modules.web.webkit.debugging.api.css.Rule;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class MatchedRulesNode
extends AbstractNode {
    private Project project;
    private Node node;
    private MatchedStyles matchedStyles;

    MatchedRulesNode(Project project, Node node, MatchedStyles matchedStyles) {
        super((Children)new Children.Array());
        this.project = project;
        this.node = node;
        this.matchedStyles = matchedStyles;
        if (matchedStyles != null) {
            this.initChildren();
        }
        this.setDisplayName(NbBundle.getMessage(MatchedRulesNode.class, (String)"MatchedRulesNode.displayName"));
    }

    private void initChildren() {
        Children.Array children = (Children.Array)this.getChildren();
        ArrayList<String> properties = new ArrayList<String>();
        ArrayList<MatchedRuleNode> nodes = new ArrayList<MatchedRuleNode>();
        for (Rule rule : this.matchedStyles.getMatchedRules()) {
            if (!Utilities.showInCSSStyles(rule)) continue;
            nodes.add(this.createMatchedRuleNode(this.node, rule, properties, true));
        }
        Node currentNode = this.node;
        for (InheritedStyleEntry entry : this.matchedStyles.getInheritedRules()) {
            currentNode = currentNode.getParentNode();
            for (Rule rule : entry.getMatchedRules()) {
                if (!Utilities.showInCSSStyles(rule) || !this.containsInheritedProperties(rule)) continue;
                nodes.add(this.createMatchedRuleNode(currentNode, rule, properties, false));
            }
        }
        children.add((Node[])nodes.toArray(new MatchedRuleNode[nodes.size()]));
    }

    private boolean containsInheritedProperties(Rule rule) {
        for (Property property : rule.getStyle().getProperties()) {
            String propertyName = property.getName();
            if (!CSSUtils.isInheritedProperty(propertyName)) continue;
            return true;
        }
        return false;
    }

    private MatchedRuleNode createMatchedRuleNode(Node node, Rule rule, List<String> properties, boolean matched) {
        RuleInfo ruleInfo = new RuleInfo();
        List ruleProperties = rule.getStyle().getProperties();
        ArrayList<String> active = new ArrayList<String>();
        for (int i = ruleProperties.size() - 1; i >= 0; --i) {
            Property property = (Property)ruleProperties.get(i);
            String name = property.getName();
            if (!property.isParsedOk() || !matched && !CSSUtils.isInheritedProperty(name)) continue;
            if (!properties.contains(name)) {
                properties.add(name);
                active.add(name);
                continue;
            }
            if (active.contains(name)) continue;
            ruleInfo.markAsOverriden(name);
        }
        ruleInfo.setInherited(!matched);
        if (rule.getId() == null) {
            Logger.getLogger(MatchedRuleNode.class.getName()).log(Level.INFO, "Matched rule with null ID: {0}", rule);
        }
        return new MatchedRuleNode(node, rule, new Resource(this.project, rule.getSourceURL()), ruleInfo);
    }
}

