/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.webkit.ui;

import java.lang.reflect.InvocationTargetException;
import javax.swing.Action;
import org.netbeans.modules.web.inspect.actions.Resource;
import org.netbeans.modules.web.inspect.webkit.Utilities;
import org.netbeans.modules.web.inspect.webkit.actions.GoToPropertySourceAction;
import org.netbeans.modules.web.webkit.debugging.api.css.Property;
import org.netbeans.modules.web.webkit.debugging.api.css.Rule;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class MatchedPropertyNode
extends AbstractNode {
    public static final String PROPERTY_VALUE = "value";
    private Node.PropertySet[] propertySets;
    Property property;

    MatchedPropertyNode(Rule rule, Resource ruleOrigin, Property property) {
        super(Children.LEAF, Lookups.fixed((Object[])new Object[]{rule, ruleOrigin, property}));
        this.property = property;
        this.setDisplayName(property.getName());
        String stylesheet = Utilities.relativeResourceName(rule.getSourceURL(), ruleOrigin.getProject());
        String description = NbBundle.getMessage(MatchedPropertyNode.class, (String)"MatchedPropertyNode.description", (Object)rule.getSelector(), (Object)stylesheet);
        this.setShortDescription(description);
    }

    void addSubNode(MatchedPropertyNode subNode) {
        if (this.isLeaf()) {
            this.setChildren((Children)new Children.Array());
        }
        Children.Array children = (Children.Array)this.getChildren();
        children.add(new Node[]{subNode});
    }

    public synchronized Node.PropertySet[] getPropertySets() {
        if (this.propertySets == null) {
            this.propertySets = this.createPropertySets();
        }
        return this.propertySets;
    }

    private Node.PropertySet[] createPropertySets() {
        String displayName = NbBundle.getMessage(MatchedPropertyNode.class, (String)"MatchedPropertyNode.displayName");
        Node.PropertySet set = new Node.PropertySet("properties", displayName, null){
            private Node.Property<?> valueProperty;
            {
                this.valueProperty = new PropertySupport.ReadOnly<String>(MatchedPropertyNode.PROPERTY_VALUE, String.class, null, null){

                    public String getValue() throws IllegalAccessException, InvocationTargetException {
                        return MatchedPropertyNode.this.property.getValue();
                    }

                    public String getShortDescription() {
                        return MatchedPropertyNode.this.getShortDescription();
                    }
                };
            }

            public Node.Property<?>[] getProperties() {
                return new Node.Property[]{this.valueProperty};
            }
        };
        return new Node.PropertySet[]{set};
    }

    public Action getPreferredAction() {
        return SystemAction.get(GoToPropertySourceAction.class);
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(GoToPropertySourceAction.class)};
    }
}

