/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.webkit.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.inspect.CSSUtils;
import org.netbeans.modules.web.inspect.actions.Resource;
import org.netbeans.modules.web.inspect.webkit.Utilities;
import org.netbeans.modules.web.inspect.webkit.ui.MatchedPropertyNode;
import org.netbeans.modules.web.webkit.debugging.api.css.InheritedStyleEntry;
import org.netbeans.modules.web.webkit.debugging.api.css.MatchedStyles;
import org.netbeans.modules.web.webkit.debugging.api.css.Property;
import org.netbeans.modules.web.webkit.debugging.api.css.PropertyInfo;
import org.netbeans.modules.web.webkit.debugging.api.css.Rule;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class MatchedPropertiesNode
extends AbstractNode {
    private MatchedStyles matchedStyles;
    private Map<String, PropertyInfo> propertyInfos;
    private Project project;

    MatchedPropertiesNode(Project project, MatchedStyles matchedStyles, Map<String, PropertyInfo> propertyInfos) {
        super((Children)new Children.Array());
        this.project = project;
        this.matchedStyles = matchedStyles;
        this.propertyInfos = propertyInfos;
        this.initChildren();
        this.setDisplayName(NbBundle.getMessage(MatchedPropertiesNode.class, (String)"MatchedPropertiesNode.displayName"));
    }

    private void initChildren() {
        HashSet<String> properties = new HashSet<String>();
        Children.Array children = (Children.Array)this.getChildren();
        ArrayList<MatchedPropertyNode> nodes = new ArrayList<MatchedPropertyNode>();
        for (Rule rule : this.matchedStyles.getMatchedRules()) {
            if (!Utilities.showInCSSStyles(rule)) continue;
            this.addChildrenFor(rule, nodes, properties, true);
        }
        for (InheritedStyleEntry entry : this.matchedStyles.getInheritedRules()) {
            for (Rule rule : entry.getMatchedRules()) {
                if (!Utilities.showInCSSStyles(rule)) continue;
                this.addChildrenFor(rule, nodes, properties, false);
            }
        }
        children.add((Node[])nodes.toArray(new MatchedPropertyNode[nodes.size()]));
    }

    private void addChildrenFor(Rule rule, List<MatchedPropertyNode> toPopulate, Set<String> properties, boolean matchingSelection) {
        List ruleProperties = rule.getStyle().getProperties();
        int index = toPopulate.size();
        HashMap<String, MatchedPropertyNode> parentMap = new HashMap<String, MatchedPropertyNode>();
        HashMap<String, MatchedPropertyNode> childrenMap = new HashMap<String, MatchedPropertyNode>();
        for (int i = ruleProperties.size() - 1; i >= 0; --i) {
            Property property = (Property)ruleProperties.get(i);
            String name = property.getName();
            if (!property.isParsedOk() || properties.contains(name) || !matchingSelection && !CSSUtils.isInheritedProperty(name)) continue;
            properties.add(name);
            if (property.getText() == null) continue;
            MatchedPropertyNode node = new MatchedPropertyNode(rule, new Resource(this.project, rule.getSourceURL()), property);
            parentMap.put(name, node);
            toPopulate.add(node);
        }
        for (Property property : ruleProperties) {
            if (property.getText() != null) continue;
            String shorthandName = property.getShorthandName();
            MatchedPropertyNode child = new MatchedPropertyNode(rule, new Resource(this.project, rule.getSourceURL()), property);
            if (shorthandName == null) {
                childrenMap.put(property.getName(), child);
                continue;
            }
            MatchedPropertyNode parent = (MatchedPropertyNode)((Object)parentMap.get(shorthandName));
            if (parent == null) continue;
            parent.addSubNode(child);
        }
        for (int i = index; i < toPopulate.size(); ++i) {
            PropertyInfo info;
            MatchedPropertyNode parent = toPopulate.get(i);
            String propertyName = parent.property.getName();
            List longhands = Collections.EMPTY_LIST;
            if (this.propertyInfos != null && (info = this.propertyInfos.get(propertyName)) != null) {
                longhands = info.getLonghands();
            }
            for (String longhand : longhands) {
                MatchedPropertyNode child = (MatchedPropertyNode)((Object)childrenMap.remove(longhand));
                if (child == null) continue;
                parent.addSubNode(child);
            }
        }
    }
}

