/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.webkit.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.View;
import javax.swing.tree.TreeCellRenderer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.css.visual.api.EditCSSRulesAction;
import org.netbeans.modules.web.inspect.actions.Resource;
import org.netbeans.modules.web.inspect.webkit.Utilities;
import org.netbeans.modules.web.inspect.webkit.WebKitPageModel;
import org.netbeans.modules.web.inspect.webkit.ui.CustomToolbar;
import org.netbeans.modules.web.inspect.webkit.ui.MatchedPropertiesNode;
import org.netbeans.modules.web.inspect.webkit.ui.MatchedRulesNode;
import org.netbeans.modules.web.webkit.debugging.api.WebKitDebugging;
import org.netbeans.modules.web.webkit.debugging.api.css.CSS;
import org.netbeans.modules.web.webkit.debugging.api.css.MatchedStyles;
import org.netbeans.modules.web.webkit.debugging.api.css.Media;
import org.netbeans.modules.web.webkit.debugging.api.css.Property;
import org.netbeans.modules.web.webkit.debugging.api.css.Rule;
import org.netbeans.modules.web.webkit.debugging.api.css.RuleId;
import org.netbeans.modules.web.webkit.debugging.api.dom.Node;
import org.openide.awt.HtmlRenderer;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.ListView;
import org.openide.explorer.view.TreeTableView;
import org.openide.explorer.view.Visualizer;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CSSStylesSelectionPanel
extends JPanel {
    private static final boolean AQUA = "Aqua".equals(UIManager.getLookAndFeel().getID());
    static final RequestProcessor RP = new RequestProcessor(CSSStylesSelectionPanel.class);
    private Lookup lookup;
    private WebKitPageModel pageModel;
    private org.openide.nodes.Node inspectedNode;
    private Listener listener;
    private TreeTableView propertyPane;
    private ExplorerManager propertyPaneManager;
    private ListView rulePane;
    private ExplorerManager rulePaneManager;
    private JLabel messageLabel;
    private JLabel propertySummaryLabel;
    private JComponent selectionView;
    private static final String PSEUDO_CLASS = "pseudoClass";
    private List<JCheckBox> pseudoClassCheckBoxes = new ArrayList<JCheckBox>(4);

    CSSStylesSelectionPanel() {
        this.setLayout(new BorderLayout());
        JSplitPane splitPane = this.createSplitPane();
        splitPane.setOrientation(0);
        splitPane.setTopComponent(this.initPropertyPane());
        splitPane.setBottomComponent(this.initRulePane());
        splitPane.setDividerSize(4);
        splitPane.setResizeWeight(0.5);
        splitPane.setBorder(null);
        this.selectionView = splitPane;
        this.initMessageLabel();
        this.initSelectionOfOwningRule();
        this.add((Component)this.selectionView, "Center");
        this.updateContent(null, false);
    }

    private JSplitPane createSplitPane() {
        return new JSplitPane(){

            @Override
            public String getUIClassID() {
                if (AQUA && UIManager.get("Nb.SplitPaneUI.clean") != null) {
                    return "Nb.SplitPaneUI.clean";
                }
                return super.getUIClassID();
            }
        };
    }

    private JPanel initPropertyPane() {
        this.propertyPane = new PropertyPaneView();
        String valueTitle = NbBundle.getMessage(CSSStylesSelectionPanel.class, (String)"CSSStylesSelectionPanel.value");
        this.propertyPane.setProperties(new Node.Property[]{new PropertySupport.ReadOnly<String>("value", String.class, valueTitle, null){

            public String getValue() throws IllegalAccessException, InvocationTargetException {
                return null;
            }
        }});
        ExplorerManagerProviderPanel propertyPanePanel = new ExplorerManagerProviderPanel();
        propertyPanePanel.setLayout(new BorderLayout());
        propertyPanePanel.add((Component)this.propertyPane, "Center");
        JPanel headerPanel = new JPanel();
        headerPanel.setLayout(new BorderLayout());
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 0));
        this.propertySummaryLabel = new JLabel();
        this.propertySummaryLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        titlePanel.add(this.propertySummaryLabel);
        titlePanel.add(Box.createHorizontalGlue());
        JToggleButton pseudoClassToggle = new JToggleButton();
        pseudoClassToggle.setFocusPainted(false);
        pseudoClassToggle.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/web/inspect/resources/elementStates.png", (boolean)true));
        pseudoClassToggle.setToolTipText(NbBundle.getMessage(CSSStylesSelectionPanel.class, (String)"CSSStylesSelectionPanel.pseudoClasses"));
        CustomToolbar toolBar = new CustomToolbar();
        toolBar.addButton(pseudoClassToggle);
        titlePanel.add(toolBar);
        headerPanel.add((Component)titlePanel, "First");
        headerPanel.add((Component)this.createPseudoClassPanel(pseudoClassToggle), "Center");
        propertyPanePanel.add((Component)headerPanel, "First");
        this.propertyPaneManager = propertyPanePanel.getExplorerManager();
        propertyPanePanel.setMinimumSize(new Dimension(0, 0));
        return propertyPanePanel;
    }

    private JPanel createPseudoClassPanel(JToggleButton pseudoClassToggle) {
        final JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(2, 2));
        ResourceBundle bundle = NbBundle.getBundle(CSSStylesSelectionPanel.class);
        panel.add(this.createPseudoCheckBox(CSS.PseudoClass.ACTIVE, bundle.getString("CSSStylesSelectionPanel.pseudoClass.active")));
        panel.add(this.createPseudoCheckBox(CSS.PseudoClass.HOVER, bundle.getString("CSSStylesSelectionPanel.pseudoClass.hover")));
        panel.add(this.createPseudoCheckBox(CSS.PseudoClass.FOCUS, bundle.getString("CSSStylesSelectionPanel.pseudoClass.focus")));
        panel.add(this.createPseudoCheckBox(CSS.PseudoClass.VISITED, bundle.getString("CSSStylesSelectionPanel.pseudoClass.visited")));
        panel.setVisible(false);
        pseudoClassToggle.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JToggleButton source = (JToggleButton)e.getSource();
                panel.setVisible(source.isSelected());
            }
        });
        return panel;
    }

    private JCheckBox createPseudoCheckBox(final CSS.PseudoClass pseudoClass, String title) {
        JCheckBox checkbox = new JCheckBox(title);
        checkbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebKitPageModel model = CSSStylesSelectionPanel.this.pageModel;
                org.openide.nodes.Node selectedNode = CSSStylesSelectionPanel.this.inspectedNode;
                if (model != null && selectedNode != null) {
                    Node node = (Node)selectedNode.getLookup().lookup(Node.class);
                    JCheckBox source = (JCheckBox)e.getSource();
                    boolean checked = source.isSelected();
                    if (checked) {
                        model.addPseudoClass(node, pseudoClass);
                    } else {
                        model.removePseudoClass(node, pseudoClass);
                    }
                    CSSStylesSelectionPanel.this.updateMatchedRules(model, selectedNode, true);
                }
            }
        });
        checkbox.putClientProperty(PSEUDO_CLASS, pseudoClass);
        this.pseudoClassCheckBoxes.add(checkbox);
        return checkbox;
    }

    private void updatePseudoClassPanel(WebKitPageModel pageModel, Node node) {
        CSS.PseudoClass[] pseudoClasses = pageModel.getPseudoClasses(node);
        EnumSet<CSS.PseudoClass> set = EnumSet.noneOf(CSS.PseudoClass.class);
        set.addAll(Arrays.asList(pseudoClasses));
        for (JCheckBox checkbox : this.pseudoClassCheckBoxes) {
            CSS.PseudoClass pseudoClass = (CSS.PseudoClass)checkbox.getClientProperty(PSEUDO_CLASS);
            boolean selected = set.contains(pseudoClass);
            checkbox.setSelected(selected);
        }
    }

    private JPanel initRulePane() {
        this.rulePane = new ListView(){
            {
                final StylesRenderer renderer = new StylesRenderer();
                this.list.setCellRenderer(renderer);
                MouseAdapter adapter = new MouseAdapter(){

                    @Override
                    public void mouseMoved(MouseEvent e) {
                        if (this.isLink(e)) {
                            list.setCursor(Cursor.getPredefinedCursor(12));
                        } else {
                            list.setCursor(Cursor.getDefaultCursor());
                        }
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        list.setCursor(Cursor.getDefaultCursor());
                    }

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (this.isLink(e)) {
                            Point p = e.getPoint();
                            int index = list.locationToIndex(p);
                            Object value = list.getModel().getElementAt(index);
                            org.openide.nodes.Node node = Visualizer.findNode(value);
                            node.getPreferredAction().actionPerformed(new ActionEvent(node, 0, null));
                        }
                    }

                    private boolean isLink(MouseEvent event) {
                        Point p = event.getPoint();
                        int index = list.locationToIndex(p);
                        if (index == -1) {
                            return false;
                        }
                        Rectangle cellBounds = list.getCellBounds(index, index);
                        p.translate(-cellBounds.x, -cellBounds.y);
                        Object value = list.getModel().getElementAt(index);
                        renderer.getListCellRendererComponent(list, value, index, false, false);
                        return renderer.isLink(p);
                    }
                };
                this.list.addMouseMotionListener(adapter);
                this.list.addMouseListener(adapter);
            }
        };
        this.rulePane.setHorizontalScrollBarPolicy(31);
        ExplorerManagerProviderPanel rulePanePanel = new ExplorerManagerProviderPanel();
        rulePanePanel.setLayout(new BorderLayout());
        rulePanePanel.add((Component)this.rulePane, "Center");
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new BorderLayout());
        JLabel rulePaneSummaryLabel = new JLabel();
        rulePaneSummaryLabel.setText(NbBundle.getMessage(CSSStylesSelectionPanel.class, (String)"CSSStylesSelectionPanel.rulePaneHeader"));
        rulePaneSummaryLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        northPanel.add((Component)rulePaneSummaryLabel, "Center");
        CustomToolbar toolbar = new CustomToolbar();
        final JToggleButton createRuleToggleButton = new JToggleButton();
        createRuleToggleButton.setAction((Action)EditCSSRulesAction.getDefault());
        Mnemonics.setLocalizedText((AbstractButton)createRuleToggleButton, null);
        createRuleToggleButton.setToolTipText(EditCSSRulesAction.getDefault().getToolTip());
        createRuleToggleButton.setFocusable(false);
        createRuleToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                createRuleToggleButton.setSelected(false);
            }
        });
        toolbar.addButton(createRuleToggleButton);
        northPanel.add((Component)toolbar, "East");
        rulePanePanel.add((Component)northPanel, "North");
        rulePanePanel.setMinimumSize(new Dimension(0, 0));
        this.rulePaneManager = rulePanePanel.getExplorerManager();
        this.lookup = ExplorerUtils.createLookup((ExplorerManager)this.rulePaneManager, (ActionMap)this.getActionMap());
        return rulePanePanel;
    }

    private void initSelectionOfOwningRule() {
        this.propertyPaneManager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Lookup lookup;
                Rule rule;
                org.openide.nodes.Node[] selection;
                String propertyName = evt.getPropertyName();
                if ("selectedNodes".equals(propertyName) && (selection = CSSStylesSelectionPanel.this.propertyPaneManager.getSelectedNodes()).length == 1 && (rule = (Rule)(lookup = selection[0].getLookup()).lookup(Rule.class)) != null) {
                    this.selectRule(rule, CSSStylesSelectionPanel.this.rulePaneManager.getRootContext());
                }
            }

            private boolean selectRule(Rule rule, org.openide.nodes.Node root) {
                RuleId otherId;
                RuleId id = rule.getId();
                Lookup lookup = root.getLookup();
                Rule otherRule = (Rule)lookup.lookup(Rule.class);
                if (otherRule != null && (otherId = otherRule.getId()) != null && otherId.equals((Object)id)) {
                    try {
                        CSSStylesSelectionPanel.this.rulePaneManager.setSelectedNodes(new org.openide.nodes.Node[]{root});
                    }
                    catch (PropertyVetoException ex) {
                        // empty catch block
                    }
                    return true;
                }
                for (org.openide.nodes.Node subNode : root.getChildren().getNodes()) {
                    if (!this.selectRule(rule, subNode)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    private void initMessageLabel() {
        this.messageLabel = new JLabel();
        this.messageLabel.setHorizontalAlignment(0);
        this.messageLabel.setVerticalAlignment(0);
        this.messageLabel.setEnabled(false);
        this.messageLabel.setBackground(new BeanTreeView().getViewport().getView().getBackground());
        this.messageLabel.setOpaque(true);
    }

    final void updateContent(WebKitPageModel pageModel, boolean keepSelection) {
        if (this.pageModel != null) {
            this.pageModel.removePropertyChangeListener(this.getListener());
        }
        this.pageModel = pageModel;
        if (this.pageModel != null) {
            this.pageModel.addPropertyChangeListener(this.getListener());
        }
        this.updateContentImpl(pageModel, keepSelection);
    }

    void updateContentImpl(final WebKitPageModel pageModel, final boolean keepSelection) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CSSStylesSelectionPanel.this.updateContentImpl(pageModel, keepSelection);
                }
            });
            return;
        }
        this.inspectedNode = null;
        if (pageModel == null) {
            this.setDummyRoots();
        } else {
            List<org.openide.nodes.Node> selection = pageModel.getSelectedNodes();
            int selectionSize = 0;
            boolean containsUnkownNode = false;
            org.openide.nodes.Node knownNode = null;
            for (org.openide.nodes.Node node : selection) {
                Object webKitNode = node.getLookup().lookup(Node.class);
                if (webKitNode == null) {
                    containsUnkownNode = true;
                    continue;
                }
                knownNode = node;
                ++selectionSize;
            }
            if (selectionSize == 0) {
                this.setDummyRoots();
                String key = containsUnkownNode ? "CSSStylesSelectionPanel.unknownElementSelected" : "CSSStylesSelectionPanel.noElementSelected";
                this.showLabel(key);
            } else if (selectionSize > 1) {
                this.setDummyRoots();
                this.showLabel("CSSStylesSelectionPanel.multipleElementsSelected");
            } else {
                org.openide.nodes.Node node;
                this.inspectedNode = knownNode;
                org.openide.nodes.Node selectedNode = knownNode;
                node = (Node)selectedNode.getLookup().lookup(Node.class);
                if (node.getNodeType() == 1) {
                    String name = selectedNode.getHtmlDisplayName();
                    if (name.startsWith("<html>")) {
                        name = name.substring(6);
                    }
                    String header = NbBundle.getMessage(CSSStylesSelectionPanel.class, (String)"CSSStylesSelectionPanel.propertySummaryHeader", (Object)name);
                    this.propertySummaryLabel.setText("<html><div>" + header + "</div>");
                    int width = this.propertySummaryLabel.getPreferredSize().width;
                    this.propertySummaryLabel.setText("<html><div width=\"" + width + "\">" + header + "</div>");
                    this.showLabel(null);
                    this.updatePseudoClassPanel(pageModel, (Node)node);
                    this.updateMatchedRules(pageModel, selectedNode, keepSelection);
                } else {
                    this.setDummyRoots();
                    this.showLabel("CSSStylesSelectionPanel.noElementSelected");
                }
            }
        }
        this.revalidate();
        this.repaint();
    }

    void updateMatchedRules(final WebKitPageModel pageModel, final org.openide.nodes.Node selectedNode, final boolean keepSelection) {
        if (EventQueue.isDispatchThread()) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    CSSStylesSelectionPanel.this.updateMatchedRules(pageModel, selectedNode, keepSelection);
                }
            });
            return;
        }
        Node node = (Node)selectedNode.getLookup().lookup(Node.class);
        WebKitDebugging webKit = pageModel.getWebKit();
        CSS css = webKit.getCSS();
        CSS.PseudoClass[] pseudoClasses = pageModel.getPseudoClasses(node);
        css.forcePseudoState(node, pseudoClasses);
        MatchedStyles matchedStyles = css.getMatchedStyles(node, pseudoClasses, true, true);
        Map propertyInfos = css.getSupportedCSSProperties();
        if (matchedStyles != null) {
            org.openide.nodes.Node[] selectedRules = this.rulePaneManager.getSelectedNodes();
            final org.openide.nodes.Node[] selectedProperties = this.propertyPaneManager.getSelectedNodes();
            Project project = pageModel.getProject();
            MatchedRulesNode rulePaneRoot = new MatchedRulesNode(project, selectedNode, matchedStyles);
            this.rulePaneManager.setRootContext((org.openide.nodes.Node)rulePaneRoot);
            MatchedPropertiesNode propertyPaneRoot = new MatchedPropertiesNode(project, matchedStyles, propertyInfos);
            this.propertyPaneManager.setRootContext((org.openide.nodes.Node)propertyPaneRoot);
            if (keepSelection) {
                EventQueue.invokeLater(new Runnable((org.openide.nodes.Node)propertyPaneRoot, selectedRules, (org.openide.nodes.Node)rulePaneRoot){
                    final /* synthetic */ org.openide.nodes.Node val$propertyPaneRoot;
                    final /* synthetic */ org.openide.nodes.Node[] val$selectedRules;
                    final /* synthetic */ org.openide.nodes.Node val$rulePaneRoot;
                    {
                        this.val$propertyPaneRoot = node;
                        this.val$selectedRules = nodeArray2;
                        this.val$rulePaneRoot = node2;
                    }

                    @Override
                    public void run() {
                        org.openide.nodes.Node[] nodes;
                        org.openide.nodes.Node newSelectedRuleNode;
                        org.openide.nodes.Node selectedRuleNode;
                        Rule selectedRule;
                        org.openide.nodes.Node selectedProperty;
                        Property property;
                        if (selectedProperties.length > 0 && (property = (Property)(selectedProperty = selectedProperties[0]).getLookup().lookup(Property.class)) != null) {
                            String propertyName = property.getName();
                            for (org.openide.nodes.Node candidate : this.val$propertyPaneRoot.getChildren().getNodes()) {
                                Property candProperty = (Property)candidate.getLookup().lookup(Property.class);
                                if (candProperty == null || !propertyName.equals(candProperty.getName())) continue;
                                try {
                                    CSSStylesSelectionPanel.this.propertyPaneManager.setSelectedNodes(new org.openide.nodes.Node[]{candidate});
                                }
                                catch (PropertyVetoException pvex) {}
                                break;
                            }
                        }
                        if (this.val$selectedRules.length > 0 && (selectedRule = (Rule)(selectedRuleNode = this.val$selectedRules[0]).getLookup().lookup(Rule.class)) != null && (newSelectedRuleNode = Utilities.findRule(this.val$rulePaneRoot, selectedRule)) != null) {
                            try {
                                CSSStylesSelectionPanel.this.rulePaneManager.setSelectedNodes(new org.openide.nodes.Node[]{newSelectedRuleNode});
                            }
                            catch (PropertyVetoException pvex) {
                                // empty catch block
                            }
                        }
                        if ((nodes = CSSStylesSelectionPanel.this.rulePaneManager.getSelectedNodes()).length == 0) {
                            CSSStylesSelectionPanel.this.preselectRule();
                        }
                    }
                });
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CSSStylesSelectionPanel.this.preselectRule();
                    }
                });
            }
        }
    }

    void preselectRule() {
        org.openide.nodes.Node propertyPaneRoot = this.propertyPaneManager.getRootContext();
        org.openide.nodes.Node[] nodes = propertyPaneRoot.getChildren().getNodes();
        if (nodes.length == 0) {
            org.openide.nodes.Node rulePaneRoot = this.rulePaneManager.getRootContext();
            nodes = rulePaneRoot.getChildren().getNodes();
            if (nodes.length > 0) {
                try {
                    this.rulePaneManager.setSelectedNodes(new org.openide.nodes.Node[]{nodes[0]});
                }
                catch (PropertyVetoException pvex) {}
            }
        } else {
            try {
                this.propertyPaneManager.setSelectedNodes(new org.openide.nodes.Node[]{nodes[0]});
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private void showLabel(String key) {
        if (key == null != (this.selectionView.getParent() != null)) {
            if (key == null) {
                this.remove(this.messageLabel);
                this.add(this.selectionView);
            } else {
                this.remove(this.selectionView);
                this.add(this.messageLabel);
            }
        }
        if (key != null) {
            String message = NbBundle.getMessage(CSSStylesSelectionPanel.class, (String)key);
            this.messageLabel.setText(message);
        }
    }

    private void setDummyRoots() {
        AbstractNode rulePaneRoot = new AbstractNode(Children.LEAF);
        AbstractNode propertyPaneRoot = new AbstractNode(Children.LEAF);
        rulePaneRoot.setDisplayName(NbBundle.getMessage(CSSStylesSelectionPanel.class, (String)"MatchedRulesNode.displayName"));
        propertyPaneRoot.setDisplayName(NbBundle.getMessage(CSSStylesSelectionPanel.class, (String)"MatchedPropertiesNode.displayName"));
        this.rulePaneManager.setRootContext((org.openide.nodes.Node)rulePaneRoot);
        this.propertyPaneManager.setRootContext((org.openide.nodes.Node)propertyPaneRoot);
    }

    Lookup getLookup() {
        return this.lookup;
    }

    private synchronized Listener getListener() {
        if (this.listener == null) {
            this.listener = new Listener();
        }
        return this.listener;
    }

    static class StylesRenderer
    extends DefaultListCellRenderer {
        private JPanel renderer = new JPanel();
        private JLabel matchedNodeLabel = new JLabel();
        private JLabel selectorLabel = new JLabel();
        private JLabel mediaLabel = new JLabel();
        private JLabel ruleLocationLabel = new JLabel();
        private JPanel ruleLocationPanel = new JPanel();
        private ListCellRenderer htmlRenderer = HtmlRenderer.createRenderer();

        StylesRenderer() {
            this.ruleLocationPanel.setOpaque(false);
            this.ruleLocationPanel.setLayout(new BorderLayout());
            this.ruleLocationPanel.add((Component)this.ruleLocationLabel, "Before");
        }

        private void buildLayout() {
            GroupLayout layout = new GroupLayout(this.renderer);
            GroupLayout.Group hGroup = layout.createSequentialGroup().addComponent(this.selectorLabel, 1, 1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup().addComponent(this.matchedNodeLabel, 1, 1, Short.MAX_VALUE).addComponent(this.ruleLocationPanel, 1, 1, Short.MAX_VALUE));
            GroupLayout.SequentialGroup vGroup = layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.selectorLabel).addGroup(layout.createSequentialGroup().addComponent(this.matchedNodeLabel).addComponent(this.ruleLocationPanel, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE);
            hGroup = layout.createParallelGroup().addComponent(this.mediaLabel, 1, 1, Short.MAX_VALUE).addGroup(hGroup);
            vGroup = layout.createSequentialGroup().addComponent(this.mediaLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(vGroup);
            layout.setHorizontalGroup(hGroup);
            layout.setVerticalGroup(vGroup);
            this.renderer.setLayout(layout);
            Color borderColor = UIManager.getColor("Label.background");
            this.renderer.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, borderColor), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JComponent component = (JComponent)super.getListCellRendererComponent((JList<?>)list, "", index, isSelected, cellHasFocus);
            JLabel htmlLabel = (JLabel)this.htmlRenderer.getListCellRendererComponent(list, "", index, isSelected, cellHasFocus);
            Color bgColor = this.color(htmlLabel, false);
            if (bgColor == null) {
                bgColor = component.getBackground();
            }
            this.renderer.setBackground(bgColor);
            this.renderer.setBorder(component.getBorder());
            Color foreground = this.color(htmlLabel, true);
            if (foreground == null) {
                foreground = component.getForeground();
            }
            this.matchedNodeLabel.setForeground(foreground);
            this.selectorLabel.setForeground(foreground);
            this.mediaLabel.setForeground(foreground);
            org.openide.nodes.Node node = Visualizer.findNode((Object)value);
            Rule rule = (Rule)node.getLookup().lookup(Rule.class);
            if (rule != null) {
                FileObject fob;
                String matchedNode = node.getDisplayName();
                this.matchedNodeLabel.setText("<html>" + matchedNode);
                String ruleLocation = null;
                Resource ruleOrigin = (Resource)node.getLookup().lookup(Resource.class);
                if (ruleOrigin != null && (fob = ruleOrigin.toFileObject()) != null) {
                    String fileName = fob.getNameExt();
                    int sourceLine = rule.getSourceLine() + 1;
                    ruleLocation = fileName + ":" + sourceLine;
                }
                this.ruleLocationLabel.setVisible(ruleLocation != null);
                if (ruleLocation != null) {
                    ruleLocation = "<html><u>" + ruleLocation;
                }
                this.ruleLocationLabel.setText(ruleLocation);
                this.ruleLocationPanel.doLayout();
                String selector = rule.getSelector();
                this.selectorLabel.setText("<html>" + selector);
                String mediaQuery = null;
                for (Media media : rule.getMedia()) {
                    mediaQuery = media.getText();
                }
                this.mediaLabel.setText(mediaQuery);
                this.mediaLabel.setVisible(mediaQuery != null);
                Color fg = isSelected ? foreground : UIManager.getColor("Label.disabledForeground");
                this.ruleLocationLabel.setForeground(fg);
                this.mediaLabel.setForeground(fg);
                this.mediaLabel.setEnabled(isSelected);
            }
            String toolTip = node.getShortDescription();
            this.renderer.setToolTipText(toolTip);
            int width = list.getWidth() - list.getInsets().left - list.getInsets().right;
            this.renderer.setSize(width, 1);
            this.buildLayout();
            this.renderer.doLayout();
            this.resizeViewToMatchTheCurrentSize(this.matchedNodeLabel);
            this.resizeViewToMatchTheCurrentSize(this.selectorLabel);
            this.buildLayout();
            this.renderer.doLayout();
            return this.renderer;
        }

        private void resizeViewToMatchTheCurrentSize(JLabel label) {
            Object view = label.getClientProperty("html");
            if (view instanceof View) {
                ((View)view).setSize(label.getWidth(), label.getHeight());
            }
        }

        private Color color(JLabel label, boolean foreground) {
            Color color = null;
            LabelUI htmlUI = label.getUI();
            try {
                String methodName = foreground ? "getForegroundFor" : "getBackgroundFor";
                Method method = htmlUI.getClass().getDeclaredMethod(methodName, this.htmlRenderer.getClass());
                method.setAccessible(true);
                Object result = method.invoke(null, this.htmlRenderer);
                if (result instanceof Color) {
                    color = (Color)result;
                }
            }
            catch (IllegalAccessException ex) {
            }
            catch (IllegalArgumentException ex) {
            }
            catch (InvocationTargetException ex) {
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
            return color;
        }

        boolean isLink(Point point) {
            boolean link = false;
            Rectangle bounds = this.ruleLocationPanel.getBounds();
            if (bounds.contains(point)) {
                point.translate(-bounds.x, -bounds.y);
                bounds = this.ruleLocationLabel.getBounds();
                link = bounds.contains(point);
            }
            return link;
        }
    }

    static class PropertyPaneView
    extends TreeTableView {
        PropertyPaneView() {
            this.setRootVisible(false);
            this.setSelectionMode(1);
            final TreeCellRenderer renderer = this.tree.getCellRenderer();
            this.tree.setCellRenderer(new TreeCellRenderer(){

                @Override
                public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    Component component = renderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                    if (component instanceof JLabel) {
                        ((JLabel)component).setIcon(null);
                    }
                    return component;
                }
            });
            this.hideTreeLines();
            Color bgColor = UIManager.getColor("Label.background");
            this.treeTable.setBackground(bgColor);
            this.treeTable.getParent().setBackground(bgColor);
            HtmlRenderer.Renderer defaultRenderer = HtmlRenderer.createRenderer();
            this.treeTable.setDefaultRenderer(Node.Property.class, new TableCellRenderer((TableCellRenderer)defaultRenderer){
                private Border[] border = new Border[]{BorderFactory.createEmptyBorder(1, 0, 0, 0), BorderFactory.createEmptyBorder(1, 3, 0, 0)};
                final /* synthetic */ TableCellRenderer val$defaultRenderer;
                {
                    this.val$defaultRenderer = tableCellRenderer;
                }

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component component;
                    String toolTip = null;
                    if (value instanceof Node.Property) {
                        Node.Property property = (Node.Property)value;
                        toolTip = property.getShortDescription();
                        try {
                            value = property.getValue();
                        }
                        catch (IllegalAccessException ex) {
                        }
                        catch (InvocationTargetException ex) {
                            // empty catch block
                        }
                    }
                    if ((component = this.val$defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column)) instanceof JComponent) {
                        JComponent jcomponent = (JComponent)component;
                        jcomponent.setBorder(this.border[column]);
                        jcomponent.setToolTipText(toolTip);
                    }
                    return component;
                }
            });
            this.treeTable.getTableHeader().setDefaultRenderer(new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (component instanceof JLabel) {
                        JLabel label = (JLabel)component;
                        label.setText("<html><b>" + label.getText() + "<b>");
                        label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, column == 0 ? 17 : 1, 0, 0)));
                    }
                    return component;
                }
            });
        }

        private void hideTreeLines() {
            TreeUI treeUI = this.tree.getUI();
            if (treeUI instanceof BasicTreeUI) {
                try {
                    Field paintLines = BasicTreeUI.class.getDeclaredField("paintLines");
                    paintLines.setAccessible(true);
                    paintLines.setBoolean(treeUI, false);
                }
                catch (IllegalArgumentException ex) {
                }
                catch (IllegalAccessException ex) {
                }
                catch (NoSuchFieldException ex) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }
    }

    static class ExplorerManagerProviderPanel
    extends JPanel
    implements ExplorerManager.Provider,
    Lookup.Provider {
        private ExplorerManager manager = new ExplorerManager();
        private Lookup lookup = ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)this.getActionMap());

        ExplorerManagerProviderPanel() {
        }

        public final ExplorerManager getExplorerManager() {
            return this.manager;
        }

        public Lookup getLookup() {
            return this.lookup;
        }
    }

    class Listener
    implements PropertyChangeListener {
        Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if ("selectedNodes".equals(propertyName)) {
                CSSStylesSelectionPanel.this.updateContentImpl(CSSStylesSelectionPanel.this.pageModel, false);
            }
        }
    }
}

