/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.webkit.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.api.project.Project;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.css.model.api.Declaration;
import org.netbeans.modules.css.model.api.Declarations;
import org.netbeans.modules.css.model.api.Expression;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.model.api.PropertyValue;
import org.netbeans.modules.css.model.api.StyleSheet;
import org.netbeans.modules.css.visual.api.CssStylesTC;
import org.netbeans.modules.css.visual.api.DeclarationInfo;
import org.netbeans.modules.css.visual.api.RuleEditorController;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.web.common.api.ServerURLMapping;
import org.netbeans.modules.web.inspect.CSSUtils;
import org.netbeans.modules.web.inspect.PageInspectorImpl;
import org.netbeans.modules.web.inspect.PageModel;
import org.netbeans.modules.web.inspect.actions.Resource;
import org.netbeans.modules.web.inspect.webkit.Utilities;
import org.netbeans.modules.web.inspect.webkit.WebKitPageModel;
import org.netbeans.modules.web.inspect.webkit.ui.CSSStylesDocumentPanel;
import org.netbeans.modules.web.inspect.webkit.ui.CSSStylesSelectionPanel;
import org.netbeans.modules.web.inspect.webkit.ui.RuleInfo;
import org.netbeans.modules.web.webkit.debugging.api.css.CSS;
import org.netbeans.modules.web.webkit.debugging.api.css.Property;
import org.netbeans.modules.web.webkit.debugging.api.css.Rule;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.WindowManager;

public class CSSStylesPanel
extends JPanel
implements PageModel.CSSStylesView {
    private static final RequestProcessor RP = new RequestProcessor(CSSStylesPanel.class);
    private static final CSSStylesPanel DEFAULT = new CSSStylesPanel();
    private CSSStylesSelectionPanel selectionPanel = new CSSStylesSelectionPanel();
    WebKitPageModel pageModel;
    private CSSStylesLookup lookup = new CSSStylesLookup();
    private CSSStylesNodeLookup nodeLookup = new CSSStylesNodeLookup();
    Lookup.Result<Rule> ruleLookupResult;
    boolean active = true;
    private Listener listener;
    boolean contentUpdateInProgress;

    private CSSStylesPanel() {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(400, 400));
        PageInspectorImpl.getDefault().addPropertyChangeListener(this.getListener());
        this.lookup.updateLookup(this.selectionPanel.getLookup());
        this.ruleLookupResult = this.lookup.lookupResult(Rule.class);
        this.updatePageModel();
        this.add((Component)this.selectionPanel, "Center");
        this.ruleLookupResult.addLookupListener((LookupListener)this.getListener());
    }

    public static CSSStylesPanel getDefault() {
        return DEFAULT;
    }

    private Listener getListener() {
        if (this.listener == null) {
            this.listener = new Listener();
        }
        return this.listener;
    }

    public final void updatePageModel() {
        PageModel page = PageInspectorImpl.getDefault().getPage();
        if (this.pageModel == page) {
            return;
        }
        if (this.pageModel != null) {
            this.pageModel.removePropertyChangeListener(this.getListener());
            this.pageModel.getWebKit().getCSS().removeListener((CSS.Listener)this.getListener());
        }
        this.pageModel = page instanceof WebKitPageModel ? (WebKitPageModel)page : null;
        if (this.pageModel != null) {
            this.pageModel.addPropertyChangeListener(this.getListener());
            this.pageModel.getWebKit().getCSS().addListener((CSS.Listener)this.getListener());
        }
        this.updateContent(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateContent(boolean keepSelection) {
        try {
            this.contentUpdateInProgress = keepSelection;
            this.nodeLookup.setPageModel(this.pageModel);
            this.selectionPanel.updateContent(this.pageModel, keepSelection);
        }
        catch (Throwable throwable) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CSSStylesDocumentPanel.RP.post(new Runnable(){

                        @Override
                        public void run() {
                            CSSStylesSelectionPanel.RP.post(new Runnable(){

                                @Override
                                public void run() {
                                    EventQueue.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            CSSStylesPanel.this.contentUpdateInProgress = false;
                                            CSSStylesPanel.this.updateRulesEditor(CSSStylesPanel.this.ruleLookupResult.allInstances());
                                        }
                                    });
                                }
                            });
                        }
                    });
                }
            });
            throw throwable;
        }
        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    void updateRulesEditor(final Collection<? extends Rule> rules) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                if (CSSStylesPanel.this.pageModel != null) {
                    String selector = null;
                    if (rules.size() == 1) {
                        Rule rule = (Rule)rules.iterator().next();
                        selector = rule.getSelector();
                    }
                    CSSStylesPanel.this.pageModel.setSelectedSelector(selector);
                }
            }
        });
        if (!this.active) {
            return;
        }
        final RuleInfo ruleInfo = rules.size() == 1 ? (RuleInfo)this.lookup.lookup(RuleInfo.class) : null;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CssStylesTC ruleEditor = (CssStylesTC)WindowManager.getDefault().findTopComponent("CssStylesTC");
                final RuleEditorController controller = ruleEditor.getRuleEditorController();
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        if (rules.size() == 1) {
                            FileObject fob;
                            Rule rule = (Rule)rules.iterator().next();
                            String resourceName = rule.getSourceURL();
                            Project project = null;
                            if (CSSStylesPanel.this.pageModel != null) {
                                project = CSSStylesPanel.this.pageModel.getProject();
                            }
                            if ((fob = new Resource(project, resourceName).toFileObject()) == null) {
                                controller.setNoRuleState();
                            } else {
                                try {
                                    Source source = Source.create((FileObject)fob);
                                    ParserManager.parse(Collections.singleton(source), (UserTask)new RuleEditorTask(rule, ruleInfo, controller));
                                }
                                catch (ParseException ex) {
                                    Logger.getLogger(CSSStylesPanel.class.getName()).log(Level.INFO, null, ex);
                                }
                            }
                        } else {
                            controller.setNoRuleState();
                        }
                    }
                });
            }
        });
    }

    @Override
    public JComponent getView() {
        return this;
    }

    @Override
    public Lookup getLookup() {
        return this.nodeLookup;
    }

    @Override
    public void activated() {
        this.active = true;
        this.updateRulesEditor(this.ruleLookupResult.allInstances());
    }

    @Override
    public void deactivated() {
        this.active = false;
    }

    static class CSSStylesNodeLookup
    extends ProxyLookup {
        CSSStylesNodeLookup() {
        }

        void setPageModel(final WebKitPageModel pageModel) {
            if (EventQueue.isDispatchThread()) {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        CSSStylesNodeLookup.this.setPageModel(pageModel);
                    }
                });
                return;
            }
            URL url = null;
            FileObject fob = null;
            Project project = null;
            DataObject dob = null;
            if (pageModel != null) {
                try {
                    String documentURL;
                    project = pageModel.getProject();
                    if (project != null && (fob = ServerURLMapping.fromServer((Project)project, (URL)(url = new URL(documentURL = pageModel.getDocumentURL())))) != null) {
                        dob = DataObject.find((FileObject)fob);
                    }
                }
                catch (MalformedURLException ex) {
                }
                catch (DataObjectNotFoundException dnfex) {
                    // empty catch block
                }
            }
            Lookup lkp = dob == null ? Lookup.EMPTY : Lookups.fixed((Object[])new Object[]{url, fob, project, dob});
            AbstractNode node = new AbstractNode(Children.LEAF, lkp);
            this.setLookups(new Lookup[]{Lookups.singleton((Object)node)});
        }
    }

    class RuleEditorTask
    extends UserTask {
        private Rule rule;
        private RuleInfo ruleInfo;
        private RuleEditorController controller;

        RuleEditorTask(Rule rule, RuleInfo ruleInfo, RuleEditorController controller) {
            this.rule = rule;
            this.ruleInfo = ruleInfo;
            this.controller = controller;
        }

        private boolean isParsedOk(String propertyName, String propertyValue) {
            for (Property property : this.rule.getStyle().getProperties()) {
                if (property.isParsedOk() || !property.getName().equals(propertyName) || !property.getValue().equals(propertyValue)) continue;
                return false;
            }
            return true;
        }

        public void run(ResultIterator resultIterator) throws Exception {
            final boolean[] found = new boolean[1];
            for (final CssParserResult result : Utilities.cssParserResults(resultIterator)) {
                final Model sourceModel = Model.getModel((CssParserResult)result);
                sourceModel.runReadTask(new Model.ModelTask(){

                    public void run(StyleSheet styleSheet) {
                        org.netbeans.modules.css.model.api.Rule modelRule = Utilities.findRuleInStyleSheet(sourceModel, styleSheet, RuleEditorTask.this.rule);
                        if (modelRule != null) {
                            found[0] = true;
                            if (!CSSStylesPanel.this.active) {
                                return;
                            }
                            RuleEditorTask.this.controller.setModel(sourceModel);
                            RuleEditorTask.this.controller.setRule(modelRule);
                            if (RuleEditorTask.this.ruleInfo != null) {
                                ArrayList<String> active = new ArrayList<String>();
                                Declarations decls = modelRule.getDeclarations();
                                if (decls != null) {
                                    List declarations = decls.getDeclarations();
                                    for (int i = declarations.size() - 1; i >= 0; --i) {
                                        Declaration declaration = (Declaration)declarations.get(i);
                                        org.netbeans.modules.css.model.api.Property property = declaration.getProperty();
                                        String propertyName = ((Object)property.getContent()).toString().trim();
                                        PropertyValue propertyValue = declaration.getPropertyValue();
                                        Expression expression = propertyValue.getExpression();
                                        String value = ((Object)expression.getContent()).toString().trim();
                                        if (RuleEditorTask.this.isIEHackIgnoredByWebKit(property, result.getSnapshot())) {
                                            RuleEditorTask.this.controller.setDeclarationInfo(declaration, DeclarationInfo.INACTIVE);
                                            continue;
                                        }
                                        if (RuleEditorTask.this.isParsedOk(propertyName, value)) {
                                            if (!RuleEditorTask.this.ruleInfo.isInherited() || CSSUtils.isInheritedProperty(propertyName)) {
                                                if (RuleEditorTask.this.ruleInfo.isOverriden(propertyName) || active.contains(propertyName)) {
                                                    RuleEditorTask.this.controller.setDeclarationInfo(declaration, DeclarationInfo.OVERRIDDEN);
                                                    continue;
                                                }
                                                active.add(propertyName);
                                                continue;
                                            }
                                            RuleEditorTask.this.controller.setDeclarationInfo(declaration, DeclarationInfo.INACTIVE);
                                            continue;
                                        }
                                        RuleEditorTask.this.controller.setDeclarationInfo(declaration, DeclarationInfo.ERRONEOUS);
                                    }
                                }
                            }
                        }
                    }
                });
                if (!found[0]) continue;
                break;
            }
            if (CSSStylesPanel.this.active && !found[0]) {
                this.controller.setNoRuleState();
            }
        }

        private boolean isIEHackIgnoredByWebKit(org.netbeans.modules.css.model.api.Property property, Snapshot snapshot) {
            boolean isHack = false;
            String styleSheetText = ((Object)snapshot.getText()).toString();
            int startOffset = property.getStartOffset();
            if (startOffset != -1) {
                char c = styleSheetText.charAt(startOffset - 1);
                isHack = c == '_' || c == '*';
            }
            return isHack;
        }
    }

    static class CSSStylesLookup
    extends ProxyLookup {
        CSSStylesLookup() {
        }

        protected final void updateLookup(Lookup lookup) {
            if (lookup == null) {
                this.setLookups(new Lookup[0]);
            } else {
                this.setLookups(new Lookup[]{lookup});
            }
        }
    }

    class Listener
    implements PropertyChangeListener,
    LookupListener,
    CSS.Listener {
        Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if ("model".equals(propName)) {
                CSSStylesPanel.this.updatePageModel();
            } else if ("document".equals(propName)) {
                CSSStylesPanel.this.updateContent(false);
            }
        }

        public void resultChanged(LookupEvent ev) {
            Collection rules = CSSStylesPanel.this.ruleLookupResult.allInstances();
            if (!CSSStylesPanel.this.contentUpdateInProgress) {
                CSSStylesPanel.this.updateRulesEditor(rules);
            }
        }

        public void mediaQueryResultChanged() {
            this.updateContentInRP();
        }

        public void styleSheetChanged(String styleSheetId) {
            this.updateContentInRP();
        }

        private void updateContentInRP() {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    CSSStylesPanel.this.updateContent(true);
                }
            });
        }
    }
}

