/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.webkit.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.netbeans.modules.web.inspect.PageInspectorImpl;
import org.netbeans.modules.web.inspect.PageModel;
import org.netbeans.modules.web.inspect.ui.FakeRootNode;
import org.netbeans.modules.web.inspect.webkit.Utilities;
import org.netbeans.modules.web.inspect.webkit.WebKitPageModel;
import org.netbeans.modules.web.inspect.webkit.ui.DocumentNode;
import org.netbeans.modules.web.inspect.webkit.ui.Filter;
import org.netbeans.modules.web.webkit.debugging.api.css.Rule;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CSSStylesDocumentPanel
extends JPanel
implements ExplorerManager.Provider,
Lookup.Provider {
    static final RequestProcessor RP = new RequestProcessor(CSSStylesDocumentPanel.class);
    private BeanTreeView treeView;
    private ExplorerManager manager = new ExplorerManager();
    private Lookup lookup = ExplorerUtils.createLookup((ExplorerManager)this.getExplorerManager(), (ActionMap)this.getActionMap());
    private Filter filter = new Filter();
    Object lastHover = null;

    CSSStylesDocumentPanel() {
        this.setLayout(new BorderLayout());
        this.initTreeView();
        this.initFilter();
        this.updateContent(null, true);
    }

    private void initTreeView() {
        this.treeView = new BeanTreeView(){
            {
                MouseAdapter listener = CSSStylesDocumentPanel.this.createTreeMouseListener();
                this.tree.addMouseListener(listener);
                this.tree.addMouseMotionListener(listener);
                this.tree.setCellRenderer(CSSStylesDocumentPanel.this.createTreeCellRenderer(this.tree.getCellRenderer()));
            }

            public void expandAll() {
                Node root = CSSStylesDocumentPanel.this.manager.getRootContext();
                this.expandAll(root);
                this.collapseNode(root);
                this.expandNode(root);
            }

            private void expandAll(Node node) {
                CSSStylesDocumentPanel.this.treeView.expandNode(node);
                for (Node subNode : node.getChildren().getNodes(true)) {
                    if (subNode.isLeaf()) continue;
                    this.expandAll(subNode);
                }
            }
        };
        this.treeView.setAllowedDragActions(0);
        this.treeView.setAllowedDropActions(0);
        this.treeView.setRootVisible(false);
        this.add((Component)this.treeView, "Center");
    }

    private void initFilter() {
        JPanel panel = new JPanel();
        Color background = this.treeView.getViewport().getView().getBackground();
        panel.setBackground(background);
        JLabel label = new JLabel(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/web/inspect/resources/find.png", (boolean)true));
        label.setVerticalAlignment(0);
        final JTextField field = new JTextField();
        field.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                CSSStylesDocumentPanel.this.filter.setPattern(field.getText());
            }
        });
        JButton button = new JButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/web/inspect/resources/cancel.png", (boolean)true));
        button.setBackground(background);
        button.setBorderPainted(false);
        button.setFocusPainted(false);
        button.setMargin(new Insets(0, 0, 0, 0));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                field.setText("");
            }
        });
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGap(2).addComponent(label).addComponent(field).addComponent(button).addGap(2));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(label).addComponent(field).addComponent(button)));
        this.add((Component)panel, "First");
    }

    final void updateContent(final WebKitPageModel pageModel, final boolean keepSelection) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                FakeRootNode<DocumentNode> root;
                if (pageModel == null) {
                    root = new FakeRootNode<DocumentNode>(Children.LEAF);
                } else {
                    CSSStylesDocumentPanel.this.filter.removePropertyChangeListeners();
                    DocumentNode documentNode = new DocumentNode(pageModel, CSSStylesDocumentPanel.this.filter);
                    root = new FakeRootNode<DocumentNode>(documentNode, new Action[]{new RefreshAction()});
                }
                final Node[] oldSelection = CSSStylesDocumentPanel.this.manager.getSelectedNodes();
                CSSStylesDocumentPanel.this.manager.setRootContext((Node)root);
                CSSStylesDocumentPanel.this.treeView.expandAll();
                if (keepSelection) {
                    EventQueue.invokeLater(new Runnable((Node)root){
                        final /* synthetic */ Node val$root;
                        {
                            this.val$root = node;
                        }

                        @Override
                        public void run() {
                            ArrayList<Node> selection = new ArrayList<Node>(oldSelection.length);
                            for (Node oldSelected : oldSelection) {
                                Node newSelected;
                                Rule rule = (Rule)oldSelected.getLookup().lookup(Rule.class);
                                if (rule == null || (newSelected = Utilities.findRule(this.val$root, rule)) == null) continue;
                                selection.add(newSelected);
                            }
                            try {
                                CSSStylesDocumentPanel.this.manager.setSelectedNodes(selection.toArray(new Node[selection.size()]));
                            }
                            catch (PropertyVetoException propertyVetoException) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
        });
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public final ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public MouseAdapter createTreeMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                this.processEvent(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                this.processEvent(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.processEvent(null);
                CSSStylesDocumentPanel.this.lastHover = new Object();
            }

            private void processEvent(MouseEvent e) {
                JTree tree;
                TreePath path;
                Object hover = null;
                if (e != null && (path = (tree = (JTree)e.getSource()).getPathForLocation(e.getX(), e.getY())) != null) {
                    hover = path.getLastPathComponent();
                }
                if (hover != CSSStylesDocumentPanel.this.lastHover) {
                    Node node;
                    Rule rule;
                    CSSStylesDocumentPanel.this.lastHover = hover;
                    final String selector = hover != null ? ((rule = (Rule)(node = Visualizer.findNode(hover)).getLookup().lookup(Rule.class)) != null ? rule.getSelector() : null) : null;
                    CSSStylesDocumentPanel.this.treeView.repaint();
                    final PageModel pageModel = CSSStylesDocumentPanel.this.currentPageModel();
                    if (pageModel != null) {
                        RP.post(new Runnable(){

                            @Override
                            public void run() {
                                pageModel.setHighlightedSelector(selector);
                            }
                        });
                    }
                }
            }
        };
    }

    private PageModel currentPageModel() {
        Object node = this.manager.getRootContext();
        if (node instanceof FakeRootNode) {
            node = ((FakeRootNode)((Object)node)).getRealRoot();
        }
        return (PageModel)((Object)node.getLookup().lookup(PageModel.class));
    }

    private TreeCellRenderer createTreeCellRenderer(final TreeCellRenderer delegate) {
        Color origColor = UIManager.getColor("Tree.selectionBackground");
        Color color = origColor.brighter().brighter();
        if (color.equals(Color.WHITE)) {
            color = origColor.darker();
        }
        final Color hoverColor = color;
        return new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                JLabel component;
                if (!selected && value == CSSStylesDocumentPanel.this.lastHover) {
                    component = (JLabel)delegate.getTreeCellRendererComponent(tree, value, true, expanded, leaf, row, hasFocus);
                    component.setBackground(hoverColor);
                    component.setOpaque(true);
                } else {
                    component = (JLabel)delegate.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                }
                return component;
            }
        };
    }

    private class RefreshAction
    extends AbstractAction {
        private RefreshAction() {
            String name = NbBundle.getMessage(RefreshAction.class, (String)"CSSStylesDocumentPanel.RefreshAction.displayName");
            this.putValue("Name", name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PageModel pageModel = PageInspectorImpl.getDefault().getPage();
            CSSStylesDocumentPanel.this.updateContent(pageModel instanceof WebKitPageModel ? (WebKitPageModel)pageModel : null, false);
        }
    }
}

