/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.webkit.actions;

import java.awt.EventQueue;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.model.api.StyleSheet;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.web.inspect.CSSUtils;
import org.netbeans.modules.web.inspect.actions.Resource;
import org.netbeans.modules.web.inspect.webkit.Utilities;
import org.netbeans.modules.web.webkit.debugging.api.css.Rule;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class GoToRuleSourceAction
extends NodeAction {
    protected void performAction(Node[] activatedNodes) {
        Lookup lookup = activatedNodes[0].getLookup();
        Rule rule = (Rule)lookup.lookup(Rule.class);
        Resource resource = (Resource)lookup.lookup(Resource.class);
        FileObject fob = resource.toFileObject();
        try {
            Source source = Source.create((FileObject)fob);
            ParserManager.parse(Collections.singleton(source), (UserTask)new GoToRuleTask(rule, fob));
        }
        catch (ParseException ex) {
            Logger.getLogger(GoToRuleSourceAction.class.getName()).log(Level.INFO, null, ex);
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        Lookup lookup;
        Rule rule;
        boolean enabled = false;
        if (activatedNodes.length == 1 && (rule = (Rule)(lookup = activatedNodes[0].getLookup()).lookup(Rule.class)) != null) {
            Resource resource = (Resource)lookup.lookup(Resource.class);
            enabled = resource != null && resource.toFileObject() != null;
        }
        return enabled;
    }

    protected boolean asynchronous() {
        return true;
    }

    public String getName() {
        return NbBundle.getMessage(GoToRuleSourceAction.class, (String)"GoToRuleSourceAction.displayName");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    static class GoToRuleTask
    extends UserTask {
        private Rule rule;
        private FileObject fob;

        GoToRuleTask(Rule rule, FileObject fob) {
            this.rule = rule;
            this.fob = fob;
        }

        public void run(ResultIterator resultIterator) throws Exception {
            final boolean[] found = new boolean[1];
            for (final CssParserResult result : Utilities.cssParserResults(resultIterator)) {
                final Model sourceModel = Model.getModel((CssParserResult)result);
                sourceModel.runReadTask(new Model.ModelTask(){

                    public void run(StyleSheet styleSheet) {
                        org.netbeans.modules.css.model.api.Rule modelRule = Utilities.findRuleInStyleSheet(sourceModel, styleSheet, GoToRuleTask.this.rule);
                        if (modelRule != null) {
                            found[0] = true;
                            int snapshotOffset = modelRule.getStartOffset();
                            final int offset = result.getSnapshot().getOriginalOffset(snapshotOffset);
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    CSSUtils.open(GoToRuleTask.this.fob, offset);
                                }
                            });
                        }
                    }
                });
                if (!found[0]) continue;
                break;
            }
        }
    }
}

