/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.webkit.actions;

import java.awt.EventQueue;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.css.model.api.Declaration;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.model.api.StyleSheet;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.web.inspect.CSSUtils;
import org.netbeans.modules.web.inspect.actions.Resource;
import org.netbeans.modules.web.inspect.webkit.Utilities;
import org.netbeans.modules.web.inspect.webkit.actions.GoToRuleSourceAction;
import org.netbeans.modules.web.webkit.debugging.api.css.Property;
import org.netbeans.modules.web.webkit.debugging.api.css.Rule;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class GoToPropertySourceAction
extends NodeAction {
    protected void performAction(Node[] activatedNodes) {
        Lookup lookup = activatedNodes[0].getLookup();
        Rule rule = (Rule)lookup.lookup(Rule.class);
        Property property = (Property)lookup.lookup(Property.class);
        Resource resource = (Resource)lookup.lookup(Resource.class);
        FileObject fob = resource.toFileObject();
        try {
            Source source = Source.create((FileObject)fob);
            ParserManager.parse(Collections.singleton(source), (UserTask)new GoToPropertyTask(fob, rule, property));
        }
        catch (ParseException ex) {
            Logger.getLogger(GoToRuleSourceAction.class.getName()).log(Level.INFO, null, ex);
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        boolean enabled = false;
        if (activatedNodes.length == 1) {
            Lookup lookup = activatedNodes[0].getLookup();
            Rule rule = (Rule)lookup.lookup(Rule.class);
            Property property = (Property)lookup.lookup(Property.class);
            Resource resource = (Resource)lookup.lookup(Resource.class);
            if (rule != null && property != null && resource != null) {
                enabled = resource.toFileObject() != null;
            }
        }
        return enabled;
    }

    protected boolean asynchronous() {
        return true;
    }

    public String getName() {
        return NbBundle.getMessage(GoToPropertySourceAction.class, (String)"GoToPropertySourceAction.displayName");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    static class GoToPropertyTask
    extends UserTask {
        private FileObject fob;
        private Rule rule;
        private Property property;

        GoToPropertyTask(FileObject fob, Rule rule, Property property) {
            this.fob = fob;
            this.rule = rule;
            this.property = property;
        }

        public void run(ResultIterator resultIterator) throws Exception {
            final boolean[] found = new boolean[1];
            for (final CssParserResult result : Utilities.cssParserResults(resultIterator)) {
                final Model sourceModel = Model.getModel((CssParserResult)result);
                sourceModel.runReadTask(new Model.ModelTask(){

                    public void run(StyleSheet styleSheet) {
                        org.netbeans.modules.css.model.api.Rule modelRule = Utilities.findRuleInStyleSheet(sourceModel, styleSheet, GoToPropertyTask.this.rule);
                        if (modelRule != null) {
                            String shorthandName;
                            found[0] = true;
                            String propertyName = GoToPropertyTask.this.property.getName().trim();
                            org.netbeans.modules.css.model.api.Property modelProperty = this.findProperty(modelRule, propertyName);
                            if (modelProperty == null && (shorthandName = GoToPropertyTask.this.property.getShorthandName()) != null) {
                                modelProperty = this.findProperty(modelRule, shorthandName);
                            }
                            int snapshotOffset = modelProperty == null ? modelRule.getStartOffset() : modelProperty.getStartOffset();
                            final int offset = result.getSnapshot().getOriginalOffset(snapshotOffset);
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    CSSUtils.open(GoToPropertyTask.this.fob, offset);
                                }
                            });
                        }
                    }

                    private org.netbeans.modules.css.model.api.Property findProperty(org.netbeans.modules.css.model.api.Rule rule, String propertyName) {
                        for (Declaration declaration : rule.getDeclarations().getDeclarations()) {
                            org.netbeans.modules.css.model.api.Property modelProperty = declaration.getProperty();
                            String modelPropertyName = ((Object)modelProperty.getContent()).toString().trim();
                            if (!propertyName.equals(modelPropertyName)) continue;
                            return modelProperty;
                        }
                        return null;
                    }
                });
                if (!found[0]) continue;
                break;
            }
        }
    }
}

