/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.webkit;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.css.model.api.Declaration;
import org.netbeans.modules.css.model.api.Declarations;
import org.netbeans.modules.css.model.api.Element;
import org.netbeans.modules.css.model.api.MediaQueryList;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.model.api.ModelVisitor;
import org.netbeans.modules.css.model.api.SelectorsGroup;
import org.netbeans.modules.css.model.api.StyleSheet;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.modules.web.inspect.CSSUtils;
import org.netbeans.modules.web.inspect.actions.Resource;
import org.netbeans.modules.web.webkit.debugging.api.css.Media;
import org.netbeans.modules.web.webkit.debugging.api.css.Property;
import org.netbeans.modules.web.webkit.debugging.api.css.Rule;
import org.netbeans.modules.web.webkit.debugging.api.css.SourceRange;
import org.netbeans.modules.web.webkit.debugging.api.css.StyleSheetBody;
import org.netbeans.modules.web.webkit.debugging.api.css.StyleSheetOrigin;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;

public class Utilities {
    /*
     * Enabled aggressive block sorting
     */
    public static org.netbeans.modules.css.model.api.Rule findRuleInStyleSheet(Model sourceModel, StyleSheet styleSheet, Rule rule) {
        int index;
        String selector = CSSUtils.normalizeSelector(rule.getSelector());
        String mediaQuery = null;
        for (Media media : rule.getMedia()) {
            if (media.getSource() != Media.Source.MEDIA_RULE) continue;
            mediaQuery = media.getText();
            mediaQuery = CSSUtils.normalizeMediaQuery(mediaQuery);
        }
        HashSet<String> properties = new HashSet<String>();
        for (Property property : rule.getStyle().getProperties()) {
            if (property.getText() == null) continue;
            String propertyName = property.getName();
            properties.add(propertyName.trim());
        }
        int sourceLine = rule.getSourceLine();
        SourceRange range = rule.getSelectorRange();
        int startOffset = range == null ? Short.MIN_VALUE : range.getStart();
        org.netbeans.modules.css.model.api.Rule result = Utilities.findRuleInStyleSheet0(sourceModel, styleSheet, selector, mediaQuery, properties, sourceLine, startOffset);
        if (result != null) return result;
        StyleSheetBody parentStyleSheet = rule.getParentStyleSheet();
        if (parentStyleSheet == null) return result;
        if (range == null) return result;
        String styleSheetText = parentStyleSheet.getText();
        if (styleSheetText == null) return result;
        selector = styleSheetText.substring(range.getStart(), range.getEnd());
        result = Utilities.findRuleInStyleSheet0(sourceModel, styleSheet, selector = CSSUtils.normalizeSelector(selector), mediaQuery, properties, sourceLine, startOffset);
        if (result != null) return result;
        if (rule.getMedia().isEmpty()) return result;
        if (range.getStart() != 0) return result;
        boolean inLiteral = false;
        block6: for (index = selector.length() - 1; index >= 0; --index) {
            char c = selector.charAt(index);
            switch (c) {
                case '\"': {
                    inLiteral = !inLiteral;
                    break;
                }
                case '{': 
                case '}': {
                    if (!inLiteral) break block6;
                }
            }
        }
        if (index == -1) return result;
        selector = selector.substring(index + 1);
        selector = CSSUtils.normalizeSelector(selector);
        return Utilities.findRuleInStyleSheet0(sourceModel, styleSheet, selector, mediaQuery, properties, sourceLine, startOffset);
    }

    private static org.netbeans.modules.css.model.api.Rule findRuleInStyleSheet0(final Model sourceModel, StyleSheet styleSheet, final String selector, final String mediaQuery, final Set<String> properties, final int sourceLine, final int startOffset) {
        final org.netbeans.modules.css.model.api.Rule[] result = new org.netbeans.modules.css.model.api.Rule[1];
        styleSheet.accept((ModelVisitor)new ModelVisitor.Adapter(){
            private int bestMatchValue = 0;

            public void visitRule(org.netbeans.modules.css.model.api.Rule rule) {
                int matchValue;
                String selectorInFile;
                SelectorsGroup selectorGroup = rule.getSelectorsGroup();
                CharSequence image = sourceModel.getElementSource((Element)selectorGroup);
                Element parent = rule.getParent();
                String queryListText = null;
                if (parent instanceof org.netbeans.modules.css.model.api.Media) {
                    org.netbeans.modules.css.model.api.Media media = (org.netbeans.modules.css.model.api.Media)parent;
                    MediaQueryList queryList = media.getMediaQueryList();
                    queryListText = ((Object)sourceModel.getElementSource((Element)queryList)).toString();
                    queryListText = CSSUtils.normalizeMediaQuery(queryListText);
                }
                if (selector.equals(selectorInFile = CSSUtils.normalizeSelector(((Object)image).toString())) && (mediaQuery == null ? queryListText == null : mediaQuery.equals(queryListText)) && (matchValue = this.matchValue(rule)) >= this.bestMatchValue) {
                    this.bestMatchValue = matchValue;
                    result[0] = rule;
                }
            }

            private int matchValue(org.netbeans.modules.css.model.api.Rule rule) {
                int offset;
                int value = 0;
                Declarations declarations = rule.getDeclarations();
                if (declarations != null) {
                    for (Declaration declaration : declarations.getDeclarations()) {
                        org.netbeans.modules.css.model.api.Property modelProperty = declaration.getProperty();
                        String modelPropertyName = ((Object)modelProperty.getContent()).toString().trim();
                        if (!properties.contains(modelPropertyName)) continue;
                        value += 2;
                    }
                }
                if ((offset = rule.getStartOffset()) == startOffset || offset + sourceLine == startOffset) {
                    try {
                        int line = LexerUtils.getLineOffset((CharSequence)sourceModel.getModelSource(), (int)offset);
                        if (line == sourceLine) {
                            ++value;
                        }
                    }
                    catch (BadLocationException blex) {
                        // empty catch block
                    }
                }
                return value;
            }
        });
        return result[0];
    }

    public static boolean showInCSSStyles(Rule rule) {
        return rule.getOrigin() != StyleSheetOrigin.USER_AGENT;
    }

    public static Node findRule(Node root, Rule rule) {
        Rule candidate = (Rule)root.getLookup().lookup(Rule.class);
        if (candidate != null && rule.getId().equals((Object)candidate.getId()) && rule.getSourceURL().equals(candidate.getSourceURL()) && rule.getSelector().equals(candidate.getSelector())) {
            return root;
        }
        for (Node node : root.getChildren().getNodes()) {
            Node result = Utilities.findRule(node, rule);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static List<CssParserResult> cssParserResults(ResultIterator resultIterator) throws ParseException {
        ArrayList<ResultIterator> resultIterators = new ArrayList<ResultIterator>();
        resultIterators.add(resultIterator);
        for (Embedding embedding : resultIterator.getEmbeddings()) {
            String mimeType = embedding.getMimeType();
            if (!"text/css".equals(mimeType)) continue;
            resultIterators.add(resultIterator.getResultIterator(embedding));
        }
        ArrayList<CssParserResult> parserResults = new ArrayList<CssParserResult>(resultIterators.size());
        for (ResultIterator iterator : resultIterators) {
            Parser.Result parserResult = iterator.getParserResult();
            if (!(parserResult instanceof CssParserResult)) continue;
            parserResults.add((CssParserResult)parserResult);
        }
        return parserResults;
    }

    public static String relativeResourceName(String resourceUrl, Project project) {
        FileObject fob;
        String name = resourceUrl;
        if (project != null && (fob = new Resource(project, resourceUrl).toFileObject()) != null) {
            String relativePath;
            FileObject projectDir = project.getProjectDirectory();
            name = relativePath = FileUtil.getRelativePath((FileObject)projectDir, (FileObject)fob);
        }
        return name;
    }
}

