/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.webkit;

import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.openide.nodes.Node;

abstract class SortedPropertySet<T extends Node.Property>
extends Node.PropertySet {
    private SortedMap<String, T> properties = new TreeMap<String, T>(new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.compareTo(o2);
        }
    });
    protected boolean initialized;

    SortedPropertySet(String name, String displayName, String shortDescription) {
        super(name, displayName, shortDescription);
    }

    synchronized void addProperty(T property) {
        this.properties.put(property.getName(), property);
    }

    synchronized void removeProperty(T property) {
        this.properties.remove(property.getName());
    }

    synchronized T getProperty(String name) {
        return (T)((Node.Property)this.properties.get(name));
    }

    abstract void update();

    public synchronized Node.Property<?>[] getProperties() {
        if (!this.initialized) {
            this.initialized = true;
            this.update();
        }
        return this.properties.values().toArray(new Node.Property[this.properties.size()]);
    }
}

