/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.webkit;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.common.api.ServerURLMapping;
import org.netbeans.modules.web.inspect.webkit.WebKitPageModel;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class EditorSynchronizer
implements PropertyChangeListener {
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        WebKitPageModel pageModel = (WebKitPageModel)((Object)evt.getSource());
        if (propName.equals("browserSelectedNodes")) {
            EditorSynchronizer.focusInspectedFile(pageModel);
        } else if (propName.equals("selectionMode") && pageModel.isSelectionMode()) {
            EditorSynchronizer.focusInspectedFile(pageModel);
        }
    }

    private static void focusInspectedFile(WebKitPageModel pageModel) {
        block6: {
            Project project;
            String documentURL = pageModel.getDocumentURL();
            if (documentURL != null && (project = pageModel.getProject()) != null) {
                try {
                    URL url = new URL(documentURL);
                    FileObject fob = ServerURLMapping.fromServer((Project)project, (URL)url);
                    if (fob == null) break block6;
                    try {
                        DataObject dob = DataObject.find((FileObject)fob);
                        EditorCookie editor = (EditorCookie)dob.getLookup().lookup(EditorCookie.class);
                        if (editor != null) {
                            editor.open();
                        }
                    }
                    catch (DataObjectNotFoundException ex) {}
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
    }
}

