/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.webkit;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.inspect.actions.Resource;
import org.netbeans.modules.web.inspect.webkit.AttributesPropertySet;
import org.netbeans.modules.web.inspect.webkit.WebKitPageModel;
import org.netbeans.modules.web.inspect.webkit.actions.GoToNodeSourceAction;
import org.netbeans.modules.web.webkit.debugging.api.dom.Node;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class DOMNode
extends AbstractNode {
    private static final RequestProcessor RP = new RequestProcessor(DOMNode.class.getName());
    private static final String ACTIONS_PATH = "Navigation/DOM/Actions";
    static final String ICON_BASE = "org/netbeans/modules/web/inspect/resources/domElement.png";
    private Node node;
    private Node.PropertySet[] propertySets;
    private boolean nodeIdInDisplayName = Boolean.getBoolean("org.netbeans.modules.web.inspect.nodeIdInDisplayName");
    private WebKitPageModel model;

    public DOMNode(WebKitPageModel model, Node node) {
        super((Children)(DOMNode.shouldBeLeaf(node) ? Children.LEAF : new DOMChildren(model)), DOMNode.lookupFor(model, node));
        this.node = node;
        this.model = model;
        this.setIconBaseWithExtension(ICON_BASE);
        this.setName(node.getNodeName());
        this.updateDisplayName();
    }

    private static Lookup lookupFor(WebKitPageModel model, Node node) {
        Lookup lookup;
        String documentURL = node.getDocumentURL();
        if (documentURL == null) {
            lookup = Lookups.fixed((Object[])new Object[]{node});
        } else {
            Project project = model.getProject();
            lookup = Lookups.fixed((Object[])new Object[]{node, new Resource(project, documentURL)});
        }
        return lookup;
    }

    public String getHtmlDisplayName() {
        String displayName;
        ResourceBundle bundle = NbBundle.getBundle(DOMNode.class);
        int nodeType = this.node.getNodeType();
        if (nodeType == 1) {
            String pattern = bundle.getString("DOMNode.elementDisplayName");
            String tagName = this.node.getNodeName().toLowerCase();
            String selector = this.getSelector();
            displayName = MessageFormat.format(pattern, tagName, selector);
        } else {
            displayName = nodeType == 9 ? bundle.getString("DOMNode.documentDisplayName") : this.node.getNodeType() + " " + this.node.getNodeName() + " " + this.node.getNodeValue();
        }
        if (this.nodeIdInDisplayName) {
            displayName = displayName + " (" + this.getNode().getNodeId() + ")";
        }
        return displayName;
    }

    private String getSelector() {
        Node.Attribute classAttr;
        StringBuilder selector = new StringBuilder();
        Node.Attribute idAttr = this.node.getAttribute("id");
        if (idAttr != null) {
            selector.append('#').append(idAttr.getValue());
        }
        if ((classAttr = this.node.getAttribute("class")) != null) {
            StringTokenizer st = new StringTokenizer(classAttr.getValue());
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                selector.append('.').append(token.trim());
            }
        }
        return selector.toString();
    }

    public synchronized Node.PropertySet[] getPropertySets() {
        if (this.propertySets == null) {
            this.propertySets = this.createPropertySets();
        }
        return this.propertySets;
    }

    private Node.PropertySet[] createPropertySets() {
        return new Node.PropertySet[]{new AttributesPropertySet(this)};
    }

    synchronized void updateAttributes() {
        if (this.propertySets != null) {
            for (Node.PropertySet set : this.propertySets) {
                if (!(set instanceof AttributesPropertySet)) continue;
                ((AttributesPropertySet)set).update();
            }
            this.firePropertySetsChange(null, null);
        }
        this.updateDisplayName();
    }

    void updateCharacterData() {
        this.updateDisplayName();
    }

    private void updateDisplayName() {
        String tagName = this.node.getNodeName().toLowerCase();
        String selector = this.getSelector();
        this.setDisplayName(tagName + selector);
    }

    Node getNode() {
        return this.node;
    }

    void updateChildren(final Node node) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                DOMNode.this.node = node;
                boolean shouldBeLeaf = DOMNode.shouldBeLeaf(node);
                if (shouldBeLeaf != DOMNode.this.isLeaf()) {
                    DOMNode.this.setChildren((Children)(shouldBeLeaf ? Children.LEAF : new DOMChildren(DOMNode.this.model)));
                }
                if (!shouldBeLeaf) {
                    DOMChildren children = (DOMChildren)DOMNode.this.getChildren();
                    children.updateKeys(node);
                }
            }
        });
    }

    private static boolean shouldBeLeaf(Node node) {
        if (node.getContentDocument() != null) {
            return false;
        }
        List subNodes = node.getChildren();
        if (subNodes != null) {
            for (Node subNode : subNodes) {
                boolean isElement = subNode.getNodeType() == 1;
                if (!isElement || subNode.isInjectedByNetBeans()) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return super.toString() + "[nodeId=" + this.getNode().getNodeId() + ", identityHashCode=" + System.identityHashCode((Object)this) + "]";
    }

    public Action[] getActions(boolean context) {
        ArrayList<Object> actions = new ArrayList<Object>();
        actions.add(SystemAction.get(GoToNodeSourceAction.class));
        for (Action action : Utilities.actionsForPath((String)ACTIONS_PATH)) {
            if (action instanceof ContextAwareAction) {
                action = ((ContextAwareAction)action).createContextAwareInstance(this.getLookup());
            }
            actions.add(action);
        }
        return actions.toArray(new Action[actions.size()]);
    }

    public Action getPreferredAction() {
        return SystemAction.get(GoToNodeSourceAction.class);
    }

    static class DOMChildren
    extends Children.Keys<Integer> {
        private WebKitPageModel pageModel;

        DOMChildren(WebKitPageModel pageModel) {
            this.pageModel = pageModel;
        }

        void updateKeys(Node node) {
            Node contentDocument;
            ArrayList<Integer> keys = new ArrayList<Integer>();
            List subNodes = node.getChildren();
            if (subNodes != null) {
                for (Node subNode : subNodes) {
                    boolean isElement = subNode.getNodeType() == 1;
                    if (!isElement || subNode.isInjectedByNetBeans()) continue;
                    keys.add(subNode.getNodeId());
                }
            }
            if ((contentDocument = node.getContentDocument()) != null) {
                keys.add(contentDocument.getNodeId());
            }
            this.setKeys(keys);
            this.getNodes(true);
        }

        protected org.openide.nodes.Node[] createNodes(Integer nodeId) {
            org.openide.nodes.Node[] result;
            DOMNode node = this.pageModel.getNode(nodeId);
            if (node == null) {
                result = null;
            } else {
                org.openide.nodes.Node oldParent = node.getParentNode();
                org.openide.nodes.Node newParent = this.getNode();
                if (oldParent == null || oldParent == newParent) {
                    result = new org.openide.nodes.Node[]{node};
                } else {
                    Logger.getLogger(DOMChildren.class.getName()).log(Level.INFO, "Node {0} cannot be added to node {1} because it already belongs to {2}!", new Object[]{node, newParent, oldParent});
                    result = null;
                }
            }
            return result;
        }
    }
}

