/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.webkit;

import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.netbeans.modules.web.inspect.webkit.CSSUpdater;

class CSSUpdaterTask
extends ParserResultTask<ParserResult> {
    CSSUpdaterTask() {
    }

    public void run(ParserResult result, SchedulerEvent event) {
        CSSUpdater updater = CSSUpdater.getDefault();
        if (!updater.isStarted()) {
            return;
        }
        String sourceMimeType = result.getSnapshot().getSource().getMimeType();
        if (!this.hasFatalErrors(result) && "text/css".equals(sourceMimeType)) {
            updater.update(result.getSnapshot().getSource().getFileObject(), ((Object)result.getSnapshot().getText()).toString());
        }
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void cancel() {
    }

    private boolean hasFatalErrors(ParserResult result) {
        for (Error err : result.getDiagnostics()) {
            if (err.getSeverity() != Severity.FATAL) continue;
            return true;
        }
        return false;
    }

    public static class Factory
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            String mimeType = snapshot.getMimeType();
            if (mimeType.equals("text/css")) {
                return Collections.singletonList(new CSSUpdaterTask());
            }
            return Collections.emptyList();
        }
    }
}

