/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.webkit;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.util.HashMap;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.css.live.LiveUpdater;
import org.netbeans.modules.web.common.api.ServerURLMapping;
import org.netbeans.modules.web.webkit.debugging.api.WebKitDebugging;
import org.netbeans.modules.web.webkit.debugging.api.css.StyleSheetHeader;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class CSSUpdater {
    private static CSSUpdater instance;
    private WebKitDebugging webKit;
    private HashMap<String, StyleSheetHeader> sheetsMap = new HashMap();

    private CSSUpdater() {
    }

    static synchronized CSSUpdater getDefault() {
        if (instance == null) {
            instance = new CSSUpdater();
        }
        return instance;
    }

    synchronized void start(WebKitDebugging webKit) {
        assert (webKit != null) : "webKit allready assigned";
        this.webKit = webKit;
        for (StyleSheetHeader header : webKit.getCSS().getAllStyleSheets()) {
            try {
                URL url = new URL(header.getSourceURL());
                if (url.getQuery() != null) {
                    url = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getPath());
                }
                this.sheetsMap.put(url.toString(), header);
                if (!InetAddress.getLocalHost().equals(InetAddress.getByName(url.getHost()))) continue;
                this.sheetsMap.put(new URL(url.toExternalForm().replace(url.getHost(), "localhost")).toString(), header);
            }
            catch (IOException ex) {}
        }
    }

    synchronized void stop() {
        this.webKit = null;
        this.sheetsMap.clear();
    }

    synchronized boolean isStarted() {
        return this.webKit != null;
    }

    synchronized void update(FileObject fileObject, String content) {
        assert (this.webKit != null) : "webKit not initialized";
        Project owner = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (owner == null) {
            return;
        }
        URL serverUrl = ServerURLMapping.toServer((Project)owner, (FileObject)fileObject);
        if (serverUrl == null) {
            return;
        }
        StyleSheetHeader header = this.sheetsMap.get(serverUrl.toString());
        if (header != null) {
            this.webKit.getCSS().setStyleSheetText(header.getStyleSheetId(), content);
        }
    }

    public static class LiveUpdaterImpl
    implements LiveUpdater {
        private RequestProcessor RP = new RequestProcessor(LiveUpdaterImpl.class);

        public boolean update(final Document doc) {
            if (!CSSUpdater.getDefault().isStarted()) {
                return false;
            }
            this.RP.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        String text = doc.getText(0, doc.getLength());
                        CSSUpdater.getDefault().update(LiveUpdaterImpl.getDataObject(doc).getPrimaryFile(), text);
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
            });
            return false;
        }

        private static DataObject getDataObject(Document doc) {
            Object sdp;
            Object object = sdp = doc == null ? null : doc.getProperty("stream");
            if (sdp instanceof DataObject) {
                return (DataObject)sdp;
            }
            return null;
        }
    }
}

