/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.css.model.api.Element;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.model.api.Rule;
import org.netbeans.modules.css.model.api.StyleSheet;
import org.netbeans.modules.css.visual.spi.CssStylesListener;
import org.netbeans.modules.css.visual.spi.CssStylesPanelProvider;
import org.netbeans.modules.web.clientproject.api.ClientSideModule;
import org.netbeans.modules.web.common.api.ServerURLMapping;
import org.netbeans.modules.web.inspect.PageInspectorImpl;
import org.netbeans.modules.web.inspect.PageModel;
import org.netbeans.modules.web.inspect.ui.Bundle;
import org.netbeans.modules.web.inspect.webkit.WebKitPageModel;
import org.netbeans.spi.project.ActionProvider;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public abstract class CssStylesPanelProviderImpl
extends JPanel
implements CssStylesPanelProvider {
    private JLabel noStylesLabel;
    private FileObject lastRelatedFileObject;
    private PageModel currentPageModel;
    private FileObject inspectedFileObject;
    private JPanel runFilePanel;
    private JButton runButton;
    private MatchedRulesLookup lookup = new MatchedRulesLookup();
    private boolean active = true;
    private static final RequestProcessor RP = new RequestProcessor(CssStylesPanelProviderImpl.class);

    public CssStylesPanelProviderImpl() {
        this.setLayout(new BorderLayout());
        this.initNoStylesLabel();
        this.initRunFilePanel();
        this.add((Component)this.noStylesLabel, "Center");
        PageInspectorImpl.getDefault().addPropertyChangeListener(this.createInspectorListener());
        this.update(PageInspectorImpl.getDefault().getPage());
    }

    Lookup getMatchedRulesLookup() {
        return this.lookup;
    }

    private void initNoStylesLabel() {
        this.noStylesLabel = new JLabel();
        this.noStylesLabel.setText(NbBundle.getMessage(CssStylesPanelProviderImpl.class, (String)"CssStylesPanelProviderImpl.noStylesLabel"));
        this.noStylesLabel.setHorizontalAlignment(0);
        this.noStylesLabel.setVerticalAlignment(0);
        this.noStylesLabel.setEnabled(false);
        this.noStylesLabel.setBackground(new BeanTreeView().getViewport().getView().getBackground());
        this.noStylesLabel.setOpaque(true);
    }

    private void initRunFilePanel() {
        this.runFilePanel = new JPanel();
        JLabel label = new JLabel(NbBundle.getMessage(CssStylesPanelProviderImpl.class, (String)"CssStylesPanelProviderImpl.runFileLabel"));
        label.setHorizontalAlignment(0);
        this.runButton = new JButton();
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Lookup context;
                ActionProvider provider;
                if (CssStylesPanelProviderImpl.this.lastRelatedFileObject != null && (provider = CssStylesPanelProviderImpl.actionProviderForFileObject(CssStylesPanelProviderImpl.this.lastRelatedFileObject)) != null && provider.isActionEnabled("run.single", context = Lookups.singleton((Object)CssStylesPanelProviderImpl.this.lastRelatedFileObject))) {
                    provider.invokeAction("run.single", context);
                }
            }
        });
        GroupLayout layout = new GroupLayout(this.runFilePanel);
        this.runFilePanel.setLayout(layout);
        layout.setVerticalGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(label).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.runButton).addContainerGap(-1, Short.MAX_VALUE));
        layout.setHorizontalGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(label, -1, -1, Short.MAX_VALUE).addComponent(this.runButton)).addContainerGap());
    }

    void update(FileObject fob) {
        this.lastRelatedFileObject = fob;
        this.update();
    }

    private void update() {
        if (EventQueue.isDispatchThread()) {
            PageModel pageModel = PageInspectorImpl.getDefault().getPage();
            if (pageModel != null && this.lastRelatedFileObject != null && this.lastRelatedFileObject.equals(this.inspectedFileObject)) {
                this.removeAll();
                PageModel.CSSStylesView stylesView = pageModel.getCSSStylesView();
                this.add((Component)stylesView.getView(), "Center");
                this.lookup.setView(pageModel.getCSSStylesView());
            } else {
                boolean runFilePanelShown;
                boolean noStylesLabelShown = this.noStylesLabel.getParent() != null;
                boolean bl = runFilePanelShown = this.runFilePanel.getParent() != null;
                if (this.lastRelatedFileObject == null ? !noStylesLabelShown : !runFilePanelShown) {
                    this.removeAll();
                    if (this.lastRelatedFileObject == null) {
                        this.add((Component)this.noStylesLabel, "Center");
                    } else {
                        this.add((Component)this.runFilePanel, "Center");
                    }
                }
                if (this.lastRelatedFileObject != null) {
                    String text = NbBundle.getMessage(CssStylesPanelProviderImpl.class, (String)"CssStylesPanelProviderImpl.runFileButton", (Object)this.lastRelatedFileObject.getNameExt());
                    this.runButton.setText(text);
                    boolean enabled = false;
                    ActionProvider provider = CssStylesPanelProviderImpl.actionProviderForFileObject(this.lastRelatedFileObject);
                    if (provider != null) {
                        Lookup context = Lookups.singleton((Object)this.lastRelatedFileObject);
                        enabled = provider.isActionEnabled("run.single", context);
                    }
                    this.runButton.setEnabled(enabled);
                }
                this.lookup.setView(null);
            }
            this.revalidate();
            this.repaint();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CssStylesPanelProviderImpl.this.update();
                }
            });
        }
    }

    void activateView() {
        this.active = true;
        if (this.currentPageModel != null) {
            this.currentPageModel.getCSSStylesView().activated();
        }
    }

    void deactivateView() {
        this.active = false;
        if (this.currentPageModel != null) {
            this.currentPageModel.getCSSStylesView().deactivated();
        }
    }

    private PropertyChangeListener createInspectorListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propName = evt.getPropertyName();
                if ("model".equals(propName)) {
                    PageModel pageModel = PageInspectorImpl.getDefault().getPage();
                    CssStylesPanelProviderImpl.this.update(pageModel);
                }
            }
        };
    }

    private void update(final PageModel pageModel) {
        this.currentPageModel = pageModel;
        if (pageModel instanceof WebKitPageModel) {
            if (EventQueue.isDispatchThread()) {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        CssStylesPanelProviderImpl.this.update(pageModel);
                    }
                });
                return;
            }
            final WebKitPageModel webKitPageModel = (WebKitPageModel)pageModel;
            FileObject fob = CssStylesPanelProviderImpl.inspectedFileObject(webKitPageModel, true);
            webKitPageModel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String propName = evt.getPropertyName();
                    if ("document".equals(propName) && webKitPageModel == CssStylesPanelProviderImpl.this.currentPageModel) {
                        FileObject fob = CssStylesPanelProviderImpl.inspectedFileObject(webKitPageModel, true);
                        if (fob != null) {
                            CssStylesPanelProviderImpl.this.inspectedFileObject = fob;
                        }
                        CssStylesPanelProviderImpl.this.update();
                    }
                }
            });
            if (fob != null) {
                this.inspectedFileObject = fob;
            }
            PageModel.CSSStylesView view = webKitPageModel.getCSSStylesView();
            if (this.active) {
                view.activated();
            } else {
                view.deactivated();
            }
        }
        this.update();
    }

    private static ActionProvider actionProviderForFileObject(FileObject fileObject) {
        ActionProvider provider = null;
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null) {
            Lookup lkp = project.getLookup();
            provider = (ActionProvider)lkp.lookup(ActionProvider.class);
        }
        return provider;
    }

    static FileObject inspectedFileObject(WebKitPageModel pageModel, boolean inInspectedProjectOnly) {
        try {
            Project project = pageModel.getProject();
            if (project != null) {
                String documentURL = pageModel.getDocumentURL();
                URL url = new URL(documentURL);
                FileObject fob = ServerURLMapping.fromServer((Project)project, (URL)url);
                if (inInspectedProjectOnly && fob != null && !project.equals(FileOwnerQuery.getOwner((FileObject)fob))) {
                    fob = null;
                }
                return fob;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    static class MatchedRulesLookup
    extends ProxyLookup {
        MatchedRulesLookup() {
        }

        void setView(PageModel.CSSStylesView view) {
            if (view == null) {
                this.setLookups(new Lookup[0]);
            } else {
                this.setLookups(new Lookup[]{view.getLookup()});
            }
        }
    }

    public static class WebCssStylesPanelListener
    implements CssStylesListener {
        public void ruleSelected(final Rule rule) {
            final PageModel pageModel = PageInspectorImpl.getDefault().getPage();
            if (pageModel != null && pageModel instanceof WebKitPageModel) {
                final WebKitPageModel wkPageModel = (WebKitPageModel)pageModel;
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        FileObject file = CssStylesPanelProviderImpl.inspectedFileObject(wkPageModel, false);
                        if (file != null) {
                            final Model model = rule.getModel();
                            model.runReadTask(new Model.ModelTask(){

                                public void run(StyleSheet styleSheet) {
                                    final String elementSource = ((Object)model.getElementSource((Element)rule.getSelectorsGroup())).toString();
                                    RP.post(new Runnable(){

                                        @Override
                                        public void run() {
                                            pageModel.setSelectedSelector(elementSource);
                                        }
                                    });
                                }
                            });
                        }
                    }
                });
            }
        }
    }

    public static class SelectionView
    extends CssStylesPanelProviderImpl {
        private static String SELECTION_PANEL_ID = "selection";
        private static Collection<String> MIME_TYPES = new HashSet<String>(Arrays.asList("text/html", "text/xhtml"));

        public String getPanelID() {
            return SELECTION_PANEL_ID;
        }

        public String getPanelDisplayName() {
            return Bundle.CTL_CssStylesProviderImpl_selection_view_title();
        }

        public JComponent getContent(Lookup lookup) {
            final Lookup.Result result = lookup.lookupResult(FileObject.class);
            result.addLookupListener(new LookupListener(){

                public void resultChanged(LookupEvent ev) {
                    SelectionView.this.update((Lookup.Result<FileObject>)result);
                }
            });
            this.update((Lookup.Result<FileObject>)result);
            return this;
        }

        void update(Lookup.Result<FileObject> result) {
            Collection fobs = result.allInstances();
            FileObject fob = null;
            if (!fobs.isEmpty()) {
                fob = (FileObject)fobs.iterator().next();
            }
            this.update(fob);
        }

        public Lookup getLookup() {
            return this.getMatchedRulesLookup();
        }

        public void activated() {
            this.activateView();
        }

        public void deactivated() {
            this.deactivateView();
        }

        public boolean providesContentFor(FileObject file) {
            Lookup lookup;
            ClientSideModule module;
            if (!MIME_TYPES.contains(file.getMIMEType())) {
                return false;
            }
            Project project = FileOwnerQuery.getOwner((FileObject)file);
            if (project != null && (module = (ClientSideModule)(lookup = project.getLookup()).lookup(ClientSideModule.class)) == null) {
                return false;
            }
            ActionProvider provider = CssStylesPanelProviderImpl.actionProviderForFileObject(file);
            if (provider == null) {
                return false;
            }
            Lookup context = Lookups.singleton((Object)file);
            return provider.isActionEnabled("run.single", context);
        }
    }
}

