/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.actions;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.common.api.ServerURLMapping;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class Resource {
    private String name;
    private Project project;

    public Resource(Project project, String name) {
        this.project = project;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Project getProject() {
        return this.project;
    }

    public FileObject toFileObject() {
        if (this.project != null) {
            try {
                return ServerURLMapping.fromServer((Project)this.project, (URL)new URL(this.name));
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
        }
        if (this.name == null || !this.name.startsWith("file://")) {
            return null;
        }
        try {
            URI uri = new URI(this.name);
            if (uri.getAuthority() != null || uri.getFragment() != null || uri.getQuery() != null) {
                uri = new URI(uri.getScheme(), null, uri.getPath(), null, null);
            }
            File file = new File(uri);
            file = FileUtil.normalizeFile((File)file);
            return FileUtil.toFileObject((File)file);
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(Resource.class.getName()).log(Level.INFO, null, ex);
            return null;
        }
    }
}

