/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.actions;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.actions.Openable;
import org.netbeans.modules.web.inspect.actions.Resource;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class OpenResourceAction
extends NodeAction {
    protected void performAction(Node[] activatedNodes) {
        for (int i = 0; i < activatedNodes.length; ++i) {
            Resource resource = (Resource)activatedNodes[i].getLookup().lookup(Resource.class);
            FileObject fob = resource.toFileObject();
            if (fob == null) continue;
            try {
                DataObject dob = DataObject.find((FileObject)fob);
                Openable openable = (Openable)dob.getLookup().lookup(Openable.class);
                if (openable == null) continue;
                openable.open();
                continue;
            }
            catch (DataObjectNotFoundException ex) {
                Logger.getLogger(OpenResourceAction.class.getName()).log(Level.INFO, null, ex);
            }
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes.length == 0) {
            return false;
        }
        for (int i = 0; i < activatedNodes.length; ++i) {
            Resource resource = (Resource)activatedNodes[i].getLookup().lookup(Resource.class);
            if (resource == null || resource.toFileObject() != null) continue;
            return false;
        }
        return true;
    }

    protected boolean asynchronous() {
        return true;
    }

    public String getName() {
        return NbBundle.getMessage(OpenResourceAction.class, (String)"OpenResourceAction.displayName");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

