/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.StyledDocument;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.UserQuestionException;

public class CSSUtils {
    private static final String[] vendorPropertyPrefixes = new String[]{"-moz-", "-webkit-", "-ms-", "-o-"};
    private static final List<String> inheritedProperties = Arrays.asList("azimuth", "border-collapse", "border-spacing", "caption-side", "color", "cursor", "direction", "elevation", "empty-cells", "font-family", "font-size", "font-style", "font-variant", "font-weight", "font", "letter-spacing", "line-height", "list-style-image", "list-style-position", "list-style-type", "list-style", "orphans", "pitch-range", "pitch", "quotes", "richness", "speak-header", "speak-numeral", "speak-punctuation", "speak", "speech-rate", "stress", "text-align", "text-indent", "text-transform", "text-shadow", "visibility", "voice-family", "volume", "white-space", "widows", "word-spacing");

    public static boolean isInheritedProperty(String name) {
        for (String propertyName : CSSUtils.possiblePropertyNames(name)) {
            if (!inheritedProperties.contains(propertyName)) continue;
            return true;
        }
        return false;
    }

    private static List<String> possiblePropertyNames(String name) {
        ArrayList<String> names = new ArrayList<String>();
        names.add(name);
        for (String prefix : vendorPropertyPrefixes) {
            if (!name.startsWith(prefix)) continue;
            String withoutPrefix = name.substring(prefix.length());
            names.add(withoutPrefix);
        }
        return names;
    }

    public static boolean isInheritValue(String value) {
        return value.trim().startsWith("inherit");
    }

    public static boolean open(FileObject fob, int offset) {
        try {
            DataObject dob = DataObject.find((FileObject)fob);
            Lookup dobLookup = dob.getLookup();
            EditorCookie ec = (EditorCookie)dobLookup.lookup(EditorCookie.class);
            LineCookie lc = (LineCookie)dobLookup.lookup(LineCookie.class);
            OpenCookie oc = (OpenCookie)dobLookup.lookup(OpenCookie.class);
            if (ec != null && lc != null && offset != -1) {
                StyledDocument doc;
                try {
                    doc = ec.openDocument();
                }
                catch (UserQuestionException uqe) {
                    String title = NbBundle.getMessage(CSSUtils.class, (String)"CSSUtils.openQuestion");
                    Object value = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)uqe.getLocalizedMessage(), title, 0));
                    if (value != NotifyDescriptor.YES_OPTION) {
                        return false;
                    }
                    uqe.confirmed();
                    doc = ec.openDocument();
                }
                if (doc != null) {
                    Line l;
                    int line = NbDocument.findLineNumber((StyledDocument)doc, (int)offset);
                    int lineOffset = NbDocument.findLineOffset((StyledDocument)doc, (int)line);
                    int column = offset - lineOffset;
                    if (line != -1 && (l = lc.getLineSet().getCurrent(line)) != null) {
                        l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, column);
                        return true;
                    }
                }
            }
            if (oc != null) {
                oc.open();
                return true;
            }
        }
        catch (IOException ioe) {
            Logger.getLogger(CSSUtils.class.getName()).log(Level.INFO, null, ioe);
        }
        return false;
    }

    public static String normalizeSelector(String selector) {
        selector = selector + 'A';
        String whitespaceChars = " \t\n\r\f";
        String specialChars = ".>+~#:*()[]|,";
        StringBuilder main = new StringBuilder();
        StringBuilder group = null;
        for (int i = 0; i < selector.length(); ++i) {
            boolean special;
            char c = selector.charAt(i);
            boolean whitespace = whitespaceChars.indexOf(c) != -1;
            boolean bl = special = specialChars.indexOf(c) != -1;
            if (whitespace || special) {
                if (group == null) {
                    group = new StringBuilder();
                }
                if (!special) continue;
                group.append(c);
                continue;
            }
            if (group != null) {
                if (group.length() == 0) {
                    main.append(' ');
                } else {
                    main.append((CharSequence)group);
                }
                group = null;
            }
            main.append(c);
        }
        return main.substring(0, main.length() - 1).trim();
    }

    public static String normalizeMediaQuery(String mediaQueryList) {
        mediaQueryList = mediaQueryList.trim().toLowerCase();
        StringBuilder result = new StringBuilder();
        StringTokenizer st = new StringTokenizer(mediaQueryList, ",");
        while (st.hasMoreTokens()) {
            int index;
            String mediaQuery = st.nextToken();
            ArrayList<String> parts = new ArrayList<String>();
            while ((index = mediaQuery.indexOf("and")) != -1) {
                String part = mediaQuery.substring(0, index);
                mediaQuery = mediaQuery.substring(index + 3);
                part = CSSUtils.normalizeSelector(part);
                parts.add(part);
            }
            mediaQuery = CSSUtils.normalizeSelector(mediaQuery);
            parts.add(mediaQuery);
            Collections.sort(parts);
            Collections.reverse(parts);
            for (int i = 0; i < parts.size(); ++i) {
                if (i != 0) {
                    result.append(" and ");
                }
                String part = (String)parts.get(i);
                result.append(part);
            }
            if (!st.hasMoreTokens()) continue;
            result.append(", ");
        }
        return result.toString();
    }
}

