/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.NativeFSLockFactory;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.openide.util.Parameters;

class RecordOwnerLockFactory
extends NativeFSLockFactory {
    private final Set<RecordOwnerLock> locked = Collections.newSetFromMap(new IdentityHashMap());
    private Thread owner;
    private Exception caller;

    RecordOwnerLockFactory() throws IOException {
    }

    @CheckForNull
    Thread getOwner() {
        return this.owner;
    }

    @CheckForNull
    Exception getCaller() {
        return this.caller;
    }

    synchronized void forceRemoveLocks() throws IOException {
        ArrayList<RecordOwnerLock> safeIt = new ArrayList<RecordOwnerLock>(this.locked);
        Throwable cause = null;
        for (RecordOwnerLock l : safeIt) {
            try {
                l.release();
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                if (cause != null) continue;
                cause = t;
            }
        }
        if (cause != null) {
            throw new IOException(cause);
        }
    }

    public Lock makeLock(String lockName) {
        return new RecordOwnerLock(super.makeLock(lockName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLock(String lockName) throws IOException {
        super.clearLock(lockName);
        RecordOwnerLockFactory recordOwnerLockFactory = this;
        synchronized (recordOwnerLockFactory) {
            this.owner = null;
            this.caller = null;
        }
    }

    private synchronized void recordOwner(@NonNull Thread t, @NonNull RecordOwnerLock l) {
        Parameters.notNull((CharSequence)"t", (Object)t);
        Parameters.notNull((CharSequence)"l", (Object)((Object)l));
        if (this.owner != t) {
            this.owner = t;
            this.caller = new Exception();
        }
        this.locked.add(l);
    }

    private synchronized void clearOwner(@NonNull RecordOwnerLock l) {
        Parameters.notNull((CharSequence)"l", (Object)((Object)l));
        this.locked.remove((Object)l);
        this.owner = null;
        this.caller = null;
    }

    private class RecordOwnerLock
    extends Lock {
        private final Lock delegate;

        private RecordOwnerLock(Lock delegate) {
            assert (delegate != null);
            this.delegate = delegate;
        }

        public boolean obtain() throws IOException {
            boolean result = this.delegate.obtain();
            if (result) {
                RecordOwnerLockFactory.this.recordOwner(Thread.currentThread(), this);
            }
            return result;
        }

        public void release() throws IOException {
            this.delegate.release();
            RecordOwnerLockFactory.this.clearOwner(this);
        }

        public boolean isLocked() throws IOException {
            return this.delegate.isLocked();
        }
    }
}

