/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.search.Query;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.parsing.lucene.Convertors;
import org.netbeans.modules.parsing.lucene.IndexDocumentImpl;
import org.netbeans.modules.parsing.lucene.support.Convertor;
import org.netbeans.modules.parsing.lucene.support.DocumentIndex;
import org.netbeans.modules.parsing.lucene.support.DocumentIndexCache;
import org.netbeans.modules.parsing.lucene.support.Index;
import org.netbeans.modules.parsing.lucene.support.IndexDocument;
import org.netbeans.modules.parsing.lucene.support.Queries;

public class DocumentIndexImpl
implements DocumentIndex,
Runnable {
    private final Index luceneIndex;
    private final DocumentIndexCache cache;
    final Index.Transactional txLuceneIndex;
    private static final Convertor<IndexDocument, Document> ADD_CONVERTOR = Convertors.newIndexDocumentToDocumentConvertor();
    private static final Convertor<String, Query> REMOVE_CONVERTOR = Convertors.newSourceNameToQueryConvertor();
    private static final Convertor<Document, IndexDocumentImpl> QUERY_CONVERTOR = Convertors.newDocumentToIndexDocumentConvertor();
    private static final Logger LOGGER = Logger.getLogger(DocumentIndexImpl.class.getName());
    private final Set<String> dirtyKeys = new HashSet<String>();
    final AtomicBoolean requiresRollBack = new AtomicBoolean();

    private DocumentIndexImpl(@NonNull Index index, @NonNull DocumentIndexCache cache) {
        assert (index != null);
        assert (cache != null);
        this.luceneIndex = index;
        this.cache = cache;
        this.txLuceneIndex = index instanceof Index.Transactional ? (Index.Transactional)index : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDocument(IndexDocument document) {
        boolean forceFlush;
        DocumentIndexImpl documentIndexImpl = this;
        synchronized (documentIndexImpl) {
            forceFlush = this.cache.addDocument(document);
        }
        if (forceFlush) {
            try {
                LOGGER.fine("Extra flush forced");
                this.store(false, true);
                System.gc();
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, ioe.getMessage());
                this.requiresRollBack.set(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDocument(String primaryKey) {
        boolean forceFlush;
        DocumentIndexImpl documentIndexImpl = this;
        synchronized (documentIndexImpl) {
            forceFlush = this.cache.removeDocument(primaryKey);
        }
        if (forceFlush) {
            try {
                LOGGER.fine("Extra flush forced");
                this.store(false, true);
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, ioe.getMessage());
                this.requiresRollBack.set(true);
            }
        }
    }

    @Override
    public Index.Status getStatus() throws IOException {
        return this.luceneIndex.getStatus(true);
    }

    @Override
    public void close() throws IOException {
        this.luceneIndex.close();
    }

    @Override
    public void store(boolean optimize) throws IOException {
        this.checkRollBackNeeded();
        this.store(optimize, false);
    }

    @Override
    public void run() {
        if (this.luceneIndex instanceof Runnable) {
            ((Runnable)((Object)this.luceneIndex)).run();
        }
    }

    private void store(boolean optimize, boolean flushOnly) throws IOException {
        boolean change = this.storeImpl(optimize, flushOnly);
        if (!change && !flushOnly && this.txLuceneIndex != null) {
            this.commitImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean storeImpl(boolean optimize, boolean flushOnly) throws IOException {
        Collection<? extends String> _toRemove;
        Collection<? extends IndexDocument> _toAdd;
        DocumentIndexImpl documentIndexImpl = this;
        synchronized (documentIndexImpl) {
            _toAdd = this.cache.getAddedDocuments();
            _toRemove = this.cache.getRemovedKeys();
            this.cache.clear();
            if (!this.dirtyKeys.isEmpty()) {
                for (IndexDocument indexDocument : _toAdd) {
                    this.dirtyKeys.remove(indexDocument.getPrimaryKey());
                }
                this.dirtyKeys.removeAll(_toRemove);
            }
        }
        if (!_toAdd.isEmpty() || !_toRemove.isEmpty()) {
            LOGGER.log(Level.FINE, "Flushing: {0}", this.luceneIndex.toString());
            if (flushOnly && this.txLuceneIndex != null) {
                this.txLuceneIndex.txStore(_toAdd, _toRemove, ADD_CONVERTOR, REMOVE_CONVERTOR);
            } else {
                this.luceneIndex.store(_toAdd, _toRemove, ADD_CONVERTOR, REMOVE_CONVERTOR, optimize);
            }
            return true;
        }
        return false;
    }

    private void commitImpl() throws IOException {
        this.checkRollBackNeeded();
        this.txLuceneIndex.commit();
    }

    private void checkRollBackNeeded() throws IOException {
        if (this.requiresRollBack.get()) {
            throw new IOException("Index requires rollback.");
        }
    }

    @Override
    public Collection<? extends IndexDocument> query(String fieldName, String value, Queries.QueryKind kind, String ... fieldsToLoad) throws IOException, InterruptedException {
        assert (fieldName != null);
        assert (value != null);
        assert (kind != null);
        LinkedList result = new LinkedList();
        Query query = Queries.createQuery(fieldName, fieldName, value, kind);
        FieldSelector selector = null;
        if (fieldsToLoad != null && fieldsToLoad.length > 0) {
            String[] fieldsWithSource = new String[fieldsToLoad.length + 1];
            System.arraycopy(fieldsToLoad, 0, fieldsWithSource, 0, fieldsToLoad.length);
            fieldsWithSource[fieldsToLoad.length] = "_sn";
            selector = Queries.createFieldSelector(fieldsWithSource);
        }
        this.luceneIndex.query(result, QUERY_CONVERTOR, selector, null, query);
        return result;
    }

    @Override
    public Collection<? extends IndexDocument> findByPrimaryKey(String primaryKeyValue, Queries.QueryKind kind, String ... fieldsToLoad) throws IOException, InterruptedException {
        return this.query("_sn", primaryKeyValue, kind, fieldsToLoad);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markKeyDirty(String primaryKey) {
        DocumentIndexImpl documentIndexImpl = this;
        synchronized (documentIndexImpl) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "{0}, adding dirty key: {1}", new Object[]{this, primaryKey});
            }
            this.dirtyKeys.add(primaryKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDirtyKeys(Collection<? extends String> keysToRemove) {
        DocumentIndexImpl documentIndexImpl = this;
        synchronized (documentIndexImpl) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "{0}, Removing dirty keys: {1}", new Object[]{this, keysToRemove});
            }
            this.dirtyKeys.removeAll(keysToRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<? extends String> getDirtyKeys() {
        DocumentIndexImpl documentIndexImpl = this;
        synchronized (documentIndexImpl) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "{0}, dirty keys: {1}", new Object[]{this, this.dirtyKeys});
            }
            return new ArrayList<String>(this.dirtyKeys);
        }
    }

    public String toString() {
        return "DocumentIndex[" + this.luceneIndex.toString() + "]";
    }

    @NonNull
    public static DocumentIndex create(@NonNull Index index, @NonNull DocumentIndexCache cache) {
        return new DocumentIndexImpl(index, cache);
    }

    @NonNull
    public static DocumentIndex.Transactional createTransactional(@NonNull Index.Transactional index, @NonNull DocumentIndexCache cache) {
        return new Transactional(index, cache);
    }

    private static final class Transactional
    extends DocumentIndexImpl
    implements DocumentIndex.Transactional {
        private Transactional(@NonNull Index.Transactional index, @NonNull DocumentIndexCache cache) {
            super(index, cache);
        }

        @Override
        public void txStore() throws IOException {
            ((DocumentIndexImpl)this).storeImpl(false, true);
        }

        @Override
        public void commit() throws IOException {
            ((DocumentIndexImpl)this).commitImpl();
        }

        @Override
        public void rollback() throws IOException {
            this.requiresRollBack.set(false);
            this.txLuceneIndex.rollback();
        }

        @Override
        public void clear() throws IOException {
            this.requiresRollBack.set(false);
            this.txLuceneIndex.clear();
        }

        @Override
        public String toString() {
            return "DocumentIndex.Transactional [" + ((DocumentIndexImpl)this).luceneIndex.toString() + "]";
        }
    }
}

