/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support.hostinfo.impl;

import com.jcraft.jsch.JSchException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.ConnectionManagerAccessor;
import org.netbeans.modules.nativeexecution.JschSupport;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.api.util.RemoteStatistics;
import org.netbeans.modules.nativeexecution.pty.NbStartUtility;
import org.netbeans.modules.nativeexecution.support.EnvReader;
import org.netbeans.modules.nativeexecution.support.InstalledFileLocatorProvider;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.hostinfo.HostInfoProvider;
import org.netbeans.modules.nativeexecution.support.hostinfo.impl.HostInfoFactory;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public class UnixHostInfoProvider
implements HostInfoProvider {
    private static final String TMPBASE = System.getProperty("cnd.tmpbase", null);
    private static final String PATH_VAR = "PATH";
    private static final String PATH_TO_PREPEND = "/bin:/usr/bin";
    private static final java.util.logging.Logger log = Logger.getInstance();
    private static final File hostinfoScript;

    @Override
    public HostInfo getHostInfo(ExecutionEnvironment execEnv) throws IOException {
        if (hostinfoScript == null) {
            return null;
        }
        boolean isLocal = execEnv.isLocal();
        if (isLocal && Utilities.isWindows()) {
            return null;
        }
        Properties info = execEnv.isLocal() ? this.getLocalHostInfo() : this.getRemoteHostInfo(execEnv);
        HashMap<String, String> environment = new HashMap<String, String>();
        HostInfo result = HostInfoFactory.newHostInfo(execEnv, info, environment);
        if (execEnv.isLocal()) {
            this.getLocalUserEnvironment(result, environment);
        } else {
            this.getRemoteUserEnvironment(execEnv, result, environment);
        }
        String path = PATH_TO_PREPEND;
        if (environment.containsKey(PATH_VAR)) {
            path = path + ":" + (String)environment.get(PATH_VAR);
        }
        environment.put(PATH_VAR, path);
        return result;
    }

    private Properties getLocalHostInfo() throws IOException {
        Properties hostInfo = new Properties();
        try {
            ProcessBuilder pb = new ProcessBuilder("/bin/sh", hostinfoScript.getAbsolutePath());
            String tmpDirBase = null;
            if (TMPBASE != null) {
                if (this.pathIsOK(TMPBASE, false)) {
                    tmpDirBase = TMPBASE;
                } else {
                    log.log(Level.WARNING, "Ignoring cnd.tmpbase property [{0}] as it contains illegal characters", TMPBASE);
                }
            }
            if (tmpDirBase == null) {
                File tmpDirFile = new File(System.getProperty("java.io.tmpdir"));
                tmpDirBase = tmpDirFile.getCanonicalPath();
            }
            pb.environment().put("TMPBASE", tmpDirBase);
            pb.environment().put("NB_KEY", HostInfoFactory.getNBKey());
            Process hostinfoProcess = pb.start();
            List<String> errorLines = ProcessUtils.readProcessError(hostinfoProcess);
            int result = hostinfoProcess.waitFor();
            for (String errLine : errorLines) {
                log.log(Level.WARNING, "UnixHostInfoProvider: {0}", errLine);
            }
            if (result != 0) {
                throw new IOException(hostinfoScript + " rc == " + result);
            }
            this.fillProperties(hostInfo, hostinfoProcess.getInputStream());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IOException("HostInfo receiving for localhost interrupted " + ex);
        }
        return hostInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getRemoteHostInfo(ExecutionEnvironment execEnv) throws IOException {
        Properties hostInfo = new Properties();
        JschSupport.ChannelStreams sh_channels = null;
        try {
            String errLine;
            sh_channels = JschSupport.startCommand(execEnv, "/bin/sh -s", null);
            long localStartTime = System.currentTimeMillis();
            OutputStream out = sh_channels.in;
            InputStream err = sh_channels.err;
            InputStream in = sh_channels.out;
            out.write(("NB_KEY=" + HostInfoFactory.getNBKey() + '\n').getBytes());
            if (TMPBASE != null) {
                if (this.pathIsOK(TMPBASE, true)) {
                    out.write(("TMPBASE=" + TMPBASE + '\n').getBytes());
                } else {
                    log.log(Level.WARNING, "Ignoring cnd.tmpbase property [{0}] as it contains illegal characters", TMPBASE);
                }
            }
            out.flush();
            BufferedReader scriptReader = new BufferedReader(new FileReader(hostinfoScript));
            String scriptLine = scriptReader.readLine();
            while (scriptLine != null) {
                out.write((scriptLine + '\n').getBytes());
                out.flush();
                scriptLine = scriptReader.readLine();
            }
            scriptReader.close();
            BufferedReader errReader = new BufferedReader(new InputStreamReader(err));
            while ((errLine = errReader.readLine()) != null) {
                log.log(Level.WARNING, "UnixHostInfoProvider: {0}", errLine);
            }
            this.fillProperties(hostInfo, in);
            long localEndTime = System.currentTimeMillis();
            hostInfo.put("LOCALTIME", (Object)((localStartTime + localEndTime) / 2L));
        }
        catch (JSchException ex) {
            throw new IOException("Exception while receiving HostInfo for " + ((Object)execEnv).toString() + ": " + (Object)((Object)ex));
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (sh_channels != null && sh_channels.channel != null) {
                try {
                    ConnectionManagerAccessor.getDefault().closeAndReleaseChannel(execEnv, sh_channels.channel);
                }
                catch (JSchException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return hostInfo;
    }

    private void fillProperties(Properties hostInfo, InputStream inputStream) {
        try {
            String s;
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
            while ((s = br.readLine()) != null) {
                String[] data = s.split("=", 2);
                if (data.length != 2) continue;
                hostInfo.put(data[0], data[1]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getRemoteUserEnvironment(ExecutionEnvironment execEnv, HostInfo hostInfo, Map<String, String> environmentToFill) {
        JschSupport.ChannelStreams login_shell_channels;
        block17: {
            String nbstart = null;
            try {
                nbstart = NbStartUtility.getInstance().getPath(execEnv, hostInfo);
            }
            catch (IOException ex) {
                log.log(Level.WARNING, "Failed to get remote path of NbStartUtility", ex);
                Exceptions.printStackTrace((Throwable)ex);
            }
            String envPath = hostInfo.getEnvironmentFile();
            login_shell_channels = null;
            Object activityID = null;
            try {
                login_shell_channels = JschSupport.startLoginShellSession(execEnv);
                activityID = RemoteStatistics.stratChannelActivity("UnixHostInfoProvider", login_shell_channels.channel, execEnv.getDisplayName());
                if (nbstart != null && envPath != null) {
                    login_shell_channels.in.write((nbstart + " --dumpenv " + envPath + "\n").getBytes());
                }
                login_shell_channels.in.write("/usr/bin/env || /bin/env\n".getBytes());
                login_shell_channels.in.flush();
                login_shell_channels.in.close();
                EnvReader reader = new EnvReader(login_shell_channels.out, true);
                environmentToFill.putAll((Map<String, String>)reader.call());
                if (activityID == null) break block17;
            }
            catch (Exception ex) {
                block18: {
                    try {
                        log.log(Level.WARNING, "Failed to get getRemoteUserEnvironment for " + execEnv.getDisplayName(), ex);
                        if (activityID == null) break block18;
                    }
                    catch (Throwable throwable) {
                        if (activityID != null) {
                            RemoteStatistics.stopChannelActivity(activityID);
                        }
                        if (login_shell_channels != null && login_shell_channels.channel != null) {
                            try {
                                ConnectionManagerAccessor.getDefault().closeAndReleaseChannel(execEnv, login_shell_channels.channel);
                            }
                            catch (JSchException ex2) {
                                Exceptions.printStackTrace((Throwable)ex2);
                            }
                        }
                        throw throwable;
                    }
                    RemoteStatistics.stopChannelActivity(activityID);
                }
                if (login_shell_channels != null && login_shell_channels.channel != null) {
                    try {
                        ConnectionManagerAccessor.getDefault().closeAndReleaseChannel(execEnv, login_shell_channels.channel);
                    }
                    catch (JSchException ex3) {
                        Exceptions.printStackTrace((Throwable)ex3);
                    }
                }
            }
            RemoteStatistics.stopChannelActivity(activityID);
        }
        if (login_shell_channels != null && login_shell_channels.channel != null) {
            try {
                ConnectionManagerAccessor.getDefault().closeAndReleaseChannel(execEnv, login_shell_channels.channel);
            }
            catch (JSchException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void getLocalUserEnvironment(HostInfo hostInfo, Map<String, String> environmentToFill) {
        environmentToFill.putAll(System.getenv());
    }

    private boolean pathIsOK(String path, boolean remote) {
        for (char c : path.toCharArray()) {
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '=' || remote && c == '\\' || !remote && c == File.pathSeparatorChar || c == ':' && !remote && Utilities.isWindows()) continue;
            return false;
        }
        return true;
    }

    static {
        InstalledFileLocator fl = InstalledFileLocatorProvider.getDefault();
        hostinfoScript = fl.locate("bin/nativeexecution/hostinfo.sh", "org.netbeans.modules.dlight.nativeexecution", false);
        if (hostinfoScript == null) {
            log.severe("Unable to find hostinfo.sh script!");
        }
    }
}

