/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import com.jcraft.jsch.Channel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.modules.nativeexecution.api.util.RemoteMeasurements;
import org.netbeans.modules.nativeexecution.jsch.MeasurableSocketFactory;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public final class RemoteStatistics
implements Callable<Boolean> {
    public static final boolean COLLECT_STATISTICS = Boolean.parseBoolean(System.getProperty("jsch.statistics", "false"));
    public static final boolean COLLECT_STACKS = COLLECT_STATISTICS && Boolean.parseBoolean(System.getProperty("jsch.statistics.stacks", "false"));
    private static final TrafficCounters trafficCounters = new TrafficCounters();
    private static final RemoteMeasurementsRef unnamed = new RemoteMeasurementsRef("uncategorized", new RemoteMeasurements("uncategorized"), null, 0);
    private static final AtomicReference<RemoteMeasurementsRef> currentStatRef = new AtomicReference<RemoteMeasurementsRef>(unnamed);
    private static final BlockingQueue<RequestProcessor.Task> queue = new ArrayBlockingQueue<RequestProcessor.Task>(1);
    private static final RemoteIOListener listener = new RemoteIOListener();
    private static final AtomicBoolean trafficDetected = new AtomicBoolean();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startTest(String description, final Runnable continuation, int quietPrePeriodMillis, int quietPostPeriodMillis) {
        if (!COLLECT_STATISTICS) {
            if (continuation != null) {
                continuation.run();
            }
            return;
        }
        RequestProcessor.Task newTask = RequestProcessor.getDefault().create(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    RemoteStatistics.stopAction();
                    queue.poll();
                }
                finally {
                    if (continuation != null) {
                        continuation.run();
                    }
                }
            }
        });
        try {
            queue.put(newTask);
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        while (true) {
            AtomicBoolean atomicBoolean = trafficDetected;
            synchronized (atomicBoolean) {
                try {
                    trafficDetected.wait(quietPrePeriodMillis);
                    if (!trafficDetected.getAndSet(false)) {
                    }
                }
                catch (InterruptedException ex) {}
                break;
            }
        }
        newTask.schedule(quietPostPeriodMillis);
        currentStatRef.set(new RemoteMeasurementsRef(description, new RemoteMeasurements(description), newTask, quietPostPeriodMillis));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean stopAction() {
        RemoteMeasurementsRef stopped = currentStatRef.getAndSet(unnamed);
        PrintStream output = RemoteStatistics.getOutput(stopped.name);
        try {
            stopped.stat.dump(output);
        }
        finally {
            if (!output.equals(System.out)) {
                output.close();
            }
        }
        return unnamed.equals(stopped);
    }

    public static Object stratChannelActivity(CharSequence category, Channel channel, CharSequence ... args) {
        if (!COLLECT_STATISTICS) {
            return null;
        }
        return currentStatRef.get().stat.stratChannelActivity(category, channel, args);
    }

    public static void stopChannelActivity(Object activityID) {
        if (!COLLECT_STATISTICS) {
            return;
        }
        currentStatRef.get().stat.stopChannelActivity(activityID);
    }

    private static RemoteMeasurementsRef reschedule() {
        RemoteMeasurementsRef ref = currentStatRef.get();
        if (ref.task != null) {
            ref.task.schedule(ref.quietPostPeriodMillis);
        }
        return ref;
    }

    private static PrintStream getOutput(String name) {
        String OUTPUT;
        String string = OUTPUT = COLLECT_STATISTICS ? System.getProperty("jsch.statistics.output", null) : null;
        if (OUTPUT == null) {
            return System.out;
        }
        File dir = new File(OUTPUT);
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(OUTPUT + " is not a directory!");
        }
        if (!dir.canWrite()) {
            throw new IllegalArgumentException(OUTPUT + " is not writable!");
        }
        try {
            return new PrintStream(new File(dir, name));
        }
        catch (FileNotFoundException ex) {
            throw new IllegalArgumentException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() throws Exception {
        if (COLLECT_STATISTICS) {
            while (!RemoteStatistics.stopAction()) {
            }
            PrintStream output = RemoteStatistics.getOutput("totalTraffic");
            try {
                RemoteStatistics.trafficCounters.dump(output);
            }
            finally {
                if (!output.equals(System.out)) {
                    output.close();
                }
            }
        }
        return true;
    }

    static {
        if (COLLECT_STATISTICS) {
            MeasurableSocketFactory.getInstance().addIOListener(listener);
        }
    }

    private static class RemoteMeasurementsRef {
        private final String name;
        private final int quietPostPeriodMillis;
        private final RequestProcessor.Task task;
        private final RemoteMeasurements stat;

        public RemoteMeasurementsRef(String name, RemoteMeasurements stat, RequestProcessor.Task task, int quietPostPeriodMillis) {
            this.name = name + "_" + System.currentTimeMillis();
            this.task = task;
            this.stat = stat;
            this.quietPostPeriodMillis = quietPostPeriodMillis;
        }
    }

    private static class RemoteIOListener
    implements MeasurableSocketFactory.IOListener {
        private RemoteIOListener() {
        }

        @Override
        public void bytesUploaded(int bytes) {
            RemoteMeasurementsRef stat = RemoteStatistics.reschedule();
            stat.stat.bytesUploaded(bytes);
        }

        @Override
        public void bytesDownloaded(int bytes) {
            RemoteMeasurementsRef stat = RemoteStatistics.reschedule();
            stat.stat.bytesDownloaded(bytes);
        }
    }

    private static class TrafficCounters {
        private final AtomicLong up = new AtomicLong();
        private final AtomicLong down = new AtomicLong();

        public TrafficCounters() {
            if (!COLLECT_STATISTICS) {
                return;
            }
            MeasurableSocketFactory.getInstance().addIOListener(new MeasurableSocketFactory.IOListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void bytesUploaded(int bytes) {
                    TrafficCounters.this.up.addAndGet(bytes);
                    AtomicBoolean atomicBoolean = trafficDetected;
                    synchronized (atomicBoolean) {
                        trafficDetected.set(true);
                        trafficDetected.notifyAll();
                    }
                    RemoteStatistics.reschedule();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void bytesDownloaded(int bytes) {
                    TrafficCounters.this.down.addAndGet(bytes);
                    AtomicBoolean atomicBoolean = trafficDetected;
                    synchronized (atomicBoolean) {
                        trafficDetected.set(true);
                        trafficDetected.notifyAll();
                    }
                    RemoteStatistics.reschedule();
                }
            });
        }

        private void dump(PrintStream out) {
            out.println("Total upload traffic [bytes]: " + this.up.get());
            out.println("Total download traffic [bytes]: " + this.down.get());
        }
    }
}

