/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import com.jcraft.jsch.Channel;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.netbeans.modules.nativeexecution.api.util.RemoteStatistics;

public final class RemoteMeasurements {
    private static final ConcurrentHashMap<Integer, String> stacks = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, Stat> stats = new ConcurrentHashMap();
    private final AtomicLong upTraffic = new AtomicLong();
    private final AtomicLong downTraffic = new AtomicLong();
    private final String name;
    private final long startWallTime;

    RemoteMeasurements(String name) {
        this.name = name;
        this.startWallTime = System.currentTimeMillis();
    }

    public Object stratChannelActivity(CharSequence category, Channel channel, CharSequence ... args) {
        Stat stat = new Stat(category, args);
        int hashCode = stat.hashCode();
        Stat prevStat = this.stats.putIfAbsent(hashCode, stat);
        if (prevStat != null) {
            stat = prevStat;
        }
        stat.count.incrementAndGet();
        return new StatKey(hashCode, System.currentTimeMillis());
    }

    public void stopChannelActivity(Object activityID) {
        StatKey key = (StatKey)activityID;
        Stat stat = this.stats.get(key.statID);
        assert (stat != null);
        stat.deltaTime.addAndGet(System.currentTimeMillis() - key.startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(PrintStream out) {
        try {
            this.dumpTrafficStatistics(out);
            this.dumpCategoriesStatistics(out);
            this.dumpCategoriesArgsStatistics(out);
            this.dumpCategoriesStacksStatistics(out);
        }
        finally {
            out.println("Total wall time '" + this.name + "' [ms]: " + (System.currentTimeMillis() - this.startWallTime));
        }
    }

    private void dumpTrafficStatistics(PrintStream out) {
        out.println("Upload traffic '" + this.name + "' [bytes]: " + this.upTraffic.get());
        out.println("Download traffic '" + this.name + "' [bytes]: " + this.downTraffic.get());
    }

    private void dumpCategoriesArgsStatistics(PrintStream out) {
        HashMap<String, Counters> data = new HashMap<String, Counters>();
        for (Stat stat : this.stats.values()) {
            String string = stat.category + "%" + Arrays.toString(stat.args);
            Counters counters = (Counters)data.get(string);
            if (counters == null) {
                counters = new Counters();
                data.put(string, counters);
            }
            counters.cnt1.addAndGet(stat.count.get());
            counters.cnt2.addAndGet(stat.deltaTime.get());
        }
        out.println("== Arguments statistics start ==");
        out.println("Category|Count|Time|Args");
        LinkedList dataList = new LinkedList(data.entrySet());
        Collections.sort(dataList, new CategoriesStatComparator());
        for (Map.Entry entry : dataList) {
            String cat = (String)entry.getKey();
            int idx = cat.indexOf(37);
            Counters cnts = (Counters)entry.getValue();
            out.println(cat.substring(0, idx) + "|" + cnts.cnt1 + "|" + cnts.cnt2 + "|" + cat.substring(idx + 1));
        }
        out.println("== Arguments statistics end ==");
    }

    private void dumpCategoriesStacksStatistics(PrintStream out) {
        HashMap<String, Counters> data = new HashMap<String, Counters>();
        for (Stat stat : this.stats.values()) {
            String string = stat.stackID + "%" + stat.category;
            Counters counters = (Counters)data.get(string);
            if (counters == null) {
                counters = new Counters();
                data.put(string, counters);
            }
            counters.cnt1.addAndGet(stat.count.get());
            counters.cnt2.addAndGet(stat.deltaTime.get());
        }
        out.println("== Categories stacks statistics start ==");
        out.println("Category|Count|Time|Stack");
        LinkedList dataList = new LinkedList(data.entrySet());
        Collections.sort(dataList, new CategoriesStatComparator());
        for (Map.Entry entry : dataList) {
            String cat = (String)entry.getKey();
            int idx = cat.indexOf(37);
            Counters cnts = (Counters)entry.getValue();
            Integer stackID = Integer.valueOf(cat.substring(0, idx));
            String category = cat.substring(idx + 1);
            out.println(category + "|" + cnts.cnt1 + "|" + cnts.cnt2 + "|" + stacks.get(stackID));
        }
        out.println("== Categories stacks statistics end ==");
    }

    private void dumpCategoriesStatistics(PrintStream out) {
        long totalTime = 0L;
        HashMap<String, Counters> map = new HashMap<String, Counters>();
        for (Stat stat : this.stats.values()) {
            Counters counters = (Counters)map.get(stat.category);
            if (counters == null) {
                counters = new Counters();
                map.put(stat.category, counters);
            }
            counters.cnt1.addAndGet(stat.count.get());
            counters.cnt2.addAndGet(stat.deltaTime.get());
            counters.cnt3.add(Arrays.deepHashCode(stat.args));
        }
        out.println("== Categories stat begin ==");
        out.println("Category|Count|Time|Unique args");
        for (Map.Entry entry : map.entrySet()) {
            long dt = ((Counters)entry.getValue()).cnt2.get();
            out.println((String)entry.getKey() + "|" + ((Counters)entry.getValue()).cnt1 + "|" + dt + "|" + ((Counters)entry.getValue()).cnt3.size());
            totalTime += dt;
        }
        out.println("== Categories stat end ==");
        out.println("Total time by all categories [ms]: " + totalTime);
    }

    private static int getStackID() {
        if (!RemoteStatistics.COLLECT_STACKS) {
            return -1;
        }
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (stackTrace != null) {
            String prevFile = null;
            for (int i = stackTrace.length - 1; i >= 0; --i) {
                StackTraceElement st = stackTrace[i];
                String filename = st.getFileName();
                String curFile = filename.substring(0, filename.lastIndexOf(46));
                sb.append(curFile.equals(prevFile) ? "" : curFile).append(':').append(st.getLineNumber()).append(';');
                prevFile = curFile;
                String className = st.getClassName();
                if (!className.startsWith("com.jcraft.jsch")) continue;
                sb.append("...");
                break;
            }
        }
        String stack = sb.toString();
        Integer stackID = stack.hashCode();
        stacks.putIfAbsent(stackID, stack);
        return stackID;
    }

    void bytesUploaded(int bytes) {
        this.upTraffic.addAndGet(bytes);
    }

    void bytesDownloaded(int bytes) {
        this.downTraffic.addAndGet(bytes);
    }

    private static final class StatKey {
        private final int statID;
        private final long startTime;

        private StatKey(int statID, long startTime) {
            this.statID = statID;
            this.startTime = startTime;
        }
    }

    private static class CategoriesStatComparator
    implements Comparator<Map.Entry<String, Counters>> {
        private CategoriesStatComparator() {
        }

        @Override
        public int compare(Map.Entry<String, Counters> o1, Map.Entry<String, Counters> o2) {
            long o2Val;
            String s1 = o1.getKey();
            String s2 = o2.getKey();
            int idx1 = s1.indexOf(37);
            int idx2 = s2.indexOf(37);
            int cmp = s1.substring(0, idx1).compareTo(s2.substring(0, idx2));
            if (cmp != 0) {
                return cmp;
            }
            long o1Val = o1.getValue().cnt2.get();
            return o1Val < (o2Val = o2.getValue().cnt2.get()) ? 1 : (o1Val == o2Val ? 0 : -1);
        }
    }

    private static final class Counters {
        private final AtomicLong cnt1 = new AtomicLong();
        private final AtomicLong cnt2 = new AtomicLong();
        private final HashSet<Integer> cnt3 = new HashSet();

        private Counters() {
        }
    }

    private static final class Stat {
        private final String category;
        private final String[] args;
        private final int stackID;
        private final AtomicLong deltaTime = new AtomicLong(0L);
        private final AtomicLong count = new AtomicLong(0L);

        public Stat(CharSequence category, CharSequence ... args) {
            this.stackID = RemoteMeasurements.getStackID();
            this.category = ((Object)category).toString();
            if (args == null) {
                this.args = null;
            } else {
                this.args = new String[args.length];
                int i = 0;
                for (CharSequence arg : args) {
                    this.args[i++] = ((Object)arg).toString();
                }
            }
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Stat other = (Stat)obj;
            if (this.stackID != other.stackID) {
                return false;
            }
            if (this.category == null ? other.category != null : !this.category.equals(other.category)) {
                return false;
            }
            return Arrays.deepEquals(this.args, other.args);
        }

        public int hashCode() {
            int hash = 7;
            hash = 79 * hash + this.stackID;
            hash = 79 * hash + (this.category != null ? this.category.hashCode() : 0);
            hash = 79 * hash + Arrays.deepHashCode(this.args);
            return hash;
        }
    }
}

