/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.BufferedReader;
import java.io.IOException;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.openide.util.Exceptions;

public class PathUtils {
    private PathUtils() {
    }

    public static String getPathFromSymlink(String path, ExecutionEnvironment execEnv) {
        try {
            int pos;
            NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder(execEnv);
            npb.setExecutable("/bin/ls").setArguments("-l", path).redirectError();
            NativeProcess process = npb.call();
            BufferedReader br = ProcessUtils.getReader(process.getInputStream(), execEnv.isRemote());
            String line = br.readLine();
            br.close();
            if (line != null && (pos = line.indexOf("->")) > 0) {
                return line.substring(pos + 2).trim();
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    public static String getExePath(long pid, ExecutionEnvironment execEnv) {
        if (pid > 0L) {
            String procdir = "/proc/" + Long.toString(pid);
            String path = PathUtils.getPathFromSymlink(procdir + "/path/a.out", execEnv);
            if (path == null) {
                path = PathUtils.getPathFromSymlink(procdir + "/exe", execEnv);
            }
            if (path != null && path.length() > 0) {
                return path;
            }
        }
        return null;
    }

    public static String getCwdPath(long pid, ExecutionEnvironment execEnv) {
        String procdir;
        String path;
        if (pid > 0L && (path = PathUtils.getPathFromSymlink((procdir = "/proc/" + Long.toString(pid)) + "/cwd", execEnv)) != null && path.length() > 0) {
            return path;
        }
        return null;
    }
}

