/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ExecutionException;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;

class Md5checker {
    private final ExecutionEnvironment executionEnvironment;

    public Md5checker(ExecutionEnvironment env) {
        this.executionEnvironment = env;
    }

    public Result check(File localFile, String remotePath) throws NoSuchAlgorithmException, IOException, CheckSumException, InterruptedException, ExecutionException, ConnectionManager.CancellationException {
        String remoteCheckSum;
        boolean first;
        String[] args;
        String cmd;
        HostInfo hostIinfo = HostInfoUtils.getHostInfo(this.executionEnvironment);
        if (hostIinfo == null) {
            throw new CheckSumException("Can not get HostInfo for " + this.executionEnvironment);
        }
        HostInfo.OSFamily oSFamily = hostIinfo.getOSFamily();
        switch (oSFamily) {
            case LINUX: {
                cmd = "/usr/bin/md5sum";
                args = new String[]{"-b", remotePath};
                first = true;
                break;
            }
            case SUNOS: {
                cmd = "/usr/bin/digest";
                args = new String[]{"-a", "md5", remotePath};
                first = true;
                break;
            }
            case MACOSX: {
                cmd = "sh";
                args = new String[]{"-c", String.format("md5 %s || openssl -md5 %s", remotePath, remotePath)};
                first = false;
                break;
            }
            default: {
                throw new NoSuchAlgorithmException("Unexpected OS: " + (Object)((Object)oSFamily));
            }
        }
        ProcessUtils.ExitStatus result = ProcessUtils.execute(this.executionEnvironment, cmd, args);
        if (!result.isOK() || result.output.isEmpty()) {
            return Result.INEXISTENT;
        }
        String localCheckSum = this.getLocalChecksum(localFile);
        String[] parts = result.output.split(" ");
        if (parts.length == 0) {
            throw new CheckSumException("Line shouldn't be empty");
        }
        String string = remoteCheckSum = first ? parts[0] : parts[parts.length - 1];
        if (remoteCheckSum.equals(localCheckSum)) {
            return Result.UPTODATE;
        }
        return Result.DIFFERS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLocalChecksum(File file) throws NoSuchAlgorithmException, FileNotFoundException, IOException {
        if (file != null && file.exists()) {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            try {
                int read;
                byte[] buf = new byte[8192];
                while ((read = ((InputStream)is).read(buf)) != -1) {
                    md5.update(buf, 0, read);
                }
            }
            finally {
                ((InputStream)is).close();
            }
            byte[] checkSum = md5.digest();
            return Md5checker.toHexString(checkSum);
        }
        return null;
    }

    private static String toHexString(byte[] data) {
        char[] result = new char[data.length * 2];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < 2; ++j) {
                int half = j == 0 ? (data[i] & 0xF0) >>> 4 : data[i] & 0xF;
                result[2 * i + j] = 0 <= half && half <= 9 ? (char)(48 + half) : (char)(97 + (half - 10));
            }
        }
        return new String(result);
    }

    public static class CheckSumException
    extends Exception {
        public CheckSumException(String message) {
            super(message);
        }
    }

    public static enum Result {
        INEXISTENT,
        UPTODATE,
        DIFFERS;

    }
}

