/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.pty;

import java.io.IOException;
import org.netbeans.modules.nativeexecution.ExProcessInfoProvider;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.pty.Pty;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.Shell;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.netbeans.modules.nativeexecution.pty.IOConnector;
import org.netbeans.modules.nativeexecution.pty.PtyAllocator;
import org.netbeans.modules.nativeexecution.pty.SttySupport;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.openide.util.Exceptions;
import org.openide.windows.InputOutput;

public final class PtySupport {
    private static final java.util.logging.Logger log = Logger.getInstance();

    private PtySupport() {
    }

    public static String getTTY(NativeProcess process) {
        if (process instanceof ExProcessInfoProvider) {
            return ((ExProcessInfoProvider)((Object)process)).getTTY();
        }
        return null;
    }

    public static boolean connect(InputOutput io, NativeProcess process) {
        return IOConnector.getInstance().connect(io, process);
    }

    public static boolean connect(InputOutput io, Pty pty) {
        return IOConnector.getInstance().connect(io, pty);
    }

    public static Pty allocate(ExecutionEnvironment env) throws IOException {
        if (!ConnectionManager.getInstance().isConnectedTo(env)) {
            throw new IllegalStateException();
        }
        return PtyAllocator.getInstance().allocate(env);
    }

    public static void deallocate(Pty pty) throws IOException {
        pty.close();
    }

    public static void disableEcho(ExecutionEnvironment exEnv, String tty) {
        SttySupport.apply(exEnv, tty, "-echo");
    }

    @Deprecated
    public static void setBackspaceAsEraseChar(ExecutionEnvironment exEnv, String tty) {
        SttySupport.apply(exEnv, tty, "erase \\^H");
    }

    public static boolean isSupportedFor(ExecutionEnvironment executionEnvironment) {
        if (!HostInfoUtils.isHostInfoAvailable(executionEnvironment)) {
            return false;
        }
        try {
            HostInfo hostInfo = HostInfoUtils.getHostInfo(executionEnvironment);
            switch (hostInfo.getOSFamily()) {
                case WINDOWS: {
                    Shell shell = WindowsSupport.getInstance().getActiveShell();
                    if (shell == null) {
                        return false;
                    }
                    return shell.type == Shell.ShellType.CYGWIN;
                }
                case MACOSX: {
                    return true;
                }
                case LINUX: {
                    return hostInfo.getCpuFamily().equals((Object)HostInfo.CpuFamily.X86);
                }
                case SUNOS: {
                    return true;
                }
            }
            return false;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ConnectionManager.CancellationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return false;
    }
}

