/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution;

import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.nativeexecution.ExecutionEnvironmentImpl;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.spi.ExecutionEnvironmentFactoryService;

public final class ExecutionEnvironmentFactoryServiceImpl
implements ExecutionEnvironmentFactoryService {
    static final String DEFAULT_USER = System.getProperty("user.name");
    private static final int DEFAULT_PORT = Integer.getInteger("cnd.remote.port", 22);
    private static final ExecutionEnvironment LOCAL = new ExecutionEnvironmentImpl(DEFAULT_USER, "localhost", 0);
    private static final ConcurrentHashMap<String, ExecutionEnvironment> cache = new ConcurrentHashMap();

    @Override
    public ExecutionEnvironment getLocal() {
        return LOCAL;
    }

    @Override
    public ExecutionEnvironment createNew(String user, String host) {
        return this.createNew(user, host, DEFAULT_PORT);
    }

    @Override
    public ExecutionEnvironment createNew(String user, String host, int port) {
        if (user == null) {
            user = DEFAULT_USER;
        }
        if (host == null) {
            host = "localhost";
        }
        if (port == 0) {
            port = DEFAULT_PORT;
        }
        return new ExecutionEnvironmentImpl(user, host, port);
    }

    @Override
    public String toUniqueID(ExecutionEnvironment executionEnvironment) {
        if (!(executionEnvironment instanceof ExecutionEnvironmentImpl)) {
            return null;
        }
        return ExecutionEnvironmentFactoryServiceImpl.toExternalForm((ExecutionEnvironmentImpl)executionEnvironment);
    }

    @Override
    public ExecutionEnvironment fromUniqueID(String hostKey) {
        ExecutionEnvironment old;
        ExecutionEnvironment env = cache.get(hostKey);
        if (env == null && (old = cache.putIfAbsent(hostKey, env = this.fromExternalForm(hostKey))) != null) {
            env = old;
        }
        return env;
    }

    static String toExternalForm(ExecutionEnvironmentImpl env) {
        int sshPort = env.getSSHPort();
        if (sshPort == 0) {
            return "localhost";
        }
        String host = env.getHost();
        String user = env.getUser();
        StringBuilder sb = new StringBuilder();
        if (user != null) {
            sb.append(user).append('@');
        }
        sb.append(host).append(':').append(sshPort);
        return sb.toString();
    }

    ExecutionEnvironment fromExternalForm(String externalForm) {
        String host;
        String port;
        int pos;
        String user;
        if ("localhost".equals(externalForm) || "127.0.0.1".equals(externalForm) || "::1".contains(externalForm)) {
            return LOCAL;
        }
        int atPos = externalForm.indexOf(64);
        String string = user = atPos > 0 ? externalForm.substring(0, atPos) : null;
        if (user != null) {
            externalForm = externalForm.substring(user.length() + 1);
        }
        if ((pos = externalForm.lastIndexOf(58)) < 0) {
            port = null;
            host = externalForm;
        } else {
            port = externalForm.substring(pos + 1);
            host = externalForm.substring(0, pos);
        }
        int sshPort = 0;
        if (port != null) {
            try {
                sshPort = Integer.parseInt(port);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        return this.createNew(user, host, sshPort);
    }

    @Override
    public ExecutionEnvironment createNew(String schema) {
        return null;
    }
}

