/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.model;

import java.text.NumberFormat;
import java.util.List;
import javax.swing.ImageIcon;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.heapwalk.model.AbstractHeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.model.Bundle;
import org.netbeans.modules.profiler.heapwalk.model.ChildrenComputer;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNodeFactory;

public class ClassNode
extends AbstractHeapWalkerNode {
    private static final NumberFormat numberFormat = NumberFormat.getInstance();
    private JavaClass javaClass;
    private String name;

    public ClassNode(JavaClass javaClass, String name, HeapWalkerNode parent) {
        this(javaClass, name, parent, parent == null ? 1 : parent.getMode());
    }

    public ClassNode(JavaClass javaClass, String name, HeapWalkerNode parent, int mode) {
        super(parent, mode);
        this.javaClass = javaClass;
        this.name = name;
    }

    public JavaClass getJavaClass() {
        return this.javaClass;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    protected HeapWalkerNode[] computeChildren() {
        return BrowserUtils.lazilyCreateChildren(this, new ChildrenComputer(){

            @Override
            public HeapWalkerNode[] computeChildren() {
                HeapWalkerNode[] children = null;
                List fieldValues = ClassNode.this.getJavaClass().getStaticFieldValues();
                if (fieldValues.size() == 0) {
                    children = new HeapWalkerNode[]{HeapWalkerNodeFactory.createNoFieldsNode(ClassNode.this)};
                } else {
                    children = new HeapWalkerNode[fieldValues.size()];
                    for (int i = 0; i < children.length; ++i) {
                        children[i] = HeapWalkerNodeFactory.createFieldNode((FieldValue)fieldValues.get(i), ClassNode.this);
                    }
                }
                return children;
            }
        });
    }

    @Override
    protected ImageIcon computeIcon() {
        return BrowserUtils.ICON_INSTANCE;
    }

    @Override
    protected String computeName() {
        return this.name;
    }

    @Override
    protected String computeType() {
        return this.javaClass.getName();
    }

    @Override
    protected String computeValue() {
        return Bundle.ClassNode_NoneString();
    }

    @Override
    protected String computeSize() {
        return numberFormat.format(this.javaClass.getAllInstancesSize());
    }

    @Override
    protected String computeRetainedSize() {
        return numberFormat.format(this.javaClass.getRetainedSizeByClass());
    }

    public static abstract class RootNode
    extends ClassNode
    implements org.netbeans.modules.profiler.heapwalk.model.RootNode {
        public RootNode(JavaClass javaClass, String name, HeapWalkerNode parent) {
            super(javaClass, name, parent);
        }

        public RootNode(JavaClass javaClass, String name, HeapWalkerNode parent, int mode) {
            super(javaClass, name, parent, mode);
        }

        @Override
        public abstract void refreshView();
    }
}

