/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.global.format;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractAction;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.lib.editor.util.swing.PositionRegion;
import org.netbeans.modules.editor.global.format.Bundle;
import org.netbeans.modules.editor.indent.api.Reformat;
import org.netbeans.modules.parsing.spi.indexing.PathRecognizer;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.spi.BackupFacility;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.text.NbDocument;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.UserQuestionException;
import org.openide.util.Utilities;

public final class GlobalFormatAction
extends AbstractAction {
    public GlobalFormatAction() {
        this.putValue("Name", "format");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ProgressHandle handle = ProgressHandleFactory.createHandle((String)"Format");
        ProgressUtils.showProgressDialogAndRun((Runnable)new ProgressRunnableImpl(handle), (ProgressHandle)handle, (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doFormat(ProgressHandle handle, AtomicBoolean cancel) throws IOException {
        handle.start();
        try {
            handle.progress(Bundle.LBL_Preparing());
            HashSet<String> sourceIds = new HashSet<String>();
            for (PathRecognizer pr : Lookup.getDefault().lookupAll(PathRecognizer.class)) {
                Set ids = pr.getSourcePathIds();
                if (ids == null) continue;
                sourceIds.addAll(ids);
            }
            Lookup context = Utilities.actionsGlobalContext();
            ArrayList<FileObject> toFormat = new ArrayList<FileObject>();
            HashSet<FileObject> nonRecursiveRoots = new HashSet<FileObject>();
            for (NonRecursiveFolder f : context.lookupAll(NonRecursiveFolder.class)) {
                if (cancel.get()) {
                    return;
                }
                nonRecursiveRoots.add(f.getFolder());
                for (FileObject c : f.getFolder().getChildren()) {
                    if (!c.isData()) continue;
                    toFormat.add(c);
                }
            }
            for (FileObject r : context.lookupAll(FileObject.class)) {
                if (cancel.get()) {
                    return;
                }
                if (nonRecursiveRoots.contains(r)) continue;
                GlobalFormatAction.addRecursivelly(r, toFormat, sourceIds, null, null, cancel);
            }
            for (SourceGroup sg : context.lookupAll(SourceGroup.class)) {
                if (cancel.get()) {
                    return;
                }
                GlobalFormatAction.addRecursivelly(sg.getRootFolder(), toFormat, sourceIds, null, sg, cancel);
            }
            for (DataObject d : context.lookupAll(DataObject.class)) {
                if (cancel.get()) {
                    return;
                }
                if (nonRecursiveRoots.contains(d.getPrimaryFile())) continue;
                GlobalFormatAction.addRecursivelly(d.getPrimaryFile(), toFormat, sourceIds, null, null, cancel);
            }
            Collection projects = context.lookupAll(Project.class);
            if (!projects.isEmpty()) {
                IdentityHashMap<Project, HashMap<FileObject, ClassPath>> sourceRoots = new IdentityHashMap<Project, HashMap<FileObject, ClassPath>>();
                for (String id : sourceIds) {
                    for (ClassPath sCP : GlobalPathRegistry.getDefault().getPaths(id)) {
                        for (FileObject root : sCP.getRoots()) {
                            if (cancel.get()) {
                                return;
                            }
                            Project owner = FileOwnerQuery.getOwner((FileObject)root);
                            if (owner == null) continue;
                            HashMap<FileObject, ClassPath> projectSources = (HashMap<FileObject, ClassPath>)sourceRoots.get(owner);
                            if (projectSources == null) {
                                projectSources = new HashMap<FileObject, ClassPath>();
                                sourceRoots.put(owner, projectSources);
                            }
                            projectSources.put(root, sCP);
                        }
                    }
                }
                for (Project prj : projects) {
                    Map roots = (Map)sourceRoots.get(prj);
                    if (roots != null) {
                        for (Map.Entry e : roots.entrySet()) {
                            if (cancel.get()) {
                                return;
                            }
                            GlobalFormatAction.addRecursivelly((FileObject)e.getKey(), toFormat, Collections.<String>emptySet(), (ClassPath)e.getValue(), null, cancel);
                        }
                        continue;
                    }
                    for (SourceGroup sg : ProjectUtils.getSources((Project)prj).getSourceGroups("generic")) {
                        if (cancel.get()) {
                            return;
                        }
                        GlobalFormatAction.addRecursivelly(sg.getRootFolder(), toFormat, sourceIds, null, sg, cancel);
                    }
                }
            }
            if (cancel.get()) {
                return;
            }
            BackupFacility bf = BackupFacility.getDefault();
            final BackupFacility.Handle backup = bf.backup(toFormat);
            handle.switchToDeterminate(toFormat.size());
            int done = 0;
            for (FileObject current : toFormat) {
                if (cancel.get()) break;
                try {
                    StyledDocument sd;
                    DataObject d = DataObject.find((FileObject)current);
                    EditorCookie ec = (EditorCookie)d.getLookup().lookup(EditorCookie.class);
                    if (ec == null) continue;
                    handle.progress(Bundle.LBL_Formatting(FileUtil.getFileDisplayName((FileObject)current)));
                    try {
                        sd = ec.openDocument();
                    }
                    catch (UserQuestionException uqe) {
                        uqe.confirmed();
                        sd = ec.openDocument();
                    }
                    final StyledDocument doc = sd;
                    final Reformat reformat = Reformat.get((Document)doc);
                    reformat.lock();
                    try {
                        NbDocument.runAtomic((StyledDocument)doc, (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    GlobalFormatAction.reformat(reformat, doc, 0, doc.getLength(), new AtomicBoolean());
                                }
                                catch (BadLocationException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                            }
                        });
                    }
                    finally {
                        reformat.unlock();
                    }
                    ec.saveDocument();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    handle.progress(++done);
                }
            }
            RefactoringSession session = RefactoringSession.create((String)Bundle.LBL_BulkFormatting());
            FormatRefactoring refactoring = new FormatRefactoring(new Transaction(){
                private boolean first = true;

                public void commit() {
                    if (this.first) {
                        this.first = false;
                    } else {
                        try {
                            backup.restore();
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }

                public void rollback() {
                    try {
                        backup.restore();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
            refactoring.prepare(session);
            session.doRefactoring(false);
        }
        finally {
            handle.finish();
        }
    }

    private static void addRecursivelly(FileObject top, List<FileObject> into, Set<String> sourceIds, ClassPath sourceCP, SourceGroup sg, AtomicBoolean cancel) {
        LinkedList<FileObject> todo = new LinkedList<FileObject>();
        Iterator<String> sIDIter = sourceIds.iterator();
        while (sourceCP == null && sIDIter.hasNext()) {
            if (cancel.get()) {
                return;
            }
            sourceCP = ClassPath.getClassPath((FileObject)top, (String)sIDIter.next());
        }
        todo.add(top);
        while (!todo.isEmpty()) {
            if (cancel.get()) {
                return;
            }
            FileObject current = (FileObject)todo.remove(0);
            if (!VisibilityQuery.getDefault().isVisible(current) || sourceCP != null && !sourceCP.contains(current) || sg != null && !sg.contains(current)) continue;
            if (current.isData()) {
                into.add(current);
            }
            todo.addAll(Arrays.asList(current.getChildren()));
        }
    }

    static void reformat(Reformat formatter, Document doc, int startPos, int endPos, AtomicBoolean canceled) throws BadLocationException {
        GuardedDocument gdoc = doc instanceof GuardedDocument ? (GuardedDocument)doc : null;
        int pos = startPos;
        if (gdoc != null) {
            pos = gdoc.getGuardedBlockChain().adjustToBlockEnd(pos);
        }
        LinkedList<PositionRegion> regions = new LinkedList<PositionRegion>();
        while (pos < endPos) {
            int stopPos = endPos;
            if (gdoc != null && ((stopPos = gdoc.getGuardedBlockChain().adjustToNextBlockStart(pos)) == -1 || stopPos > endPos)) {
                stopPos = endPos;
            }
            if (pos < stopPos) {
                regions.addFirst(new PositionRegion(doc, pos, stopPos));
                pos = stopPos;
            } else {
                ++pos;
            }
            if (gdoc == null) continue;
            pos = gdoc.getGuardedBlockChain().adjustToBlockEnd(pos);
        }
        if (canceled.get()) {
            return;
        }
        for (PositionRegion region : regions) {
            formatter.reformat(region.getStartOffset(), region.getEndOffset());
        }
    }

    public static final class FormatRefactoringPluginFactory
    implements RefactoringPluginFactory {
        public RefactoringPlugin createInstance(AbstractRefactoring refactoring) {
            if (refactoring instanceof FormatRefactoring) {
                return new FormatRefactoringPlugin((FormatRefactoring)refactoring);
            }
            return null;
        }
    }

    static final class FormatRefactoringPlugin
    implements RefactoringPlugin {
        private final FormatRefactoring refactoring;

        public FormatRefactoringPlugin(FormatRefactoring refactoring) {
            this.refactoring = refactoring;
        }

        public Problem preCheck() {
            return null;
        }

        public Problem checkParameters() {
            return null;
        }

        public Problem fastCheckParameters() {
            return null;
        }

        public void cancelRequest() {
        }

        public Problem prepare(RefactoringElementsBag refactoringElements) {
            refactoringElements.registerTransaction(this.refactoring.transaction);
            return null;
        }
    }

    static final class FormatRefactoring
    extends AbstractRefactoring {
        private final Transaction transaction;

        public FormatRefactoring(Transaction transaction) {
            super(Lookup.EMPTY);
            this.transaction = transaction;
        }
    }

    private static class ProgressRunnableImpl
    implements Runnable,
    Cancellable {
        private final ProgressHandle handle;
        private final AtomicBoolean cancel = new AtomicBoolean();

        public ProgressRunnableImpl(ProgressHandle handle) {
            this.handle = handle;
        }

        @Override
        public void run() {
            try {
                GlobalFormatAction.doFormat(this.handle, this.cancel);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public boolean cancel() {
            this.cancel.set(true);
            return true;
        }
    }
}

