/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.module.main;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.css.editor.Css3Utils;
import org.netbeans.modules.css.editor.csl.CssElement;
import org.netbeans.modules.css.editor.module.main.NamespaceCompletionItem;
import org.netbeans.modules.css.editor.module.main.NamespaceStructureItem;
import org.netbeans.modules.css.editor.module.main.TopLevelStructureItem;
import org.netbeans.modules.css.editor.module.spi.CompletionContext;
import org.netbeans.modules.css.editor.module.spi.CssCompletionItem;
import org.netbeans.modules.css.editor.module.spi.CssEditorModule;
import org.netbeans.modules.css.editor.module.spi.EditorFeatureContext;
import org.netbeans.modules.css.editor.module.spi.FeatureContext;
import org.netbeans.modules.css.editor.module.spi.Utilities;
import org.netbeans.modules.css.lib.api.CssTokenId;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.NodeType;
import org.netbeans.modules.css.lib.api.NodeUtil;
import org.netbeans.modules.css.lib.api.NodeVisitor;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.model.api.Namespace;
import org.netbeans.modules.css.model.api.Namespaces;
import org.netbeans.modules.css.model.api.StyleSheet;
import org.netbeans.modules.web.common.api.LexerUtils;

public class NamespacesModule
extends CssEditorModule {
    private static final String NAMESPACE_KEYWORD = "@namespace";
    static ElementKind NAMESPACE_ELEMENT_KIND = ElementKind.GLOBAL;

    @Override
    public List<CompletionProposal> getCompletionProposals(CompletionContext context) {
        boolean isError;
        ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
        Node activeNode = context.getActiveNode();
        boolean bl = isError = activeNode.type() == NodeType.error;
        if (isError) {
            activeNode = activeNode.parent();
        }
        switch (activeNode.type()) {
            case namespacePrefix: 
            case elementName: {
                proposals.addAll(NamespacesModule.getNamespaceCompletionProposals(context));
                break;
            }
            case root: 
            case styleSheet: 
            case body: {
                CssCompletionItem nsKeywordProposal = CssCompletionItem.createRAWCompletionItem(new CssElement(NAMESPACE_KEYWORD), NAMESPACE_KEYWORD, ElementKind.FIELD, context.getAnchorOffset(), false);
                proposals.add(nsKeywordProposal);
            }
            case bodyItem: 
            case media: 
            case combinator: 
            case selector: {
                proposals.addAll(NamespacesModule.getNamespaceCompletionProposals(context));
                break;
            }
            case elementSubsequent: 
            case typeSelector: {
                CssTokenId tokenNodeTokenId;
                CssTokenId cssTokenId = tokenNodeTokenId = context.getActiveTokenNode().type() == NodeType.token ? NodeUtil.getTokenNodeTokenId((Node)context.getActiveTokenNode()) : null;
                if (tokenNodeTokenId != CssTokenId.WS) break;
                proposals.addAll(NamespacesModule.getNamespaceCompletionProposals(context));
                break;
            }
            case generic_at_rule: {
                proposals.add(CssCompletionItem.createRAWCompletionItem(new CssElement(NAMESPACE_KEYWORD), NAMESPACE_KEYWORD, ElementKind.FIELD, context.getAnchorOffset(), false));
                break;
            }
            case namespace: {
                CssTokenId tokenId = (CssTokenId)context.getTokenSequence().token().id();
                if (tokenId == CssTokenId.NAMESPACE_SYM) {
                    CssCompletionItem nsKeywordProposal = CssCompletionItem.createRAWCompletionItem(new CssElement(NAMESPACE_KEYWORD), NAMESPACE_KEYWORD, ElementKind.FIELD, context.getAnchorOffset(), false);
                    proposals.add(nsKeywordProposal);
                }
            }
            case simpleSelectorSequence: {
                if (!isError) break;
                Token token = context.getTokenSequence().token();
                switch ((CssTokenId)token.id()) {
                    case IDENT: {
                        if (LexerUtils.followsToken(context.getTokenSequence(), EnumSet.of(CssTokenId.LBRACKET, CssTokenId.COMMA), (boolean)true, (boolean)true, (TokenId[])new TokenId[]{CssTokenId.WS}) == null) break;
                        proposals.addAll(NamespacesModule.getNamespaceCompletionProposals(context));
                        break;
                    }
                    case LBRACKET: 
                    case WS: {
                        proposals.addAll(NamespacesModule.getNamespaceCompletionProposals(context));
                    }
                }
                break;
            }
            case slAttribute: 
            case slAttributeName: 
            case namespacePrefixName: {
                proposals.addAll(NamespacesModule.getNamespaceCompletionProposals(context));
            }
        }
        return Css3Utils.filterCompletionProposals(proposals, context.getPrefix(), true);
    }

    private static List<CompletionProposal> getNamespaceCompletionProposals(final CompletionContext context) {
        final ArrayList<CompletionProposal> proposals = new ArrayList<CompletionProposal>();
        Model sourceModel = context.getSourceModel();
        sourceModel.runReadTask(new Model.ModelTask(){

            public void run(StyleSheet styleSheet) {
                Namespaces namespaces = styleSheet.getNamespaces();
                if (namespaces == null) {
                    return;
                }
                for (Namespace ns : namespaces.getNamespaces()) {
                    proposals.add(new NamespaceCompletionItem(((Object)ns.getNamespacePrefixName().getContent()).toString(), ((Object)ns.getResourceIdentifier().getContent()).toString(), context.getAnchorOffset()));
                }
            }
        });
        return proposals;
    }

    @Override
    public <T extends Map<OffsetRange, Set<ColoringAttributes>>> NodeVisitor<T> getSemanticHighlightingNodeVisitor(FeatureContext context, T result) {
        return new NodeVisitor<T>(result){

            public boolean visit(Node node) {
                switch (node.type()) {
                    case namespacePrefix: {
                        ((Map)this.getResult()).put(Css3Utils.getOffsetRange(node), ColoringAttributes.CONSTRUCTOR_SET);
                    }
                }
                return false;
            }
        };
    }

    @Override
    public <T extends Set<OffsetRange>> NodeVisitor<T> getMarkOccurrencesNodeVisitor(EditorFeatureContext context, T result) {
        return Utilities.createMarkOccurrencesNodeVisitor(context, result, NodeType.namespacePrefix);
    }

    @Override
    public <T extends List<StructureItem>> NodeVisitor<T> getStructureItemsNodeVisitor(final FeatureContext context, T result) {
        final ArrayList<StructureItem> items = new ArrayList<StructureItem>();
        result.add((TopLevelStructureItem.Namespaces)new TopLevelStructureItem.Namespaces(items));
        return new NodeVisitor<T>(){

            public boolean visit(Node node) {
                if (node.type() == NodeType.namespace) {
                    items.add(new NamespaceStructureItem(context.getFileObject(), node));
                }
                return false;
            }
        };
    }
}

