/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.module.main;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.css.editor.Css3Utils;
import org.netbeans.modules.css.editor.CssHelpResolver;
import org.netbeans.modules.css.editor.csl.CssNodeElement;
import org.netbeans.modules.css.editor.module.main.CssRuleStructureItem;
import org.netbeans.modules.css.editor.module.main.PropertyCompatibilityHelpResolver;
import org.netbeans.modules.css.editor.module.main.StandardPropertiesHelpResolver;
import org.netbeans.modules.css.editor.module.main.TopLevelStructureItem;
import org.netbeans.modules.css.editor.module.spi.CssEditorModule;
import org.netbeans.modules.css.editor.module.spi.EditorFeatureContext;
import org.netbeans.modules.css.editor.module.spi.FeatureContext;
import org.netbeans.modules.css.editor.module.spi.FutureParamTask;
import org.netbeans.modules.css.editor.module.spi.HelpResolver;
import org.netbeans.modules.css.editor.module.spi.Utilities;
import org.netbeans.modules.css.lib.api.CssModule;
import org.netbeans.modules.css.lib.api.CssTokenId;
import org.netbeans.modules.css.lib.api.Node;
import org.netbeans.modules.css.lib.api.NodeType;
import org.netbeans.modules.css.lib.api.NodeUtil;
import org.netbeans.modules.css.lib.api.NodeVisitor;
import org.netbeans.modules.css.lib.api.properties.PropertyDefinition;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.modules.web.common.api.Lines;
import org.netbeans.modules.web.common.api.Pair;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class DefaultCssEditorModule
extends CssEditorModule {
    private static final Pattern URI_PATTERN = Pattern.compile("url\\(\\s*(.*)\\s*\\)");
    private static final String MODULE_PATH_BASE = "org/netbeans/modules/css/editor/module/main/properties/";
    private static final CssModule[] MODULE_PROPERTY_DEFINITION_FILE_NAMES = new CssModule[]{DefaultCssEditorModule.module("default_module", "http://www.w3.org/TR/CSS2"), DefaultCssEditorModule.module("marquee", "http://www.w3.org/TR/css3-marquee"), DefaultCssEditorModule.module("ruby", "http://www.w3.org/TR/css3-ruby"), DefaultCssEditorModule.module("multi-column_layout", "http://www.w3.org/TR/css3-multicol"), DefaultCssEditorModule.module("values_and_units", "http://www.w3.org/TR/css3-values"), DefaultCssEditorModule.module("text", "http://www.w3.org/TR/css3-text"), DefaultCssEditorModule.module("writing_modes", "http://www.w3.org/TR/css3-writing-modes"), DefaultCssEditorModule.module("generated_content_for_paged_media", "http://www.w3.org/TR/css3-gcpm"), DefaultCssEditorModule.module("fonts", "http://www.w3.org/TR/css3-fonts"), DefaultCssEditorModule.module("basic_box_model", "http://www.w3.org/TR/css3-box"), DefaultCssEditorModule.module("speech", "http://www.w3.org/TR/css3-speech"), DefaultCssEditorModule.module("flexible_box_layout", "http://www.w3.org/TR/css3-flexbox"), DefaultCssEditorModule.module("image_values", "http://www.w3.org/TR/css3-images"), DefaultCssEditorModule.module("animations", "http://www.w3.org/TR/css3-animations"), DefaultCssEditorModule.module("transforms_2d", "http://www.w3.org/TR/css3-2d-transforms"), DefaultCssEditorModule.module("transforms_3d", "http://www.w3.org/TR/css3-3d-transforms"), DefaultCssEditorModule.module("transitions", "http://www.w3.org/TR/css3-transitions"), DefaultCssEditorModule.module("line", "http://www.w3.org/TR/css3-linebox"), DefaultCssEditorModule.module("hyperlinks", "http://www.w3.org/TR/css3-hyperlinks"), DefaultCssEditorModule.module("presentation_levels", "http://www.w3.org/TR/css3-preslev"), DefaultCssEditorModule.module("generated_and_replaced_content", "http://www.w3.org/TR/css3-content")};
    private static Map<String, PropertyDefinition> propertyDescriptors;

    private static CssModule module(String name, String url) {
        return new DefaultCssModule(name, url);
    }

    private synchronized Map<String, PropertyDefinition> getProperties() {
        if (propertyDescriptors == null) {
            propertyDescriptors = new HashMap<String, PropertyDefinition>();
            for (CssModule module : MODULE_PROPERTY_DEFINITION_FILE_NAMES) {
                String path = MODULE_PATH_BASE + module.getName();
                propertyDescriptors.putAll(Utilities.parsePropertyDefinitionFile(path, module));
            }
        }
        return propertyDescriptors;
    }

    @Override
    public Collection<String> getPropertyNames(FileObject file) {
        return this.getProperties().keySet();
    }

    @Override
    public PropertyDefinition getPropertyDefinition(String propertyName) {
        return this.getProperties().get(propertyName);
    }

    @Override
    public Collection<HelpResolver> getHelpResolvers(FileObject context) {
        return Arrays.asList(new Css21HelpResolver(), new PropertyCompatibilityHelpResolver(), new StandardPropertiesHelpResolver());
    }

    @Override
    public <T extends Map<OffsetRange, Set<ColoringAttributes>>> NodeVisitor<T> getSemanticHighlightingNodeVisitor(FeatureContext context, T result) {
        final Snapshot snapshot = context.getSnapshot();
        return new NodeVisitor<T>(result){

            public boolean visit(Node node) {
                switch (node.type()) {
                    case elementName: 
                    case cssId: 
                    case cssClass: {
                        if (LexerUtils.equals((CharSequence)"@@@", (CharSequence)node.image(), (boolean)false, (boolean)false)) break;
                        int dso = snapshot.getOriginalOffset(node.from());
                        if (dso == -1) {
                            dso = snapshot.getOriginalOffset(node.from() + 1);
                        }
                        int deo = snapshot.getOriginalOffset(node.to());
                        if (dso < 0 || deo < 0) break;
                        OffsetRange range = new OffsetRange(dso, deo);
                        ((Map)this.getResult()).put(range, ColoringAttributes.METHOD_SET);
                        break;
                    }
                    case property: {
                        int dso = snapshot.getOriginalOffset(node.from());
                        int deo = snapshot.getOriginalOffset(node.to());
                        if (dso < 0 || deo < 0) break;
                        OffsetRange range = new OffsetRange(dso, deo);
                        CharSequence propertyName = node.image();
                        if (Css3Utils.containsGeneratedCode(propertyName)) {
                            return false;
                        }
                        EnumSet ca = Css3Utils.isVendorSpecificProperty(propertyName) ? ColoringAttributes.CUSTOM2_SET : ColoringAttributes.CUSTOM1_SET;
                        ((Map)this.getResult()).put(range, ca);
                        break;
                    }
                    case slAttributeName: 
                    case fnAttributeName: {
                        OffsetRange range = Css3Utils.getDocumentOffsetRange(node, snapshot);
                        if (!Css3Utils.isValidOffsetRange(range)) break;
                        ((Map)this.getResult()).put(range, ColoringAttributes.CUSTOM1_SET);
                    }
                }
                return false;
            }
        };
    }

    @Override
    public <T extends Set<OffsetRange>> NodeVisitor<T> getMarkOccurrencesNodeVisitor(EditorFeatureContext context, T result) {
        final Snapshot snapshot = context.getSnapshot();
        int astCaretOffset = snapshot.getEmbeddedOffset(context.getCaretOffset());
        if (astCaretOffset == -1) {
            return null;
        }
        Node current = NodeUtil.findNonTokenNodeAtOffset((Node)context.getParseTreeRoot(), (int)astCaretOffset);
        if (current == null) {
            return null;
        }
        if (!NodeUtil.isSelectorNode((Node)current)) {
            return null;
        }
        final NodeType nodeType = current.type();
        final CharSequence currentNodeImage = current.image();
        return new NodeVisitor<T>(result){

            public boolean visit(Node node) {
                if (nodeType == node.type()) {
                    boolean ignoreCase;
                    boolean bl = ignoreCase = nodeType == NodeType.hexColor;
                    if (LexerUtils.equals((CharSequence)currentNodeImage, (CharSequence)node.image(), (boolean)ignoreCase, (boolean)false)) {
                        int[] trimmedNodeRange = NodeUtil.getTrimmedNodeRange((Node)node);
                        int docFrom = snapshot.getOriginalOffset(trimmedNodeRange[0]);
                        if (docFrom == -1 && (node.type() == NodeType.cssClass || node.type() == NodeType.cssId)) {
                            docFrom = snapshot.getOriginalOffset(trimmedNodeRange[0] + 1);
                        }
                        int docTo = snapshot.getOriginalOffset(trimmedNodeRange[1]);
                        if (docFrom != -1 && docTo != -1) {
                            ((Set)this.getResult()).add(new OffsetRange(docFrom, docTo));
                        }
                    }
                }
                return false;
            }
        };
    }

    @Override
    public <T extends Map<String, List<OffsetRange>>> NodeVisitor<T> getFoldsNodeVisitor(FeatureContext context, T result) {
        final Snapshot snapshot = context.getSnapshot();
        final Lines lines = new Lines(snapshot.getText());
        return new NodeVisitor<T>(result){

            public boolean visit(Node node) {
                int from = -1;
                int to = -1;
                switch (node.type()) {
                    case rule: 
                    case media: 
                    case page: 
                    case webkitKeyframes: 
                    case generic_at_rule: 
                    case vendorAtRule: {
                        Node[] tokenNodes;
                        for (Node leafNode : tokenNodes = NodeUtil.getChildrenByType((Node)node, (NodeType)NodeType.token)) {
                            if (CharSequenceUtilities.equals((CharSequence)"{", (Object)leafNode.image())) {
                                from = leafNode.from();
                                continue;
                            }
                            if (!CharSequenceUtilities.equals((CharSequence)"}", (Object)leafNode.image())) continue;
                            to = leafNode.to();
                        }
                        if (from == -1 || to == -1) break;
                        int doc_from = snapshot.getOriginalOffset(from);
                        int doc_to = snapshot.getOriginalOffset(to);
                        try {
                            if (doc_from < 0 || doc_to < 0 || lines.getLineIndex(from) >= lines.getLineIndex(to)) break;
                            ArrayList<OffsetRange> codeblocks = (ArrayList<OffsetRange>)((Map)this.getResult()).get("codeblocks");
                            if (codeblocks == null) {
                                codeblocks = new ArrayList<OffsetRange>();
                                ((Map)this.getResult()).put("codeblocks", codeblocks);
                            }
                            codeblocks.add(new OffsetRange(doc_from, doc_to));
                            break;
                        }
                        catch (BadLocationException ex) {
                            // empty catch block
                        }
                    }
                }
                return false;
            }
        };
    }

    @Override
    public Pair<OffsetRange, FutureParamTask<DeclarationFinder.DeclarationLocation, EditorFeatureContext>> getDeclaration(Document document, int caretOffset) {
        TokenSequence ts = LexerUtils.getJoinedTokenSequence((Document)document, (int)caretOffset, (Language)CssTokenId.language());
        if (ts == null) {
            return null;
        }
        OffsetRange foundRange = null;
        Token token = ts.token();
        int quotesDiff = WebUtils.isValueQuoted((CharSequence)((Object)ts.token().text()).toString()) ? 1 : 0;
        OffsetRange range = new OffsetRange(ts.offset() + quotesDiff, ts.offset() + ts.token().length() - quotesDiff);
        if ((token.id() == CssTokenId.STRING || token.id() == CssTokenId.URI) && ts.movePrevious() && ts.token().id() == CssTokenId.IMPORT_SYM) {
            foundRange = range;
        }
        if (foundRange == null) {
            return null;
        }
        FutureParamTask<DeclarationFinder.DeclarationLocation, EditorFeatureContext> callable = new FutureParamTask<DeclarationFinder.DeclarationLocation, EditorFeatureContext>(){

            @Override
            public DeclarationFinder.DeclarationLocation run(EditorFeatureContext context) {
                Matcher m;
                TokenSequence ts = LexerUtils.getJoinedTokenSequence((Document)context.getDocument(), (int)context.getCaretOffset(), (Language)CssTokenId.language());
                if (ts == null) {
                    return null;
                }
                Token valueToken = ts.token();
                String valueText = ((Object)valueToken.text()).toString();
                if (valueToken.id() == CssTokenId.URI && (m = URI_PATTERN.matcher(valueToken.text())).matches()) {
                    int groupIndex = 1;
                    valueText = m.group(groupIndex);
                }
                valueText = WebUtils.unquotedValue((CharSequence)valueText);
                FileObject resolved = WebUtils.resolve((FileObject)context.getSource().getFileObject(), (String)valueText);
                return resolved != null ? new DeclarationFinder.DeclarationLocation(resolved, 0) : null;
            }
        };
        return new Pair((Object)foundRange, (Object)callable);
    }

    @Override
    public <T extends List<StructureItem>> NodeVisitor<T> getStructureItemsNodeVisitor(FeatureContext context, T result) {
        final ArrayList<StructureItem> rules = new ArrayList<StructureItem>();
        final ArrayList<StructureItem> atrules = new ArrayList<StructureItem>();
        final HashSet<StructureItem> classes = new HashSet<StructureItem>();
        final HashSet<StructureItem> ids = new HashSet<StructureItem>();
        final HashSet<StructureItem> elements = new HashSet<StructureItem>();
        result.add((TopLevelStructureItem.Rules)new TopLevelStructureItem.Rules(rules, context));
        result.add((TopLevelStructureItem.AtRules)new TopLevelStructureItem.AtRules(atrules));
        result.add((TopLevelStructureItem.Classes)new TopLevelStructureItem.Classes(classes));
        result.add((TopLevelStructureItem.Ids)new TopLevelStructureItem.Ids(ids));
        result.add((TopLevelStructureItem.Elements)new TopLevelStructureItem.Elements(elements));
        final Snapshot snapshot = context.getSnapshot();
        final FileObject file = context.getFileObject();
        return new NodeVisitor<T>(){

            public boolean visit(Node node) {
                switch (node.type()) {
                    case selectorsGroup: {
                        Node ruleNode = node.parent();
                        assert (ruleNode.type() == NodeType.rule);
                        int so = snapshot.getOriginalOffset(ruleNode.from());
                        int eo = snapshot.getOriginalOffset(ruleNode.to());
                        if (eo <= so) break;
                        CssRuleStructureItem item = new CssRuleStructureItem(node.image(), CssNodeElement.createElement(file, ruleNode), snapshot);
                        rules.add(item);
                        break;
                    }
                    case elementName: {
                        elements.add(new CssRuleStructureItemHashableByName(node.image(), CssNodeElement.createElement(file, node), snapshot));
                        break;
                    }
                    case cssClass: {
                        classes.add(new CssRuleStructureItemHashableByName(node.image(), CssNodeElement.createElement(file, node), snapshot));
                        break;
                    }
                    case cssId: {
                        ids.add(new CssRuleStructureItemHashableByName(node.image(), CssNodeElement.createElement(file, node), snapshot));
                        break;
                    }
                    case charSet: 
                    case imports: 
                    case namespace: {
                        atrules.add(new CssRuleStructureItem(node.image(), CssNodeElement.createElement(file, node), snapshot));
                        break;
                    }
                    case fontFace: {
                        Node tokenNode = NodeUtil.getChildTokenNode((Node)node, (CssTokenId)CssTokenId.FONT_FACE_SYM);
                        atrules.add(new CssRuleStructureItem(tokenNode.image(), CssNodeElement.createElement(file, node), snapshot));
                        break;
                    }
                    case mediaQueryList: {
                        Node mediaNode = node.parent();
                        assert (mediaNode.type() == NodeType.media);
                        StringBuilder image = new StringBuilder();
                        image.append("@media ");
                        image.append(node.image());
                        atrules.add(new CssRuleStructureItem(image, CssNodeElement.createElement(file, mediaNode), snapshot));
                        break;
                    }
                    case page: {
                        Node pageSymbolNode = NodeUtil.getChildTokenNode((Node)node, (CssTokenId)CssTokenId.PAGE_SYM);
                        Node lbraceSymbolNode = NodeUtil.getChildTokenNode((Node)node, (CssTokenId)CssTokenId.LBRACE);
                        if (pageSymbolNode == null || lbraceSymbolNode == null) break;
                        CharSequence headingAreaImage = snapshot.getText().subSequence(pageSymbolNode.from(), lbraceSymbolNode.from());
                        atrules.add(new CssRuleStructureItem(headingAreaImage, CssNodeElement.createElement(file, node), snapshot));
                        break;
                    }
                    case counterStyle: {
                        Node identNode = NodeUtil.getChildTokenNode((Node)node, (CssTokenId)CssTokenId.IDENT);
                        if (identNode == null) break;
                        StringBuilder image = new StringBuilder();
                        image.append("@counter-style ");
                        image.append(identNode.image());
                        atrules.add(new CssRuleStructureItem(image, CssNodeElement.createElement(file, node), snapshot));
                    }
                }
                return false;
            }
        };
    }

    private static class CssRuleStructureItemHashableByName
    extends CssRuleStructureItem {
        public CssRuleStructureItemHashableByName(CharSequence name, CssNodeElement element, Snapshot source) {
            super(name, element, source);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CssRuleStructureItemHashableByName other = (CssRuleStructureItemHashableByName)obj;
            return this.getName() == other.getName() || this.getName() != null && this.getName().equals(other.getName());
        }

        @Override
        public int hashCode() {
            int hash = 5;
            hash = 89 * hash + (this.getName() != null ? this.getName().hashCode() : 0);
            return hash;
        }
    }

    private static class Css21HelpResolver
    extends HelpResolver {
        private Css21HelpResolver() {
        }

        @Override
        public String getHelp(FileObject context, PropertyDefinition property) {
            return CssHelpResolver.instance().getPropertyHelp(property.getName());
        }

        @Override
        public URL resolveLink(FileObject context, PropertyDefinition property, String link) {
            return null;
        }

        @Override
        public int getPriority() {
            return 100;
        }
    }

    private static class DefaultCssModule
    implements CssModule {
        private String name;
        private String url;

        public DefaultCssModule(String name, String url) {
            this.name = name;
            this.url = url;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return NbBundle.getMessage(this.getClass(), (String)("css-module-displayname-" + this.getName()));
        }

        public String getSpecificationURL() {
            return this.url;
        }

        public String toString() {
            return "DefaultCssModule(" + this.getDisplayName() + '/' + this.getSpecificationURL() + ')';
        }
    }
}

